/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryHeap;
import java.util.UUID;

public abstract class VMThinDiskLRURegionEntryHeap
extends VMThinDiskLRURegionEntry {
    private static final VMThinDiskLRURegionEntryHeapFactory factory = new VMThinDiskLRURegionEntryHeapFactory();

    public VMThinDiskLRURegionEntryHeap(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinDiskLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMThinDiskLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key2, Object value2) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key2.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinDiskLRURegionEntryHeapIntKey(context, (Integer)key2, value2);
                }
                if (keyClass == Long.class) {
                    return new VMThinDiskLRURegionEntryHeapLongKey(context, (Long)key2, value2);
                }
                if (keyClass == String.class) {
                    String skey = (String)key2;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinDiskLRURegionEntryHeapStringKey1(context, skey, value2, byteEncoded);
                        }
                        return new VMThinDiskLRURegionEntryHeapStringKey2(context, skey, value2, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinDiskLRURegionEntryHeapUUIDKey(context, (UUID)key2, value2);
                }
            }
            return new VMThinDiskLRURegionEntryHeapObjectKey(context, key2, value2);
        }

        @Override
        public final Class getEntryClass() {
            return VMThinDiskLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinDiskLRURegionEntryHeap.getEntryFactory();
        }
    }
}

