/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeap;
import java.util.UUID;

public abstract class VMThinDiskRegionEntryHeap
extends VMThinDiskRegionEntry {
    private static final VMThinDiskRegionEntryHeapFactory factory = new VMThinDiskRegionEntryHeapFactory();

    public VMThinDiskRegionEntryHeap(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinDiskRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMThinDiskRegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key2, Object value2) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key2.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinDiskRegionEntryHeapIntKey(context, (Integer)key2, value2);
                }
                if (keyClass == Long.class) {
                    return new VMThinDiskRegionEntryHeapLongKey(context, (Long)key2, value2);
                }
                if (keyClass == String.class) {
                    String skey = (String)key2;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinDiskRegionEntryHeapStringKey1(context, skey, value2, byteEncoded);
                        }
                        return new VMThinDiskRegionEntryHeapStringKey2(context, skey, value2, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinDiskRegionEntryHeapUUIDKey(context, (UUID)key2, value2);
                }
            }
            return new VMThinDiskRegionEntryHeapObjectKey(context, key2, value2);
        }

        @Override
        public final Class getEntryClass() {
            return VMThinDiskRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinDiskRegionEntryHeap.getEntryFactory();
        }
    }
}

