/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryHeap;
import com.gemstone.gemfire.internal.util.concurrent.CustomEntryConcurrentHashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class VMThinRegionEntryHeapUUIDKey
extends VMThinRegionEntryHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VMThinRegionEntryHeapUUIDKey> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VMThinRegionEntryHeapUUIDKey.class, "lastModified");
    private volatile Object value;
    private final long keyMostSigBits;
    private final long keyLeastSigBits;

    public VMThinRegionEntryHeapUUIDKey(RegionEntryContext context, UUID key2, Object value2) {
        super(context, value2);
        this.keyMostSigBits = key2.getMostSignificantBits();
        this.keyLeastSigBits = key2.getLeastSignificantBits();
    }

    @Override
    protected final Object areGetValue() {
        return this.value;
    }

    @Override
    protected void areSetValue(Object v) {
        this.value = v;
    }

    @Override
    protected long getlastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public final int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public final CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public final void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    @Override
    public final Object getKey() {
        return new UUID(this.keyMostSigBits, this.keyLeastSigBits);
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof UUID) {
            UUID uuid = (UUID)k;
            return uuid.getLeastSignificantBits() == this.keyLeastSigBits && uuid.getMostSignificantBits() == this.keyMostSigBits;
        }
        return false;
    }
}

