/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedStatsRegionEntryHeap
extends VersionedStatsRegionEntry {
    private static final VersionedStatsRegionEntryHeapFactory factory = new VersionedStatsRegionEntryHeapFactory();

    public VersionedStatsRegionEntryHeap(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsRegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key2, Object value2) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key2.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsRegionEntryHeapIntKey(context, (Integer)key2, value2);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsRegionEntryHeapLongKey(context, (Long)key2, value2);
                }
                if (keyClass == String.class) {
                    String skey = (String)key2;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsRegionEntryHeapStringKey1(context, skey, value2, byteEncoded);
                        }
                        return new VersionedStatsRegionEntryHeapStringKey2(context, skey, value2, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsRegionEntryHeapUUIDKey(context, (UUID)key2, value2);
                }
            }
            return new VersionedStatsRegionEntryHeapObjectKey(context, key2, value2);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedStatsRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }
    }
}

