/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedThinDiskLRURegionEntryHeap
extends VersionedThinDiskLRURegionEntry {
    private static final VersionedThinDiskLRURegionEntryHeapFactory factory = new VersionedThinDiskLRURegionEntryHeapFactory();

    public VersionedThinDiskLRURegionEntryHeap(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinDiskLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedThinDiskLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key2, Object value2) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key2.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinDiskLRURegionEntryHeapIntKey(context, (Integer)key2, value2);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinDiskLRURegionEntryHeapLongKey(context, (Long)key2, value2);
                }
                if (keyClass == String.class) {
                    String skey = (String)key2;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinDiskLRURegionEntryHeapStringKey1(context, skey, value2, byteEncoded);
                        }
                        return new VersionedThinDiskLRURegionEntryHeapStringKey2(context, skey, value2, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinDiskLRURegionEntryHeapUUIDKey(context, (UUID)key2, value2);
                }
            }
            return new VersionedThinDiskLRURegionEntryHeapObjectKey(context, key2, value2);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedThinDiskLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }
    }
}

