/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedThinLRURegionEntryHeap
extends VersionedThinLRURegionEntry {
    private static final VersionedThinLRURegionEntryHeapFactory factory = new VersionedThinLRURegionEntryHeapFactory();

    public VersionedThinLRURegionEntryHeap(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedThinLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key2, Object value2) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key2.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinLRURegionEntryHeapIntKey(context, (Integer)key2, value2);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinLRURegionEntryHeapLongKey(context, (Long)key2, value2);
                }
                if (keyClass == String.class) {
                    String skey = (String)key2;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinLRURegionEntryHeapStringKey1(context, skey, value2, byteEncoded);
                        }
                        return new VersionedThinLRURegionEntryHeapStringKey2(context, skey, value2, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinLRURegionEntryHeapUUIDKey(context, (UUID)key2, value2);
                }
            }
            return new VersionedThinLRURegionEntryHeapObjectKey(context, key2, value2);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedThinLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }
    }
}

