/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedThinRegionEntryHeap
extends VersionedThinRegionEntry {
    private static final VersionedThinRegionEntryHeapFactory factory = new VersionedThinRegionEntryHeapFactory();

    public VersionedThinRegionEntryHeap(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedThinRegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key2, Object value2) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key2.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinRegionEntryHeapIntKey(context, (Integer)key2, value2);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinRegionEntryHeapLongKey(context, (Long)key2, value2);
                }
                if (keyClass == String.class) {
                    String skey = (String)key2;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinRegionEntryHeapStringKey1(context, skey, value2, byteEncoded);
                        }
                        return new VersionedThinRegionEntryHeapStringKey2(context, skey, value2, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinRegionEntryHeapUUIDKey(context, (UUID)key2, value2);
                }
            }
            return new VersionedThinRegionEntryHeapObjectKey(context, key2, value2);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedThinRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }
    }
}

