/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.control;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.control.RegionFilter;
import java.util.HashSet;
import java.util.Set;

public class FilterByPath
implements RegionFilter {
    private final Set<String> included;
    private final Set<String> excluded;

    public FilterByPath(Set<String> included, Set<String> excluded) {
        if (included != null) {
            this.included = new HashSet<String>();
            for (String regionName : included) {
                this.included.add(!regionName.startsWith("/") ? "/" + regionName : regionName);
            }
        } else {
            this.included = null;
        }
        if (excluded != null) {
            this.excluded = new HashSet<String>();
            for (String regionName : excluded) {
                this.excluded.add(!regionName.startsWith("/") ? "/" + regionName : regionName);
            }
        } else {
            this.excluded = null;
        }
    }

    @Override
    public boolean include(Region<?, ?> region) {
        String fullPath = region.getFullPath();
        if (this.included != null) {
            return this.included.contains(fullPath);
        }
        if (this.excluded != null) {
            return !this.excluded.contains(fullPath);
        }
        return true;
    }
}

