/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.control;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.query.internal.QueryMonitor;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.OverflowQueueWithDMStats;
import com.gemstone.gemfire.distributed.internal.SerialQueuedExecutorWithDMStats;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.GemFireStatSampler;
import com.gemstone.gemfire.internal.LocalStatListener;
import com.gemstone.gemfire.internal.SetUtils;
import com.gemstone.gemfire.internal.StatisticsImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEvictorTask;
import com.gemstone.gemfire.internal.cache.control.FilterByPath;
import com.gemstone.gemfire.internal.cache.control.MemoryEvent;
import com.gemstone.gemfire.internal.cache.control.MemoryEventImpl;
import com.gemstone.gemfire.internal.cache.control.MemoryEventType;
import com.gemstone.gemfire.internal.cache.control.PartitionRebalanceEvent;
import com.gemstone.gemfire.internal.cache.control.RebalanceOperationImpl;
import com.gemstone.gemfire.internal.cache.control.ResourceAdvisor;
import com.gemstone.gemfire.internal.cache.control.ResourceEvent;
import com.gemstone.gemfire.internal.cache.control.ResourceListener;
import com.gemstone.gemfire.internal.cache.control.ResourceManagerStats;
import com.gemstone.gemfire.internal.cache.partitioned.LoadProbe;
import com.gemstone.gemfire.internal.cache.partitioned.SizedBasedLoadProbe;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.ListenerNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.logging.log4j.Logger;

public class InternalResourceManager
implements ResourceManager,
NotificationListener {
    private static final Logger logger = LogService.getLogger();
    private final ScheduledExecutorService executor;
    private final ExecutorService thresholdEventProcessor;
    private final Set<RebalanceOperation> inProgressOperations = new HashSet<RebalanceOperation>();
    private final Object inProgressOperationsLock = new Object();
    private ScheduledExecutorService pollerExecutor;
    final GemFireCacheImpl cache;
    private Map<ResourceListener<? extends ResourceEvent>, Boolean> resourceListeners = new ConcurrentHashMap<ResourceListener<? extends ResourceEvent>, Boolean>();
    private Map<ResourceListener<MemoryEvent>, Boolean> memoryEventListeners = new ConcurrentHashMap<ResourceListener<MemoryEvent>, Boolean>();
    private Map<ResourceListener<? extends ResourceEvent>, Boolean> rebalanceEventListeners = new ConcurrentHashMap<ResourceListener<? extends ResourceEvent>, Boolean>();
    private LocalStatListener statListener = new LocalHeapStatListener();
    private final Object resourceListenersLock = new Object();
    private final LoadProbe loadProbe;
    private final ResourceManagerStats stats;
    private volatile boolean isClosed = false;
    private final ResourceAdvisor resourceAdvisor;
    private static ResourceObserver observer = new ResourceObserverAdapter();
    private static String PR_LOAD_PROBE_CLASS = System.getProperty("gemfire.ResourceManager.PR_LOAD_PROBE_CLASS", SizedBasedLoadProbe.class.getName());
    private static final String HEAP_POOL = System.getProperty("gemfire.ResourceManager.HEAP_POOL");
    private boolean backgroundThreadsDisabledForTest;
    private volatile long originalByteThreshold;
    private final AtomicBoolean localHeapCritical = new AtomicBoolean(false);
    private final AtomicReference<Thresholds> thresholds = new AtomicReference<Thresholds>(new Thresholds());
    private static final boolean DISABLE_LOW_MEM_EXCEPTION = Boolean.getBoolean("gemfire.disableLowMemoryException");
    private static final double THRESHOLD_THICKNESS = Double.parseDouble(System.getProperty("gemfire.thresholdThickness", "2.00"));
    private static final int POLLER_INTERVAL = Integer.getInteger("gemfire.heapPollerInterval", 500);
    private static final int MEMORY_EVENT_TOLERANCE;
    private static long testTenuredGenUsedBytes;
    private final AtomicReference<MemoryEventImpl> heapListenerInvocationState = new AtomicReference<MemoryEventImpl>(MemoryEventImpl.UNKOWN);
    private int criticalToleranceCounter;
    private int evictionToleranceCounter;
    public static final DummyMemoryPoolMXBean DUMMYPOOLBEAN;

    public static InternalResourceManager getInternalResourceManager(Cache cache) {
        return (InternalResourceManager)cache.getResourceManager();
    }

    public static InternalResourceManager createResourceManager(GemFireCacheImpl cache) {
        return new InternalResourceManager(cache).init();
    }

    private InternalResourceManager(GemFireCacheImpl cache) {
        this.cache = cache;
        this.resourceAdvisor = (ResourceAdvisor)cache.getDistributionAdvisor();
        final LoggingThreadGroup thrdGrp = LoggingThreadGroup.createThreadGroup("ResourceManagerThreadGroup", logger);
        ThreadFactory tf = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(thrdGrp, r, "ResourceManagerRecoveryThread");
                thread.setDaemon(true);
                return thread;
            }
        };
        this.executor = new ScheduledThreadPoolExecutor(1, tf);
        final LoggingThreadGroup listenerInvokerthrdGrp = LoggingThreadGroup.createThreadGroup("ResourceListenerInvokerThreadGroup", logger);
        this.stats = new ResourceManagerStats(cache.getDistributedSystem());
        ThreadFactory eventProcessorFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(listenerInvokerthrdGrp, r, "ThresholdEventProcessor");
                thread.setDaemon(true);
                thread.setPriority(10);
                return thread;
            }
        };
        OverflowQueueWithDMStats threadQ = new OverflowQueueWithDMStats(this.stats.getResourceEventQueueStatHelper());
        this.thresholdEventProcessor = new SerialQueuedExecutorWithDMStats(threadQ, this.stats.getResourceEventPoolStatHelper(), eventProcessorFactory);
        try {
            Class<?> loadProbeClass = ClassPathLoader.getLatest().forName(PR_LOAD_PROBE_CLASS);
            this.loadProbe = (LoadProbe)loadProbeClass.newInstance();
        }
        catch (Exception e) {
            throw new InternalGemFireError("Unable to instantiate " + PR_LOAD_PROBE_CLASS, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalResourceManager init() {
        GemFireStatSampler sampler = this.getSystem().getStatSampler();
        boolean startPoller = true;
        if (sampler != null) {
            try {
                List<Statistics> list;
                sampler.waitForInitialization();
                String tenuredPoolName = InternalResourceManager.getTenuredMemoryPoolMXBean().getName();
                List<Statistics> list2 = list = this.getSystem().getStatsList();
                synchronized (list2) {
                    for (Statistics o : list) {
                        StatisticsImpl si;
                        if (!(o instanceof StatisticsImpl) || !(si = (StatisticsImpl)o).getTextId().contains(tenuredPoolName) || !si.getType().getName().contains("PoolStats")) continue;
                        sampler.addLocalStatListener(this.statListener, si, "currentUsedMemory");
                        startPoller = false;
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Registered stat listener for {}", si.getTextId());
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.cache.getCancelCriterion().checkCancelInProgress(e);
            }
        }
        if (startPoller && InternalResourceManager.getTenuredMemoryPoolMXBean() != DUMMYPOOLBEAN) {
            final LoggingThreadGroup grp = LoggingThreadGroup.createThreadGroup("HeapPoller", logger);
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(grp, r, "GemfireHeapPoller");
                    t.setDaemon(true);
                    return t;
                }
            };
            this.pollerExecutor = Executors.newScheduledThreadPool(1, tf);
            this.pollerExecutor.scheduleAtFixedRate(new HeapPoller(), POLLER_INTERVAL, POLLER_INTERVAL, TimeUnit.MILLISECONDS);
            if (logger.isDebugEnabled()) {
                logger.debug("Started GemfireHeapPoller to poll the heap every {} milliseconds", POLLER_INTERVAL);
            }
        }
        this.registerLocalVMThresholdListener(true, this.thresholds.get());
        return this;
    }

    public void close() {
        this.isClosed = true;
        this.unregisterLocalVMThresholdListener(true);
        this.closeHeapMonitoring();
        this.stopExecutor(this.executor);
        this.stats.close();
    }

    @Override
    public RebalanceFactory createRebalanceFactory() {
        return new RebalanceFactoryImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<RebalanceOperation> getRebalanceOperations() {
        Object object = this.inProgressOperationsLock;
        synchronized (object) {
            return new HashSet<RebalanceOperation>(this.inProgressOperations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInProgressRebalance(RebalanceOperation op) {
        Object object = this.inProgressOperationsLock;
        synchronized (object) {
            this.inProgressOperations.add(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInProgressRebalance(RebalanceOperation op) {
        Object object = this.inProgressOperationsLock;
        synchronized (object) {
            this.inProgressOperations.remove(op);
        }
    }

    public void addResourceListener(ResourceListener listener) {
        this.addResourceListener(listener, listener.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResourceListener(ResourceListener listener, Class listenerClass) {
        Type[] types = listenerClass.getGenericInterfaces();
        if (listenerClass.getCanonicalName() != null && listenerClass.getCanonicalName().equals(Object.class.getCanonicalName())) {
            return;
        }
        assert (types != null);
        Object object = this.resourceListenersLock;
        synchronized (object) {
            LocalRegion lr;
            if (listener instanceof LocalRegion && (lr = (LocalRegion)listener).isDestroyed()) {
                return;
            }
            for (int i = 0; i < types.length; ++i) {
                String stringType = types[i].toString();
                if (stringType.contains(MemoryEvent.class.getName())) {
                    this.memoryEventListeners.put(listener, Boolean.TRUE);
                    if (!(listener instanceof LocalRegion)) continue;
                    LocalRegion lr2 = (LocalRegion)listener;
                    lr2.initialCriticalMembers(this.isHeapCritical(), this.getResourceAdvisor().adviseCritialMembers());
                    continue;
                }
                if (stringType.contains(PartitionRebalanceEvent.class.getName())) {
                    this.rebalanceEventListeners.put(listener, Boolean.TRUE);
                    continue;
                }
                if (!stringType.contains(ResourceListener.class.getName())) continue;
                this.resourceListeners.put(listener, Boolean.TRUE);
            }
        }
        Class superClass = listenerClass.getSuperclass();
        if (listenerClass.getCanonicalName() != null) {
            this.addResourceListener(listener, superClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceListener(ResourceListener<? extends ResourceEvent> listener) {
        Object object = this.resourceListenersLock;
        synchronized (object) {
            this.memoryEventListeners.remove(listener);
            this.rebalanceEventListeners.remove(listener);
            this.resourceListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResourceListener<? extends ResourceEvent>> getResourceListeners() {
        HashSet<ResourceListener<? extends ResourceEvent>> listenerSet = new HashSet<ResourceListener<? extends ResourceEvent>>();
        Object object = this.resourceListenersLock;
        synchronized (object) {
            listenerSet.addAll(this.memoryEventListeners.keySet());
            listenerSet.addAll(this.rebalanceEventListeners.keySet());
            listenerSet.addAll(this.resourceListeners.keySet());
        }
        return listenerSet;
    }

    public Set<ResourceListener<MemoryEvent>> getMemoryEventListeners() {
        return this.memoryEventListeners.keySet();
    }

    public Set<ResourceListener<? extends ResourceEvent>> getRebalanceListeners() {
        return this.rebalanceEventListeners.keySet();
    }

    void registerLocalVMThresholdListener(boolean saveOriginalThreshold, Thresholds currMem) {
        if (currMem.getCriticalThreshold() > 0.0f) {
            MemoryPoolMXBean p = InternalResourceManager.getTenuredMemoryPoolMXBean();
            if (p != null) {
                long usageThreshold = p.getUsageThreshold();
                if (saveOriginalThreshold) {
                    this.originalByteThreshold = usageThreshold;
                }
                logger.info(LocalizedMessage.create(LocalizedStrings.ResourceManager_OVERRIDDING_MEMORYPOOLMXBEAN_HEAP_0_NAME_1_WITH_2, new Object[]{usageThreshold, p.getName(), currMem.getCriticalThresholdBytes()}));
                this.setUsageThreshold(p, p.getUsage().getUsed(), currMem);
                if (!InternalResourceManager.inTestMode()) {
                    p.setCollectionUsageThreshold(1L);
                }
                MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
                NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
                emitter.addNotificationListener(this, null, null);
            } else {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.ResourceManager_NO_MEMORY_POOL_FOUND_TO_ADD_NOTIFICATION_LISTENER));
            }
        }
    }

    private void unregisterLocalVMThresholdListener(boolean restoreOriginalThreshold) {
        MemoryPoolMXBean p;
        NotificationEmitter emitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
        try {
            emitter.removeNotificationListener(this, null, null);
            if (logger.isDebugEnabled()) {
                logger.debug("Removed Memory MXBean notification listener {}", this);
            }
        }
        catch (ListenerNotFoundException e) {
            logger.debug("This instance '{}' was not registered as a Memory MXBean listener", this.toString());
        }
        if (restoreOriginalThreshold && (p = InternalResourceManager.getTenuredMemoryPoolMXBean()) != null) {
            logger.info(LocalizedMessage.create(LocalizedStrings.ResourceManager_RESETTING_ORIGINAL_MEMORYPOOLMXBEAN_HEAP_THRESHOLD_BYTES, new Object[]{this.originalByteThreshold, p.getName()}));
            p.setUsageThreshold(this.originalByteThreshold);
        }
    }

    private void setUsageThreshold(MemoryPoolMXBean pool, long currentUsage, Thresholds t) {
    }

    private long setUsageThresholdAndGetCurrentUsage(Thresholds t) {
        MemoryPoolMXBean p = InternalResourceManager.getTenuredMemoryPoolMXBean();
        long usage = p.getUsage().getUsed();
        this.setUsageThreshold(p, usage, t);
        return usage;
    }

    public static MemoryPoolMXBean getTenuredMemoryPoolMXBean() {
        MemoryPoolMXBean ret = null;
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean p : pools) {
            if (!p.isUsageThresholdSupported() || !InternalResourceManager.isTenured(p)) continue;
            ret = p;
            break;
        }
        if (ret == null) {
            logger.error(LocalizedMessage.create(LocalizedStrings.ResourceManager_NO_POOL_FOUND_POOLS_0, InternalResourceManager.getAllMemoryPoolNames()));
            ret = DUMMYPOOLBEAN;
        }
        return ret;
    }

    public static long getTenuredPoolMaxMemory() {
        long max = InternalResourceManager.getTenuredMemoryPoolMXBean().getUsage().getMax();
        if (max == -1L) {
            max = Runtime.getRuntime().maxMemory();
            List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean p : pools) {
                if (p.getType() != MemoryType.HEAP || p.getUsage().getMax() == -1L) continue;
                max -= p.getUsage().getMax();
            }
        }
        return max;
    }

    private static String getAllMemoryPoolNames() {
        StringBuilder sb;
        Iterator<MemoryPoolMXBean> i = ManagementFactory.getMemoryPoolMXBeans().iterator();
        if (i.hasNext()) {
            sb = new StringBuilder("[");
        } else {
            return "";
        }
        while (i.hasNext()) {
            MemoryPoolMXBean p = i.next();
            sb.append("(Name=").append(p.getName()).append(";Type=").append((Object)p.getType()).append(";UsageThresholdSupported=").append(p.isUsageThresholdSupported()).append(")");
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    static boolean isTenured(MemoryPoolMXBean p) {
        if (p.getType() == MemoryType.HEAP) {
            String name = p.getName();
            return name.equals("CMS Old Gen") || name.equals("PS Old Gen") || name.equals("G1 Old Gen") || name.equals("Old Space") || name.equals("Tenured Gen") || name.equals("Java heap") || HEAP_POOL != null && name.equals(HEAP_POOL);
        }
        return false;
    }

    @Override
    public void handleNotification(Notification notification, Object callback) {
        this.executeInThresholdProcessor(new Runnable(){

            @Override
            public void run() {
                if (!InternalResourceManager.this.isBackgroundThreadsDisabledForTest()) {
                    InternalResourceManager.this.triggerMemoryEvent();
                }
            }
        });
    }

    public void triggerMemoryEvent() {
        Thresholds t = this.thresholds.get();
        long currentUsed = this.setUsageThresholdAndGetCurrentUsage(t);
        assert (currentUsed >= 0L);
        this.invokeMemoryEventListeners(currentUsed, t);
    }

    private void executeInThresholdProcessor(Runnable runnable) {
        block2: {
            try {
                this.thresholdEventProcessor.execute(runnable);
            }
            catch (RejectedExecutionException e) {
                if (this.isClosed) break block2;
                logger.warn(LocalizedMessage.create(LocalizedStrings.ResourceManager_REJECTED_EXECUTION_CAUSE_NOHEAP_EVENTS));
            }
        }
    }

    protected void invokeMemoryEventListeners(long currentOldGenUsage, Thresholds t) {
        assert (currentOldGenUsage >= 0L);
        this.stats.changeTenuredHeapUsed(currentOldGenUsage);
        if (currentOldGenUsage == 0L) {
            return;
        }
        MemoryEventImpl event = new MemoryEventImpl(MemoryEventType.UNKNOWN, this.cache.getMyId(), 0, testTenuredGenUsedBytes == 0L ? currentOldGenUsage : testTenuredGenUsedBytes, 0L, true, t);
        this.informListenersOfLocalEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informListenersOfLocalEvent(MemoryEventImpl newEvent) {
        assert (newEvent.isLocal());
        if (logger.isDebugEnabled()) {
            logger.debug("Handling new local event {}", newEvent);
        }
        AtomicReference<MemoryEventImpl> atomicReference = this.heapListenerInvocationState;
        synchronized (atomicReference) {
            MemoryEventImpl oldState = this.heapListenerInvocationState.get();
            MemoryEventImpl[] eventsToDeliver = this.getValidatedEvents(newEvent, oldState);
            if (eventsToDeliver == null && (eventsToDeliver = this.getEvictMore(oldState, newEvent)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No events to deliver");
                }
                return;
            }
            MemoryEventImpl newState = eventsToDeliver[eventsToDeliver.length - 1];
            if (!(newState.getType().isDisabledType() || newState.skipValidation() || newState.getType().isEvictMore())) {
                this.heapListenerInvocationState.set(newState);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Local events to deliver: {}", this.getEventArrayAsString(eventsToDeliver));
            }
            this.logCriticalEventsAndSetQueryMonitor(eventsToDeliver);
            if (!newState.getType().isEvictMore()) {
                this.informRemoteResourceManagers(eventsToDeliver);
            }
            this.invokeLocalListeners(eventsToDeliver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean informListenersOfRemoteEvent(MemoryEventImpl newEvent, MemoryEventImpl oldEvent) {
        MemoryEventImpl[] eventsToDeliver;
        assert (!newEvent.isLocal() || !oldEvent.isLocal());
        assert (Assert.assertHoldsLock(this, false));
        if (logger.isDebugEnabled()) {
            logger.debug("New remote event to deliver for member {}: new={} old={}", newEvent.getMember(), newEvent, oldEvent);
        }
        if ((eventsToDeliver = this.getValidatedEvents(newEvent, oldEvent)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("No remote events to deliver for member {}", newEvent.getMember());
            }
            return false;
        }
        if (eventsToDeliver[0].equals(MemoryEventImpl.NO_DELIVERY)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Suppressed remote events to deliver for member {}", newEvent.getMember());
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Remote events to deliver for member {}:{}", newEvent.getMember(), this.getEventArrayAsString(eventsToDeliver));
        }
        Object object = this.resourceListenersLock;
        synchronized (object) {
            this.executeInThresholdProcessor(new Runnable(){

                @Override
                public void run() {
                    InternalResourceManager.this.invokeLocalListeners(eventsToDeliver);
                }
            });
        }
        return true;
    }

    private void logCriticalEventsAndSetQueryMonitor(MemoryEventImpl[] eventsToDeliver) {
        for (int i = 0; i < eventsToDeliver.length; ++i) {
            MemoryEventImpl event = eventsToDeliver[i];
            if (event.isLocal()) {
                if (event.getType().isCriticalUp()) {
                    logger.error(LocalizedMessage.create(LocalizedStrings.ResourceManager_MEMBER_ABOVE_CRITICAL_THRESHOLD, new Object[]{event.getMember()}));
                    if (!this.cache.isQueryMonitorDisabledForLowMemory()) {
                        QueryMonitor.setLowMemory(true, event.getCurrentHeapBytesUsed());
                        this.cache.getQueryMonitor().cancelAllQueriesDueToMemory();
                    }
                } else if (event.getType().isCriticalDown()) {
                    logger.error(LocalizedMessage.create(LocalizedStrings.ResourceManager_MEMBER_BELOW_CRITICAL_THRESHOLD, new Object[]{event.getMember()}));
                    if (!this.cache.isQueryMonitorDisabledForLowMemory()) {
                        QueryMonitor.setLowMemory(false, event.getBytesFromThreshold());
                    }
                } else if (event.getType().isEvictionUp()) {
                    logger.info(LocalizedMessage.create(LocalizedStrings.ResourceManager_MEMBER_ABOVE_HIGH_THRESHOLD, new Object[]{event.getMember()}));
                } else if (event.getType().isEvictionDown()) {
                    logger.info(LocalizedMessage.create(LocalizedStrings.ResourceManager_MEMBER_BELOW_HIGH_THRESHOLD, new Object[]{event.getMember()}));
                }
            }
            this.setLocalHeapStatus(event);
        }
    }

    private void invokeLocalListeners(MemoryEventImpl[] eventsToDeliver) {
        for (int i = 0; i < eventsToDeliver.length; ++i) {
            MemoryEventImpl event = eventsToDeliver[i];
            Set<ResourceListener<MemoryEvent>> memoryListeners = this.getMemoryEventListeners();
            for (ResourceListener<MemoryEvent> listener : memoryListeners) {
                try {
                    listener.onEvent(event);
                }
                catch (CancelException ignore) {
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.error(LocalizedMessage.create(LocalizedStrings.ResourceManager_EXCEPTION_OCCURED_IN_RESOURCELISTENER, t));
                }
            }
            this.stats.incResourceEventsDelivered();
        }
    }

    private void informRemoteResourceManagers(MemoryEventImpl[] eventsToDeliver) {
        assert (Assert.assertHoldsLock(this.heapListenerInvocationState, true));
        if (logger.isDebugEnabled()) {
            logger.debug("Informing remote members of events {}", this.getEventArrayAsString(eventsToDeliver));
        }
        this.resourceAdvisor.informRemoteManagers(eventsToDeliver);
    }

    private void setLocalHeapStatus(MemoryEventImpl event) {
        if (event.isLocal()) {
            if (event.getType().isCriticalUp()) {
                this.localHeapCritical.set(true);
                this.stats.incHeapCriticalEvents();
            } else if (event.getType().isCriticalDown()) {
                this.localHeapCritical.set(false);
                this.stats.incHeapSafeEvents();
            } else if (event.getType().isEvictionUp()) {
                this.stats.incEvictionStartEvents();
            } else if (event.getType().isEvictionDown()) {
                this.stats.incEvictionStopEvents();
            } else if (event.getType().isEvictMore()) {
                this.stats.incEvictMoreEvents();
            }
        }
    }

    private MemoryEventImpl[] getValidatedEvents(MemoryEventImpl nev, MemoryEventImpl oev) {
        assert (nev != null);
        MemoryEventImpl[] retVal = null;
        MemoryEventType oldState = oev.getType();
        MemoryEventImpl event = nev.getType().isUnknown() ? this.buildEvent(nev, oldState) : nev;
        assert (event != null);
        if (event.skipValidation()) {
            return new MemoryEventImpl[]{event};
        }
        if (this.isEventInThresholdThickness(event)) {
            return null;
        }
        boolean isCriticalDisabled = nev.getThresholds().isCriticalThresholdDisabled();
        boolean isEvictionDisabled = nev.getThresholds().isEvictionThresholdDisabled();
        if (isCriticalDisabled && event.getType().isCriticalType() || isEvictionDisabled && event.getType().isEvictionType()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Threshold disabled: {} not delivered", event);
            }
            return null;
        }
        if (!oldState.isEvictionUp() && oldState.equals((Object)event.getType())) {
            this.resetThresholdCounters();
            if (logger.isDebugEnabled()) {
                logger.debug("Ignoring duplicate event {}", event);
            }
            return null;
        }
        if (event.isDisableEvent()) {
            retVal = new MemoryEventImpl[]{event};
            return retVal;
        }
        MemoryEventImpl[] events = oev.getType().getMissingEvents(event);
        return this.applyEventTolerance(events);
    }

    private MemoryEventImpl[] applyEventTolerance(MemoryEventImpl[] events) {
        if (events == null) {
            this.resetThresholdCounters();
            return null;
        }
        MemoryEventImpl newState = events[events.length - 1];
        if (!newState.isLocal()) {
            return events;
        }
        if (newState.getType().isEvictionUp()) {
            ++this.evictionToleranceCounter;
            this.criticalToleranceCounter = 0;
            if (this.evictionToleranceCounter <= this.getMemoryEventTolerance()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Event {} ignored. toleranceCounter:{} MEMORY_EVENT_TOLERANCE:{}", newState, this.evictionToleranceCounter, this.getMemoryEventTolerance());
                }
                return null;
            }
        } else if (newState.getType().isCriticalUp()) {
            ++this.criticalToleranceCounter;
            this.evictionToleranceCounter = 0;
            if (this.criticalToleranceCounter <= this.getMemoryEventTolerance()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Event {} ignored. toleranceCounter:{} MEMORY_EVENT_TOLERANCE:{}", newState, this.evictionToleranceCounter, this.getMemoryEventTolerance());
                }
                return null;
            }
        } else {
            this.resetThresholdCounters();
        }
        return events;
    }

    private void resetThresholdCounters() {
        this.criticalToleranceCounter = 0;
        this.evictionToleranceCounter = 0;
        if (logger.isDebugEnabled()) {
            logger.debug("TOLERANCE counters reset");
        }
    }

    private MemoryEventImpl buildEvent(MemoryEventImpl event, MemoryEventType prevType) {
        MemoryEventImpl retVal = null;
        Thresholds currMem = event.getThresholds();
        retVal = currMem.isCriticalThresholdEnabled() && event.getCurrentHeapBytesUsed() >= currMem.getCriticalThresholdBytes() ? new MemoryEventImpl(MemoryEventType.CRITICAL_UP, event.getMember(), InternalResourceManager.convertToIntPercent((double)event.getCurrentHeapBytesUsed() / currMem.getTenuredGenMaxBytes()), event.getCurrentHeapBytesUsed(), event.getCurrentHeapBytesUsed() - currMem.getCriticalThresholdBytes(), event.isLocal(), event.getThresholds()) : (event.getCurrentHeapBytesUsed() < currMem.getEvictionThresholdSafeBytes() ? new MemoryEventImpl(MemoryEventType.EVICTION_DOWN, event.getMember(), InternalResourceManager.convertToIntPercent((double)event.getCurrentHeapBytesUsed() / currMem.getTenuredGenMaxBytes()), event.getCurrentHeapBytesUsed(), currMem.getEvictionThresholdBytes() - event.getCurrentHeapBytesUsed(), event.isLocal(), event.getThresholds()) : (prevType.isUnknown() || prevType.isEvictionType() ? new MemoryEventImpl(MemoryEventType.EVICTION_UP, event.getMember(), InternalResourceManager.convertToIntPercent((double)event.getCurrentHeapBytesUsed() / currMem.getTenuredGenMaxBytes()), event.getCurrentHeapBytesUsed(), event.getCurrentHeapBytesUsed() - currMem.getEvictionThresholdBytes(), event.isLocal(), event.getThresholds()) : new MemoryEventImpl(MemoryEventType.CRITICAL_DOWN, event.getMember(), InternalResourceManager.convertToIntPercent((double)event.getCurrentHeapBytesUsed() / currMem.getTenuredGenMaxBytes()), event.getCurrentHeapBytesUsed(), currMem.getCriticalThresholdBytes() - event.getCurrentHeapBytesUsed(), event.isLocal(), event.getThresholds())));
        return retVal;
    }

    private boolean isEventInThresholdThickness(MemoryEventImpl event) {
        Thresholds currMem = event.getThresholds();
        if (event.getType().isCriticalDown() && event.getCurrentHeapBytesUsed() > currMem.getCriticalThresholdSafeBytes()) {
            return true;
        }
        return event.getType().isEvictionDown() && event.getCurrentHeapBytesUsed() > currMem.getEvictionThresholdSafeBytes();
    }

    private MemoryEventImpl[] getEvictMore(MemoryEventImpl oldState, MemoryEventImpl newEvent) {
        long lastTaskCompletion;
        MemoryEventImpl[] retVal = null;
        if (!oldState.getType().isEvictionUp() && !oldState.getType().isCriticalType()) {
            return retVal;
        }
        if (this.cache != null && this.cache.getHeapEvictor().getRunningAndScheduledTasks() == 0 && ((lastTaskCompletion = RegionEvictorTask.getLastTaskCompletionTime()) == 0L || System.currentTimeMillis() - lastTaskCompletion >= (long)RegionEvictorTask.getEvictionBurstPauseTimeMillis())) {
            retVal = new MemoryEventImpl[]{new MemoryEventImpl(newEvent, MemoryEventType.EVICT_MORE)};
        }
        return retVal;
    }

    private void closeHeapMonitoring() {
        this.stopExecutor(this.thresholdEventProcessor);
        this.stopExecutor(this.pollerExecutor);
        GemFireStatSampler sampler = this.getSystem().getStatSampler();
        if (sampler != null) {
            sampler.removeLocalStatListener(this.statListener);
        }
    }

    public ExecutorService getThresholdEventProcessor() {
        return this.thresholdEventProcessor;
    }

    private void stopExecutor(ExecutorService executor) {
        if (executor == null) {
            return;
        }
        executor.shutdown();
        int secToWait = Integer.getInteger("gemfire.prrecovery-close-timeout", 120);
        try {
            executor.awaitTermination(secToWait, TimeUnit.SECONDS);
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            logger.debug("Failed in interrupting the Resource Manager Thread due to interrupt");
        }
        if (!executor.isTerminated()) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.ResourceManager_FAILED_TO_STOP_RESOURCE_MANAGER_THREADS, new Object[]{secToWait}));
        }
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public ResourceManagerStats getStats() {
        return this.stats;
    }

    public static void setResourceObserver(ResourceObserver observer) {
        if (observer == null) {
            observer = new ResourceObserverAdapter();
        }
        InternalResourceManager.observer = observer;
    }

    public static ResourceObserver getResourceObserver() {
        return observer;
    }

    public Set<InternalDistributedMember> getHeapCriticalMembers() {
        return this.resourceAdvisor.adviseCritialMembers();
    }

    public boolean isHeapCritical() {
        return this.localHeapCritical.get();
    }

    @Override
    public float getCriticalHeapPercentage() {
        return this.thresholds.get().getCriticalThreshold();
    }

    public boolean hasCriticalThreshold() {
        return this.thresholds.get().hasCriticalThreshold();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCriticalHeapPercentage(float heapPercentage) {
        if (heapPercentage > 100.0f || heapPercentage < 0.0f) {
            throw new IllegalArgumentException(LocalizedStrings.ResourceManager_CRITICAL_PERCENTAGE_GT_ZERO_AND_LTE_100.toLocalizedString());
        }
        if (InternalResourceManager.getTenuredMemoryPoolMXBean() == DUMMYPOOLBEAN) {
            throw new IllegalStateException(LocalizedStrings.ResourceManager_NO_POOL_FOUND_POOLS_0.toLocalizedString(InternalResourceManager.getAllMemoryPoolNames()));
        }
        boolean disabled = heapPercentage == 0.0f;
        AtomicReference<MemoryEventImpl> atomicReference = this.heapListenerInvocationState;
        synchronized (atomicReference) {
            Thresholds currMem = this.thresholds.get();
            if (!disabled && currMem.isEvictionThresholdEnabled() && heapPercentage < currMem.getEvictionThreshold()) {
                throw new IllegalArgumentException(LocalizedStrings.ResourceManager_CRITICAL_PERCENTAGE_GTE_EVICTION_PERCENTAGE.toLocalizedString());
            }
            boolean wasEqual = heapPercentage == currMem.getCriticalThreshold();
            Thresholds newMem = new Thresholds(currMem.getTenuredGenMaxBytes(), false, heapPercentage, true, currMem.getEvictionThreshold(), currMem.hasEvictionThreshold());
            if (wasEqual) {
                this.thresholds.set(newMem);
                return;
            }
            this.unregisterLocalVMThresholdListener(disabled);
            this.cache.setQueryMonitorRequiredForResourceManager(!disabled);
            if (!disabled) {
                MemoryEventImpl eventAfterEnable = this.getEventAfterEnablingThreshold(MemoryEventType.CRITICAL_UP, newMem);
                if (eventAfterEnable != null) {
                    this.informListenersOfLocalEvent(eventAfterEnable);
                }
            } else {
                long tenuresUsage = InternalResourceManager.getTenuredHeapUsage();
                this.informListenersOfLocalEvent(new MemoryEventImpl(MemoryEventType.CRITICAL_DISABLED, this.cache.getMyId(), InternalResourceManager.convertToIntPercent((double)tenuresUsage / newMem.getTenuredGenMaxBytes()), tenuresUsage, 0L, true, newMem));
                this.resetOldState(newMem);
            }
            this.thresholds.set(newMem);
            this.registerLocalVMThresholdListener(false, newMem);
            this.stats.changeCriticalThreshold(newMem.getCriticalThresholdBytes());
        }
    }

    public String toString() {
        return "ResourceManager@" + System.identityHashCode(this) + "[" + "criticalHeapPercentage=" + this.getCriticalHeapPercentage() + ";evictionHeapPercentage=" + this.getEvictionHeapPercentage() + "]";
    }

    @Override
    public float getEvictionHeapPercentage() {
        return this.thresholds.get().getEvictionThreshold();
    }

    public boolean hasEvictionThreshold() {
        return this.thresholds.get().hasEvictionThreshold();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEvictionHeapPercentage(float heapPercentage) {
        if (heapPercentage > 100.0f || heapPercentage < 0.0f) {
            throw new IllegalArgumentException(LocalizedStrings.ResourceManager_EVICTION_PERCENTAGE_GT_ZERO_AND_LTE_100.toLocalizedString());
        }
        if (InternalResourceManager.getTenuredMemoryPoolMXBean() == DUMMYPOOLBEAN) {
            throw new IllegalStateException(LocalizedStrings.ResourceManager_NO_POOL_FOUND_POOLS_0.toLocalizedString(InternalResourceManager.getAllMemoryPoolNames()));
        }
        boolean disabled = heapPercentage == 0.0f;
        AtomicReference<MemoryEventImpl> atomicReference = this.heapListenerInvocationState;
        synchronized (atomicReference) {
            Thresholds currentMemory = this.thresholds.get();
            if (!disabled && currentMemory.isCriticalThresholdEnabled() && heapPercentage > currentMemory.getCriticalThreshold()) {
                throw new IllegalArgumentException(LocalizedStrings.ResourceManager_EVICTION_PERCENTAGE_LTE_CRITICAL_PERCENTAGE.toLocalizedString());
            }
            boolean wasEqual = currentMemory.getEvictionThreshold() == heapPercentage;
            Thresholds newMem = new Thresholds(currentMemory.getTenuredGenMaxBytes(), false, currentMemory.getCriticalThreshold(), currentMemory.hasCriticalThreshold(), heapPercentage, true);
            if (wasEqual) {
                this.thresholds.set(newMem);
                return;
            }
            this.unregisterLocalVMThresholdListener(disabled);
            if (!disabled) {
                MemoryEventImpl eventAfterEnable = this.getEventAfterEnablingThreshold(MemoryEventType.EVICTION_UP, newMem);
                if (eventAfterEnable != null) {
                    this.informListenersOfLocalEvent(eventAfterEnable);
                }
            } else {
                long tenuredUsage = InternalResourceManager.getTenuredHeapUsage();
                this.informListenersOfLocalEvent(new MemoryEventImpl(MemoryEventType.EVICTION_DISABLED, this.cache.getMyId(), InternalResourceManager.convertToIntPercent((double)tenuredUsage / newMem.getTenuredGenMaxBytes()), tenuredUsage, 0L, true, newMem));
                this.resetOldState(newMem);
            }
            this.thresholds.set(newMem);
            this.registerLocalVMThresholdListener(false, newMem);
            this.stats.changeEvictionThreshold(newMem.getEvictionThresholdBytes());
        }
    }

    private void resetOldState(Thresholds t) {
        assert (Assert.assertHoldsLock(this.heapListenerInvocationState, true));
        if (t.getCriticalThreshold() == 0.0f && t.getEvictionThreshold() == 0.0f) {
            this.heapListenerInvocationState.set(MemoryEventImpl.UNKOWN);
        }
    }

    private MemoryEventImpl getEventAfterEnablingThreshold(MemoryEventType type, Thresholds newThreshold) {
        long thresholdBytes;
        assert (Assert.assertHoldsLock(this.heapListenerInvocationState, true));
        MemoryEventImpl retVal = null;
        MemoryEventImpl oldState = this.heapListenerInvocationState.get();
        boolean skipValidation = true;
        long currentHeapUsage = InternalResourceManager.getTenuredHeapUsage();
        if (currentHeapUsage > (thresholdBytes = MemoryEventType.getThresholdBytesForForcedEvents(type, newThreshold))) {
            if (type.isEvictionUp() && (oldState.getType().isEvictionDown() || oldState.getType().isUnknown())) {
                skipValidation = false;
            } else if (type.isCriticalUp() && !oldState.getType().isCriticalUp()) {
                skipValidation = false;
            }
            retVal = new MemoryEventImpl(type, currentHeapUsage, this.cache.getMyId(), true, newThreshold, skipValidation);
        }
        return retVal;
    }

    public static int convertToIntPercent(double percentHeap) {
        assert (percentHeap >= 0.0 && percentHeap <= 1.0);
        int ret = (int)Math.ceil(percentHeap * 100.0);
        assert (ret >= 0 && ret <= 100);
        return ret;
    }

    public static double convertToDoublePercent(int percentHeap) {
        assert (percentHeap >= 0 && percentHeap <= 100);
        double ret = (double)percentHeap * 0.01;
        assert (ret >= 0.0 && ret <= 1.0);
        return ret;
    }

    public static long getTenuredHeapUsage() {
        if (InternalResourceManager.inTestMode()) {
            return testTenuredGenUsedBytes;
        }
        MemoryPoolMXBean p = InternalResourceManager.getTenuredMemoryPoolMXBean();
        assert (p != null);
        MemoryUsage usage = p.getUsage();
        assert (usage != null);
        long used = usage.getUsed();
        return used;
    }

    private int getMemoryEventTolerance() {
        if (InternalResourceManager.inTestMode()) {
            return 0;
        }
        return MEMORY_EVENT_TOLERANCE;
    }

    private void setTenuredGenerationMaxBytesForTest(long tenuredGenerationBytes) {
        Thresholds currMem = this.thresholds.get();
        Thresholds newMem = tenuredGenerationBytes == 0L ? new Thresholds() : new Thresholds(tenuredGenerationBytes, true, currMem.getCriticalThreshold(), false, currMem.getEvictionThreshold(), false);
        this.thresholds.set(newMem);
        StringBuilder builder = new StringBuilder("In testing, the following values were set");
        builder.append(" tenuredGenerationMaxBytes:" + newMem.getTenuredGenMaxBytes());
        builder.append(" criticalThresholdBytes:" + newMem.getCriticalThresholdBytes());
        builder.append(" evictionThresholdBytes:" + newMem.getEvictionThresholdBytes());
        logger.debug(builder.toString());
    }

    public static void setTenuredGenUsedBytesForTest(long usedBytes) {
        testTenuredGenUsedBytes = usedBytes;
    }

    public void setTenuredGenBytesForTest(long usedBytes, long maxBytes) {
        if (usedBytes > maxBytes) {
            throw new IllegalArgumentException("Used bytes has to be less than maxBytes");
        }
        InternalResourceManager.setTenuredGenUsedBytesForTest(usedBytes);
        this.setTenuredGenerationMaxBytesForTest(maxBytes);
    }

    protected static boolean inTestMode() {
        return testTenuredGenUsedBytes != 0L;
    }

    private String getEventArrayAsString(MemoryEventImpl[] eventsToDeliver) {
        StringBuilder str = new StringBuilder("");
        for (int i = 0; i < eventsToDeliver.length; ++i) {
            str.append("[" + eventsToDeliver[i] + "],");
        }
        return str.toString();
    }

    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof ResourceAdvisor.ResourceManagerProfile);
        ResourceAdvisor.ResourceManagerProfile rmp = (ResourceAdvisor.ResourceManagerProfile)profile;
        MemoryEventImpl lastEvent = this.heapListenerInvocationState.get();
        rmp.setEventState(lastEvent.getCurrentHeapUsagePercent(), lastEvent.getCurrentHeapBytesUsed(), lastEvent.getType(), lastEvent.getThresholds());
    }

    public CancelCriterion getCancelCriterion() {
        return this.cache.getCancelCriterion();
    }

    public ResourceAdvisor getResourceAdvisor() {
        return this.resourceAdvisor;
    }

    private InternalDistributedSystem getSystem() {
        return this.cache.getDistributedSystem();
    }

    public Thresholds getThresholds() {
        return this.thresholds.get();
    }

    public boolean containsHeapCriticalMembers(Set<InternalDistributedMember> members) {
        if (members.contains(this.cache.getMyId()) && this.isHeapCritical()) {
            return true;
        }
        Set<InternalDistributedMember> criticalMembers = this.getHeapCriticalMembers();
        return SetUtils.intersectsWith(members, criticalMembers);
    }

    public boolean isMemberHeapCritical(InternalDistributedMember member) {
        if (member.equals(this.cache.getMyId()) && this.isHeapCritical()) {
            return true;
        }
        return this.getHeapCriticalMembers().contains(member);
    }

    public LoadProbe getLoadProbe() {
        return this.loadProbe;
    }

    public static final boolean isLowMemoryExceptionDisabled() {
        return DISABLE_LOW_MEM_EXCEPTION;
    }

    public boolean isBackgroundThreadsDisabledForTest() {
        return this.backgroundThreadsDisabledForTest;
    }

    public void setBackgroundThreadsDisabledForTest(boolean disableBackgroundThreadsForTest) {
        this.backgroundThreadsDisabledForTest = disableBackgroundThreadsForTest;
    }

    static {
        String vendor = System.getProperty("java.vendor");
        MEMORY_EVENT_TOLERANCE = vendor.contains("Sun") || vendor.contains("Oracle") ? Integer.getInteger("gemfire.memoryEventTolerance", 1).intValue() : Integer.getInteger("gemfire.memoryEventTolerance", 5).intValue();
        testTenuredGenUsedBytes = 0L;
        DUMMYPOOLBEAN = new DummyMemoryPoolMXBean();
    }

    class HeapPoller
    implements Runnable {
        HeapPoller() {
        }

        @Override
        public void run() {
            if (InternalResourceManager.this.isBackgroundThreadsDisabledForTest()) {
                return;
            }
            try {
                long usedTenuredBytes = InternalResourceManager.getTenuredMemoryPoolMXBean().getUsage().getUsed();
                InternalResourceManager.this.invokeMemoryEventListeners(usedTenuredBytes, (Thresholds)InternalResourceManager.this.thresholds.get());
            }
            catch (Exception e) {
                logger.debug("Poller Thread caught exception: {}", e.getMessage(), e);
            }
        }
    }

    public static class Thresholds {
        private final double tenuredGenerationMaxBytes;
        private final boolean hasTenuredGenerationMaxBytes;
        private final float criticalThreshold;
        private final boolean hasCriticalThreshold;
        private final float evictionThreshold;
        private final boolean hasEvictionThreshold;

        Thresholds() {
            this(InternalResourceManager.getTenuredPoolMaxMemory(), false, 0.0f, false, 0.0f, false);
        }

        public Thresholds(double tenuredGenerationMaxBytes, boolean hasTenuredGenerationMaxBytes, float criticalThreshold, boolean hasCriticalThreshold, float evictionThreshold, boolean hasEvictionThreshold) {
            this.tenuredGenerationMaxBytes = tenuredGenerationMaxBytes;
            this.hasTenuredGenerationMaxBytes = hasTenuredGenerationMaxBytes;
            assert (criticalThreshold >= 0.0f && criticalThreshold <= 100.0f);
            this.criticalThreshold = criticalThreshold;
            this.hasCriticalThreshold = hasCriticalThreshold;
            assert (evictionThreshold >= 0.0f && evictionThreshold <= 100.0f);
            this.evictionThreshold = evictionThreshold;
            this.hasEvictionThreshold = hasEvictionThreshold;
        }

        public String toString() {
            return "Thresholds@" + System.identityHashCode(this) + (" tenuredGenerationMaxBytes:" + this.tenuredGenerationMaxBytes) + (" criticalThreshold:" + this.criticalThreshold) + (" evictionThreshold:" + this.evictionThreshold);
        }

        public double getTenuredGenMaxBytes() {
            return this.tenuredGenerationMaxBytes;
        }

        public boolean hasTenuredGenerationMaxBytes() {
            return this.hasTenuredGenerationMaxBytes;
        }

        public float getCriticalThreshold() {
            return this.criticalThreshold;
        }

        public boolean hasCriticalThreshold() {
            return this.hasCriticalThreshold;
        }

        public long getCriticalThresholdBytes() {
            return (long)((double)this.getCriticalThreshold() * 0.01 * this.getTenuredGenMaxBytes());
        }

        public long getCriticalThresholdSafeBytes() {
            return (long)((double)this.getCriticalThresholdBytes() - 0.01 * THRESHOLD_THICKNESS * this.tenuredGenerationMaxBytes);
        }

        public float getEvictionThreshold() {
            return this.evictionThreshold;
        }

        public boolean hasEvictionThreshold() {
            return this.hasEvictionThreshold;
        }

        public long getEvictionThresholdBytes() {
            return (long)((double)this.getEvictionThreshold() * 0.01 * this.getTenuredGenMaxBytes());
        }

        public long getEvictionThresholdSafeBytes() {
            return (long)((double)this.getEvictionThresholdBytes() - 0.01 * THRESHOLD_THICKNESS * this.tenuredGenerationMaxBytes);
        }

        public boolean isCriticalThresholdEnabled() {
            return this.criticalThreshold > 0.0f;
        }

        public boolean isEvictionThresholdEnabled() {
            return this.evictionThreshold > 0.0f;
        }

        public boolean isCriticalThresholdDisabled() {
            return !this.isCriticalThresholdEnabled();
        }

        public boolean isEvictionThresholdDisabled() {
            return !this.isEvictionThresholdEnabled();
        }

        public static Thresholds fromData(DataInput in) throws IOException {
            double tenuredGenerationMaxBytes = in.readDouble();
            boolean hasTenuredGenerationMaxBytes = in.readBoolean();
            float criticalThreshold = in.readFloat();
            boolean hasCriticalThreshold = in.readBoolean();
            float evictionThreshold = in.readFloat();
            boolean hasEvictionThreshold = in.readBoolean();
            return new Thresholds(tenuredGenerationMaxBytes, hasTenuredGenerationMaxBytes, criticalThreshold, hasCriticalThreshold, evictionThreshold, hasEvictionThreshold);
        }

        public void toData(DataOutput out) throws IOException {
            out.writeDouble(this.tenuredGenerationMaxBytes);
            out.writeBoolean(this.hasTenuredGenerationMaxBytes);
            out.writeFloat(this.criticalThreshold);
            out.writeBoolean(this.hasCriticalThreshold);
            out.writeFloat(this.evictionThreshold);
            out.writeBoolean(this.hasEvictionThreshold);
        }
    }

    public static class ResourceObserverAdapter
    implements ResourceObserver {
        @Override
        public void rebalancingFinished(Region region) {
            this.rebalancingOrRecoveryFinished(region);
        }

        @Override
        public void rebalancingStarted(Region region) {
            this.rebalancingOrRecoveryStarted(region);
        }

        @Override
        public void recoveryFinished(Region region) {
            this.rebalancingOrRecoveryFinished(region);
        }

        @Override
        public void recoveryStarted(Region region) {
            this.rebalancingOrRecoveryStarted(region);
        }

        public void rebalancingOrRecoveryStarted(Region region) {
        }

        public void rebalancingOrRecoveryFinished(Region region) {
        }

        @Override
        public void recoveryConflated(PartitionedRegion region) {
        }

        @Override
        public void movingBucket(Region region, int bucketId, DistributedMember source, DistributedMember target) {
        }

        @Override
        public void movingPrimary(Region region, int bucketId, DistributedMember source, DistributedMember target) {
        }
    }

    public static interface ResourceObserver {
        public void rebalancingStarted(Region var1);

        public void rebalancingFinished(Region var1);

        public void recoveryStarted(Region var1);

        public void recoveryFinished(Region var1);

        public void recoveryConflated(PartitionedRegion var1);

        public void movingBucket(Region var1, int var2, DistributedMember var3, DistributedMember var4);

        public void movingPrimary(Region var1, int var2, DistributedMember var3, DistributedMember var4);
    }

    class RebalanceFactoryImpl
    implements RebalanceFactory {
        private Set<String> includedRegions;
        private Set<String> excludedRegions;

        RebalanceFactoryImpl() {
        }

        @Override
        public RebalanceOperation simulate() {
            FilterByPath filter = new FilterByPath(this.includedRegions, this.excludedRegions);
            RebalanceOperationImpl op = new RebalanceOperationImpl(InternalResourceManager.this.cache, true, filter);
            op.start();
            return op;
        }

        @Override
        public RebalanceOperation start() {
            FilterByPath filter = new FilterByPath(this.includedRegions, this.excludedRegions);
            RebalanceOperationImpl op = new RebalanceOperationImpl(InternalResourceManager.this.cache, false, filter);
            op.start();
            return op;
        }

        @Override
        public RebalanceFactory excludeRegions(Set<String> regions) {
            this.excludedRegions = regions;
            return this;
        }

        @Override
        public RebalanceFactory includeRegions(Set<String> regions) {
            this.includedRegions = regions;
            return this;
        }
    }

    class LocalHeapStatListener
    implements LocalStatListener {
        LocalHeapStatListener() {
        }

        @Override
        public void statValueChanged(double value2) {
            final long usedBytes = (long)value2;
            try {
                InternalResourceManager.this.getThresholdEventProcessor().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!InternalResourceManager.this.isBackgroundThreadsDisabledForTest()) {
                            InternalResourceManager.this.invokeMemoryEventListeners(usedBytes, (Thresholds)InternalResourceManager.this.thresholds.get());
                        }
                    }
                });
                if (logger.isDebugEnabled()) {
                    logger.debug("StatSampler scheduled a handleNotification call with {} bytes", usedBytes);
                }
            }
            catch (RejectedExecutionException e) {
                if (!InternalResourceManager.this.isClosed) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.ResourceManager_REJECTED_EXECUTION_CAUSE_NOHEAP_EVENTS));
                }
            }
            catch (CacheClosedException e) {
                // empty catch block
            }
        }
    }

    private static class DummyMemoryPoolMXBean
    implements MemoryPoolMXBean {
        private static MemoryUsage dummyUsage = new MemoryUsage(0L, 0L, 0L, 0L);
        private static final String name = "DummyMemoryPoolMXBean";
        private static final ObjectName objectName;

        private DummyMemoryPoolMXBean() {
        }

        @Override
        public MemoryUsage getCollectionUsage() {
            return dummyUsage;
        }

        @Override
        public long getCollectionUsageThreshold() {
            return 0L;
        }

        @Override
        public long getCollectionUsageThresholdCount() {
            return 0L;
        }

        @Override
        public String[] getMemoryManagerNames() {
            return new String[0];
        }

        @Override
        public String getName() {
            return name;
        }

        @Override
        public MemoryUsage getPeakUsage() {
            return dummyUsage;
        }

        @Override
        public MemoryType getType() {
            return MemoryType.HEAP;
        }

        @Override
        public MemoryUsage getUsage() {
            return dummyUsage;
        }

        @Override
        public long getUsageThreshold() {
            return 0L;
        }

        @Override
        public long getUsageThresholdCount() {
            return 0L;
        }

        @Override
        public boolean isCollectionUsageThresholdExceeded() {
            return false;
        }

        @Override
        public boolean isCollectionUsageThresholdSupported() {
            return false;
        }

        @Override
        public boolean isUsageThresholdExceeded() {
            return false;
        }

        @Override
        public boolean isUsageThresholdSupported() {
            return false;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void resetPeakUsage() {
        }

        @Override
        public void setCollectionUsageThreshold(long threhsold) {
        }

        @Override
        public void setUsageThreshold(long threshold) {
        }

        @Override
        public ObjectName getObjectName() {
            return objectName;
        }

        static {
            try {
                objectName = new ObjectName("java.lang:type=MemoryPool,name=DummyMemoryPoolMXBean");
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalStateException();
            }
        }
    }
}

