/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.control;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.MemoryEventImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public enum MemoryEventType {
    UNKNOWN{

        @Override
        public MemoryEventImpl[] getMissingEvents(MemoryEventImpl newEvent) {
            MemoryEventImpl[] retVal = null;
            switch (newEvent.getType()) {
                case EVICTION_UP: {
                    retVal = new MemoryEventImpl[]{newEvent};
                    break;
                }
                case EVICTION_DOWN: {
                    break;
                }
                case CRITICAL_UP: {
                    if (newEvent.getThresholds().isEvictionThresholdEnabled()) {
                        retVal = new MemoryEventImpl[]{new MemoryEventImpl(newEvent, EVICTION_UP), newEvent};
                        break;
                    }
                    retVal = new MemoryEventImpl[]{newEvent};
                    break;
                }
                case CRITICAL_DOWN: {
                    break;
                }
                case UNKNOWN: {
                    Assert.assertTrue(false);
                    break;
                }
                default: {
                    throw new IllegalStateException("MemoryEventType " + (Object)((Object)newEvent.getType()) + "not considered in state machine");
                }
            }
            return retVal;
        }
    }
    ,
    EVICTION_UP{

        @Override
        public MemoryEventImpl[] getMissingEvents(MemoryEventImpl newEvent) {
            MemoryEventImpl[] retVal = null;
            switch (newEvent.getType()) {
                case EVICTION_UP: {
                    break;
                }
                case EVICTION_DOWN: {
                    retVal = new MemoryEventImpl[]{newEvent};
                    break;
                }
                case CRITICAL_UP: {
                    retVal = new MemoryEventImpl[]{newEvent};
                    break;
                }
                case CRITICAL_DOWN: {
                    if (newEvent.isLocal()) {
                        Assert.assertTrue(false);
                        break;
                    }
                    retVal = new MemoryEventImpl[]{MemoryEventImpl.NO_DELIVERY};
                    break;
                }
                case UNKNOWN: {
                    Assert.assertTrue(false);
                    break;
                }
                default: {
                    throw new IllegalStateException("MemoryEventType " + (Object)((Object)newEvent.getType()) + "not considered in state machine");
                }
            }
            return retVal;
        }
    }
    ,
    EVICT_MORE{

        @Override
        public MemoryEventImpl[] getMissingEvents(MemoryEventImpl newEvent) {
            throw new UnsupportedOperationException("EVICT_MORE should not be previous event");
        }
    }
    ,
    EVICTION_DOWN{

        @Override
        public MemoryEventImpl[] getMissingEvents(MemoryEventImpl newEvent) {
            MemoryEventImpl[] retVal = null;
            switch (newEvent.getType()) {
                case EVICTION_UP: {
                    retVal = new MemoryEventImpl[]{newEvent};
                    break;
                }
                case EVICTION_DOWN: {
                    break;
                }
                case CRITICAL_UP: {
                    if (newEvent.getThresholds().isEvictionThresholdEnabled()) {
                        retVal = new MemoryEventImpl[]{new MemoryEventImpl(newEvent, EVICTION_UP), newEvent};
                        break;
                    }
                    retVal = new MemoryEventImpl[]{newEvent};
                    break;
                }
                case CRITICAL_DOWN: {
                    if (!newEvent.isLocal()) break;
                    Assert.assertTrue(false);
                    break;
                }
                case UNKNOWN: {
                    Assert.assertTrue(false);
                    break;
                }
                default: {
                    throw new IllegalStateException("MemoryEventType " + (Object)((Object)newEvent.getType()) + "not considered in state machine");
                }
            }
            return retVal;
        }
    }
    ,
    EVICTION_DISABLED{

        @Override
        public MemoryEventImpl[] getMissingEvents(MemoryEventImpl newEvent) {
            Assert.assertTrue(false);
            return null;
        }
    }
    ,
    CRITICAL_UP{

        @Override
        public MemoryEventImpl[] getMissingEvents(MemoryEventImpl newEvent) {
            MemoryEventImpl[] retVal = null;
            switch (newEvent.getType()) {
                case EVICTION_UP: {
                    if (!newEvent.isLocal()) break;
                    Assert.assertTrue(false);
                    break;
                }
                case EVICTION_DOWN: {
                    if (newEvent.getThresholds().isCriticalThresholdEnabled()) {
                        retVal = new MemoryEventImpl[]{new MemoryEventImpl(newEvent, CRITICAL_DOWN), newEvent};
                        break;
                    }
                    retVal = new MemoryEventImpl[]{newEvent};
                    break;
                }
                case CRITICAL_UP: {
                    break;
                }
                case CRITICAL_DOWN: {
                    retVal = new MemoryEventImpl[]{newEvent};
                    break;
                }
                case UNKNOWN: {
                    Assert.assertTrue(false);
                    break;
                }
                default: {
                    throw new IllegalStateException("MemoryEventType " + (Object)((Object)newEvent.getType()) + "not considered in state machine");
                }
            }
            return retVal;
        }
    }
    ,
    CRITICAL_DOWN{

        @Override
        public MemoryEventImpl[] getMissingEvents(MemoryEventImpl newEvent) {
            MemoryEventImpl[] retVal = null;
            switch (newEvent.getType()) {
                case EVICTION_UP: {
                    assert (newEvent.getThresholds().isEvictionThresholdEnabled());
                    retVal = new MemoryEventImpl[]{new MemoryEventImpl(newEvent, EVICTION_DOWN), newEvent};
                    break;
                }
                case EVICTION_DOWN: {
                    retVal = new MemoryEventImpl[]{newEvent};
                    break;
                }
                case CRITICAL_UP: {
                    retVal = new MemoryEventImpl[]{newEvent};
                    break;
                }
                case CRITICAL_DOWN: {
                    break;
                }
                case UNKNOWN: {
                    Assert.assertTrue(false);
                    break;
                }
                default: {
                    throw new IllegalStateException("MemoryEventType " + (Object)((Object)newEvent.getType()) + "not considered in state machine");
                }
            }
            return retVal;
        }
    }
    ,
    CRITICAL_DISABLED{

        @Override
        public MemoryEventImpl[] getMissingEvents(MemoryEventImpl newEvent) {
            Assert.assertTrue(false);
            return null;
        }
    };


    public abstract MemoryEventImpl[] getMissingEvents(MemoryEventImpl var1);

    public boolean isDisabledType() {
        return this == EVICTION_DISABLED || this == CRITICAL_DISABLED;
    }

    public boolean isEvictionDisabled() {
        return this == EVICTION_DISABLED;
    }

    public boolean isCriticalDisabled() {
        return this == CRITICAL_DISABLED;
    }

    public boolean isCriticalType() {
        return this == CRITICAL_UP || this == CRITICAL_DOWN;
    }

    public boolean isEvictionType() {
        return this == EVICTION_UP || this == EVICTION_DOWN;
    }

    public boolean isEvictionUp() {
        return this == EVICTION_UP;
    }

    public boolean isEvictionDown() {
        return this == EVICTION_DOWN;
    }

    public boolean isCriticalUp() {
        return this == CRITICAL_UP;
    }

    public boolean isCriticalDown() {
        return this == CRITICAL_DOWN;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean isEvictMore() {
        return this == EVICT_MORE;
    }

    public boolean isEvictionOrCriticalUpEvent() {
        return this == EVICTION_UP || this == CRITICAL_UP;
    }

    public static MemoryEventType fromData(DataInput in) throws IOException, ClassNotFoundException {
        return (MemoryEventType)((Object)DataSerializer.readObject(in));
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject((Object)this, out);
    }

    public static long getThresholdBytesForForcedEvents(MemoryEventType type, InternalResourceManager.Thresholds t) {
        long retVal = 0L;
        switch (type) {
            case EVICTION_UP: {
                retVal = t.getEvictionThresholdBytes();
                break;
            }
            case CRITICAL_UP: {
                retVal = t.getCriticalThresholdBytes();
                break;
            }
            default: {
                throw new IllegalStateException("EVICTION_UP and CRITICAL_UP are the only forced events");
            }
        }
        return retVal;
    }
}

