/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.control;

import com.gemstone.gemfire.cache.partition.PartitionMemberInfo;
import com.gemstone.gemfire.cache.partition.PartitionRebalanceInfo;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class PartitionRebalanceDetailsImpl
implements PartitionRebalanceInfo,
Serializable,
Comparable<PartitionRebalanceDetailsImpl> {
    private static final long serialVersionUID = 5880667005758250156L;
    private long bucketCreateBytes;
    private long bucketCreateTime;
    private int bucketCreatesCompleted;
    private long bucketRemoveBytes;
    private long bucketRemoveTime;
    private int bucketRemovesCompleted;
    private long bucketTransferBytes;
    private long bucketTransferTime;
    private int bucketTransfersCompleted;
    private Set<PartitionMemberInfo> partitionMemberDetailsAfter;
    private Set<PartitionMemberInfo> partitionMemberDetailsBefore;
    private long primaryTransferTime;
    private int primaryTransfersCompleted;
    private final transient PartitionedRegion region;
    private long time;

    public PartitionRebalanceDetailsImpl(PartitionedRegion region) {
        this.region = region;
    }

    public void incCreates(long bytes, long time) {
        this.bucketCreateBytes += bytes;
        this.bucketCreateTime += time;
        ++this.bucketCreatesCompleted;
    }

    public void incRemoves(long bytes, long time) {
        this.bucketRemoveBytes += bytes;
        this.bucketRemoveTime += time;
        ++this.bucketRemovesCompleted;
    }

    public void incTransfers(long bytes, long time) {
        this.bucketTransferBytes += bytes;
        this.bucketTransferTime += time;
        ++this.bucketTransfersCompleted;
    }

    public void incPrimaryTransfers(long time) {
        ++this.primaryTransfersCompleted;
        this.primaryTransferTime += time;
    }

    public void setPartitionMemberDetailsAfter(Set<PartitionMemberInfo> after) {
        this.partitionMemberDetailsAfter = after;
    }

    public void setPartitionMemberDetailsBefore(Set<PartitionMemberInfo> before) {
        this.partitionMemberDetailsBefore = before;
    }

    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public long getBucketCreateBytes() {
        return this.bucketCreateBytes;
    }

    @Override
    public long getBucketCreateTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.bucketCreateTime);
    }

    @Override
    public int getBucketCreatesCompleted() {
        return this.bucketCreatesCompleted;
    }

    @Override
    public long getBucketRemoveBytes() {
        return this.bucketRemoveBytes;
    }

    @Override
    public long getBucketRemoveTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.bucketRemoveTime);
    }

    @Override
    public int getBucketRemovesCompleted() {
        return this.bucketRemovesCompleted;
    }

    @Override
    public long getBucketTransferBytes() {
        return this.bucketTransferBytes;
    }

    @Override
    public long getBucketTransferTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.bucketTransferTime);
    }

    @Override
    public int getBucketTransfersCompleted() {
        return this.bucketTransfersCompleted;
    }

    @Override
    public Set<PartitionMemberInfo> getPartitionMemberDetailsAfter() {
        return this.partitionMemberDetailsAfter;
    }

    @Override
    public Set<PartitionMemberInfo> getPartitionMemberDetailsBefore() {
        return this.partitionMemberDetailsBefore;
    }

    @Override
    public long getPrimaryTransferTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.primaryTransferTime);
    }

    @Override
    public int getPrimaryTransfersCompleted() {
        return this.primaryTransfersCompleted;
    }

    @Override
    public String getRegionPath() {
        return this.region.getFullPath();
    }

    public PartitionedRegion getRegion() {
        return this.region;
    }

    @Override
    public long getTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.time);
    }

    @Override
    public int compareTo(PartitionRebalanceDetailsImpl other) {
        return this.region.getFullPath().compareTo(other.region.getFullPath());
    }

    public boolean equals(Object other) {
        if (!(other instanceof PartitionRebalanceDetailsImpl)) {
            return false;
        }
        PartitionRebalanceDetailsImpl o = (PartitionRebalanceDetailsImpl)other;
        return this.region.getFullPath().equals(o.region.getFullPath());
    }

    public int hashCode() {
        return this.region.getFullPath().hashCode();
    }
}

