/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.control;

import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.partition.PartitionRebalanceInfo;
import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;

public class RebalanceResultsImpl
implements RebalanceResults,
Serializable {
    private Set<PartitionRebalanceInfo> detailSet = new TreeSet<PartitionRebalanceInfo>();
    private long totalBucketCreateBytes;
    private long totalBucketCreateTime;
    private int totalBucketCreatesCompleted;
    private long totalBucketTransferBytes;
    private long totalBucketTransferTime;
    private int totalBucketTransfersCompleted;
    private long totalPrimaryTransferTime;
    private int totalPrimaryTransfersCompleted;
    private long totalTime;

    public void addDetails(PartitionRebalanceInfo details) {
        this.detailSet.add(details);
        this.totalBucketCreateBytes += details.getBucketCreateBytes();
        this.totalBucketCreateTime += details.getBucketCreateTime();
        this.totalBucketCreatesCompleted += details.getBucketCreatesCompleted();
        this.totalBucketTransferBytes += details.getBucketTransferBytes();
        this.totalBucketTransferTime += details.getBucketTransferTime();
        this.totalBucketTransfersCompleted += details.getBucketTransfersCompleted();
        this.totalPrimaryTransferTime += details.getPrimaryTransferTime();
        this.totalPrimaryTransfersCompleted += details.getPrimaryTransfersCompleted();
        this.totalTime += details.getTime();
    }

    @Override
    public Set<PartitionRebalanceInfo> getPartitionRebalanceDetails() {
        return this.detailSet;
    }

    @Override
    public long getTotalBucketCreateBytes() {
        return this.totalBucketCreateBytes;
    }

    @Override
    public long getTotalBucketCreateTime() {
        return this.totalBucketCreateTime;
    }

    @Override
    public int getTotalBucketCreatesCompleted() {
        return this.totalBucketCreatesCompleted;
    }

    @Override
    public long getTotalBucketTransferBytes() {
        return this.totalBucketTransferBytes;
    }

    @Override
    public long getTotalBucketTransferTime() {
        return this.totalBucketTransferTime;
    }

    @Override
    public int getTotalBucketTransfersCompleted() {
        return this.totalBucketTransfersCompleted;
    }

    @Override
    public long getTotalPrimaryTransferTime() {
        return this.totalPrimaryTransferTime;
    }

    @Override
    public int getTotalPrimaryTransfersCompleted() {
        return this.totalPrimaryTransfersCompleted;
    }

    @Override
    public long getTotalTime() {
        return this.totalTime;
    }
}

