/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.control;

import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.UpdateAttributesProcessor;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.MemoryEventImpl;
import com.gemstone.gemfire.internal.cache.control.MemoryEventType;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class ResourceAdvisor
extends DistributionAdvisor {
    private static final Logger logger = LogService.getLogger();

    private ResourceAdvisor(DistributionAdvisee advisee) {
        super(advisee);
    }

    public static ResourceAdvisor createResourceAdvisor(DistributionAdvisee advisee) {
        ResourceAdvisor advisor = new ResourceAdvisor(advisee);
        advisor.initialize();
        return advisor;
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new ResourceManagerProfile(memberId, version);
    }

    private InternalResourceManager getResourceManager() {
        return ((GemFireCacheImpl)this.getAdvisee()).getResourceManager(false);
    }

    @Override
    protected boolean evaluateProfiles(DistributionAdvisor.Profile newProfile, DistributionAdvisor.Profile oldProfile) {
        ResourceManagerProfile newp = (ResourceManagerProfile)newProfile;
        ResourceManagerProfile oldp = (ResourceManagerProfile)oldProfile;
        MemoryEventImpl oldEvent = oldp != null ? oldp.getMemoryEvent() : ResourceAdvisor.generateMemoryEventUnknown(newp.getDistributedMember());
        MemoryEventImpl newEvent = newp.getMemoryEvent();
        boolean delivered = this.getResourceManager().informListenersOfRemoteEvent(newEvent, oldEvent);
        if (oldp != null && (!delivered || newEvent.isDisableEvent())) {
            MemoryEventImpl ome = oldp.getMemoryEvent();
            newp.setEventState(ome.getCurrentHeapUsagePercent(), ome.getCurrentHeapBytesUsed(), ome.getType(), ome.getThresholds());
        }
        return true;
    }

    private static MemoryEventImpl generateMemoryEventUnknown(InternalDistributedMember distributedMember) {
        return new MemoryEventImpl(MemoryEventType.UNKNOWN, distributedMember, 0, 0L, 0L, false, new InternalResourceManager.Thresholds(0.0, false, 0.0f, false, 0.0f, false));
    }

    public String toString() {
        return "ResourceAdvisor for ResourceManager " + this.getAdvisee();
    }

    public Set<InternalDistributedMember> adviseCritialMembers() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                ResourceManagerProfile rmp = (ResourceManagerProfile)profile;
                return rmp.getType().isCriticalUp();
            }
        });
    }

    public void informRemoteManagers(MemoryEventImpl[] eventsToDeliver) {
        Set<InternalDistributedMember> recips = this.adviseGeneric();
        ResourceManagerProfile[] ps = new ResourceManagerProfile[eventsToDeliver.length];
        for (int i = 0; i < eventsToDeliver.length; ++i) {
            MemoryEventImpl e = eventsToDeliver[i];
            ResourceManagerProfile rmp = new ResourceManagerProfile(this.getDistributionManager().getId(), this.incrementAndGetVersion());
            ps[i] = rmp.setEventState(e.getCurrentHeapUsagePercent(), e.getCurrentHeapBytesUsed(), e.getType(), e.getThresholds());
        }
        ResourceProfileMessage.send(this.getResourceManager(), recips, ps);
    }

    @Override
    protected void profileRemoved(DistributionAdvisor.Profile profile) {
        ResourceManagerProfile oldp = (ResourceManagerProfile)profile;
        MemoryEventImpl event = new MemoryEventImpl(oldp.getMemoryEvent(), MemoryEventType.CRITICAL_DISABLED);
        this.getResourceManager().informListenersOfRemoteEvent(event, oldp.getMemoryEvent());
    }

    @Override
    public void close() {
        new UpdateAttributesProcessor(this.getAdvisee(), true).distribute(false);
        super.close();
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    public static class ResourceManagerProfile
    extends DistributionAdvisor.Profile {
        private int currentHeapUsagePercent;
        private long currentHeapBytesUsed;
        private MemoryEventType type;
        private InternalResourceManager.Thresholds thresholds;

        public ResourceManagerProfile() {
        }

        public ResourceManagerProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
        }

        public synchronized ResourceManagerProfile setEventState(int currentHeapUsagePercent, long currentHeapBytesUsed, MemoryEventType type, InternalResourceManager.Thresholds thr) {
            this.currentHeapUsagePercent = currentHeapUsagePercent;
            this.currentHeapBytesUsed = currentHeapBytesUsed;
            this.type = type;
            this.thresholds = thr;
            return this;
        }

        public synchronized MemoryEventImpl getMemoryEvent() {
            return new MemoryEventImpl(this.type, this.getDistributedMember(), this.currentHeapUsagePercent, this.currentHeapBytesUsed, 0L, false, this.thresholds);
        }

        @Override
        public void processIncoming(DistributionManager dm, String adviseePath, boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache != null && !cache.isClosed()) {
                this.handleDistributionAdvisee(cache, removeProfile, exchangeProfiles, replyProfiles);
            }
        }

        @Override
        public StringBuilder getToStringHeader() {
            return new StringBuilder("ResourceAdvisor.ResourceManagerProfile");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            ResourceManagerProfile resourceManagerProfile = this;
            synchronized (resourceManagerProfile) {
                sb.append("; state=").append((Object)this.type).append("; currentHeapUsagePercent=").append(this.currentHeapUsagePercent).append("; currentHeapBytesUsed=").append(this.currentHeapBytesUsed);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            int chup = in.readInt();
            long chbu = in.readLong();
            MemoryEventType s = MemoryEventType.fromData(in);
            InternalResourceManager.Thresholds t = InternalResourceManager.Thresholds.fromData(in);
            this.setEventState(chup, chbu, s, t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toData(DataOutput out) throws IOException {
            InternalResourceManager.Thresholds t;
            MemoryEventType s;
            long chbu;
            int chup;
            ResourceManagerProfile resourceManagerProfile = this;
            synchronized (resourceManagerProfile) {
                chup = this.currentHeapUsagePercent;
                chbu = this.currentHeapBytesUsed;
                s = this.type;
                t = this.thresholds;
            }
            super.toData(out);
            out.writeInt(chup);
            out.writeLong(chbu);
            s.toData(out);
            t.toData(out);
        }

        @Override
        public int getDSFID() {
            return -107;
        }

        public synchronized MemoryEventType getType() {
            return this.type;
        }
    }

    public static class ResourceProfileMessage
    extends HighPriorityDistributionMessage {
        private volatile ResourceManagerProfile[] profiles;
        private volatile int processorId;

        public ResourceProfileMessage() {
        }

        private ResourceProfileMessage(Set<InternalDistributedMember> recips, ResourceManagerProfile[] ps) {
            this.setRecipients(recips);
            this.processorId = 0;
            this.profiles = ps;
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void process(DistributionManager dm) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public int getDSFID() {
            return -108;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            int l = in.readInt();
            if (l != -1) {
                this.profiles = new ResourceManagerProfile[l];
                for (int i = 0; i < this.profiles.length; ++i) {
                    ResourceManagerProfile r = new ResourceManagerProfile();
                    InternalDataSerializer.invokeFromData(r, in);
                    this.profiles[i] = r;
                }
            } else {
                this.profiles = null;
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            if (this.profiles != null) {
                out.writeInt(this.profiles.length);
                for (int i = 0; i < this.profiles.length; ++i) {
                    InternalDataSerializer.invokeToData(this.profiles[i], out);
                }
            } else {
                out.writeInt(-1);
            }
        }

        public static void send(InternalResourceManager irm, Set<InternalDistributedMember> recips, ResourceManagerProfile[] profiles) {
            DM dm = irm.getResourceAdvisor().getDistributionManager();
            ResourceProfileMessage r = new ResourceProfileMessage(recips, profiles);
            dm.putOutgoing(r);
        }

        @Override
        public String getShortClassName() {
            return "ResourceProfileMessage";
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getShortClassName()).append(" (processorId=").append(this.processorId).append("; profiles=[");
            for (int i = 0; i < this.profiles.length; ++i) {
                sb.append(this.profiles[i]);
                if (i >= this.profiles.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            sb.append(")");
            return sb.toString();
        }
    }
}

