/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.client.internal.ProxyCache;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.gemstone.gemfire.internal.cache.execute.InternalExecution;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.cache.execute.InternalResultSender;
import com.gemstone.gemfire.internal.cache.execute.LocalResultCollector;
import com.gemstone.gemfire.internal.cache.execute.LocalResultCollectorImpl;
import com.gemstone.gemfire.internal.cache.execute.MemberMappedArgument;
import com.gemstone.gemfire.internal.cache.execute.PartitionedRegionFunctionResultSender;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;

public abstract class AbstractExecution
implements InternalExecution {
    private static final Logger logger = LogService.getLogger();
    protected boolean isMemberMappedArgument;
    protected MemberMappedArgument memberMappedArg;
    protected Object args;
    protected ResultCollector rc;
    protected Set filter = new HashSet();
    protected boolean hasRoutingObjects;
    protected volatile boolean isReExecute = false;
    protected volatile boolean isClientServerMode = false;
    protected Set<String> failedNodes = new HashSet<String>();
    protected boolean isFnSerializationReqd;
    protected Collection<InternalDistributedMember> executionNodes = null;
    protected ExecutionNodesListener executionNodesListener = null;
    protected boolean waitOnException = false;
    protected boolean forwardExceptions = false;
    protected boolean ignoreDepartedMembers = false;
    protected ProxyCache proxyCache;
    private static final ConcurrentHashMap<String, byte[]> idToFunctionAttributes = new ConcurrentHashMap();
    public static final byte NO_HA_NO_HASRESULT_NO_OPTIMIZEFORWRITE = 0;
    public static final byte NO_HA_HASRESULT_NO_OPTIMIZEFORWRITE = 2;
    public static final byte HA_HASRESULT_NO_OPTIMIZEFORWRITE = 3;
    public static final byte NO_HA_NO_HASRESULT_OPTIMIZEFORWRITE = 4;
    public static final byte NO_HA_HASRESULT_OPTIMIZEFORWRITE = 6;
    public static final byte HA_HASRESULT_OPTIMIZEFORWRITE = 7;
    public static final byte HA_HASRESULT_NO_OPTIMIZEFORWRITE_REEXECUTE = 11;
    public static final byte HA_HASRESULT_OPTIMIZEFORWRITE_REEXECUTE = 15;

    public static final byte getFunctionState(boolean isHA, boolean hasResult, boolean optimizeForWrite) {
        if (isHA) {
            if (hasResult) {
                if (optimizeForWrite) {
                    return 7;
                }
                return 3;
            }
            return 1;
        }
        if (hasResult) {
            if (optimizeForWrite) {
                return 6;
            }
            return 2;
        }
        if (optimizeForWrite) {
            return 4;
        }
        return 0;
    }

    public static final byte getReexecuteFunctionState(byte fnState) {
        if (fnState == 3) {
            return 11;
        }
        if (fnState == 7) {
            return 15;
        }
        throw new InternalGemFireException("Wrong fnState provided.");
    }

    protected AbstractExecution() {
        this.hasRoutingObjects = false;
    }

    protected AbstractExecution(AbstractExecution ae) {
        if (ae.args != null) {
            this.args = ae.args;
        }
        if (ae.rc != null) {
            this.rc = ae.rc;
        }
        if (ae.memberMappedArg != null) {
            this.memberMappedArg = ae.memberMappedArg;
        }
        this.isMemberMappedArgument = ae.isMemberMappedArgument;
        this.hasRoutingObjects = ae.hasRoutingObjects;
        this.isClientServerMode = ae.isClientServerMode;
        if (ae.proxyCache != null) {
            this.proxyCache = ae.proxyCache;
        }
        this.isFnSerializationReqd = ae.isFnSerializationReqd;
    }

    protected AbstractExecution(AbstractExecution ae, boolean isReExecute) {
        this(ae);
        this.isReExecute = isReExecute;
    }

    public boolean isMemberMappedArgument() {
        return this.isMemberMappedArgument;
    }

    public Object getArgumentsForMember(String memberId) {
        if (!this.isMemberMappedArgument) {
            return this.args;
        }
        return this.memberMappedArg.getArgumentsForMember(memberId);
    }

    public MemberMappedArgument getMemberMappedArgument() {
        return this.memberMappedArg;
    }

    public Object getArguments() {
        return this.args;
    }

    public ResultCollector getResultCollector() {
        return this.rc;
    }

    @Override
    public AbstractExecution withRoutingObjects(Set<Object> routingObjects) {
        if (routingObjects == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_ROUTING_OBJECTS_SET_IS_NULL.toLocalizedString());
        }
        this.filter.clear();
        this.filter.addAll(routingObjects);
        this.hasRoutingObjects = true;
        return this;
    }

    public Set getFilter() {
        return this.filter;
    }

    public boolean hasRoutingObjects() {
        return this.hasRoutingObjects;
    }

    public AbstractExecution setIsReExecute() {
        this.isReExecute = true;
        if (this.executionNodesListener != null) {
            this.executionNodesListener.reset();
        }
        return this;
    }

    public boolean isReExecute() {
        return this.isReExecute;
    }

    public Set<String> getFailedNodes() {
        return this.failedNodes;
    }

    public void addFailedNode(String failedNode) {
        this.failedNodes.add(failedNode);
    }

    public void clearFailedNodes() {
        this.failedNodes.clear();
    }

    public boolean isClientServerMode() {
        return this.isClientServerMode;
    }

    public boolean isFnSerializationReqd() {
        return this.isFnSerializationReqd;
    }

    public final Collection<InternalDistributedMember> getExecutionNodes() {
        return this.executionNodes;
    }

    public final void setRequireExecutionNodes(ExecutionNodesListener listener) {
        this.executionNodes = Collections.emptySet();
        this.executionNodesListener = listener;
    }

    public final void setExecutionNodes(Set<InternalDistributedMember> nodes) {
        if (this.executionNodes != null) {
            this.executionNodes = nodes;
            if (this.executionNodesListener != null) {
                this.executionNodesListener.afterExecutionNodesSet(this);
            }
        }
    }

    public final void executeFunctionOnLocalPRNode(final Function fn, final FunctionContext cx, final PartitionedRegionFunctionResultSender sender, DM dm, boolean isTx) {
        if (dm instanceof DistributionManager && !isTx) {
            if (ServerConnection.isExecuteFunctionOnLocalNodeOnly() == 1) {
                ServerConnection.executeFunctionOnLocalNodeOnly((byte)3);
                this.executeFunctionLocally(fn, cx, sender, dm);
                if (!sender.isLastResultReceived() && fn.hasResult()) {
                    sender.setException(new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(fn.getId())));
                }
            } else {
                final DistributionManager newDM = (DistributionManager)dm;
                newDM.getFunctionExcecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractExecution.this.executeFunctionLocally(fn, cx, sender, newDM);
                        if (!sender.isLastResultReceived() && fn.hasResult()) {
                            sender.setException(new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(fn.getId())));
                        }
                    }
                });
            }
        } else {
            this.executeFunctionLocally(fn, cx, sender, dm);
            if (!sender.isLastResultReceived() && fn.hasResult()) {
                sender.setException(new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(fn.getId())));
            }
        }
    }

    public final void executeFunctionOnLocalNode(final Function fn, final FunctionContext cx, final ResultSender sender, DM dm, boolean isTx) {
        if (dm instanceof DistributionManager && !isTx) {
            final DistributionManager newDM = (DistributionManager)dm;
            newDM.getFunctionExcecutor().execute(new Runnable(){

                @Override
                public void run() {
                    AbstractExecution.this.executeFunctionLocally(fn, cx, sender, newDM);
                    if (!((InternalResultSender)sender).isLastResultReceived() && fn.hasResult()) {
                        ((InternalResultSender)sender).setException(new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(fn.getId())));
                    }
                }
            });
        } else {
            this.executeFunctionLocally(fn, cx, sender, dm);
            if (!((InternalResultSender)sender).isLastResultReceived() && fn.hasResult()) {
                ((InternalResultSender)sender).setException(new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(fn.getId())));
            }
        }
    }

    public final void executeFunctionLocally(Function fn, FunctionContext cx, ResultSender sender, DM dm) {
        FunctionStats stats = FunctionStats.getFunctionStats(fn.getId(), dm.getSystem());
        try {
            long start = stats.startTime();
            stats.startFunctionExecution(fn.hasResult());
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function: {} on local node with context: {}", fn.getId(), cx.toString());
            }
            fn.execute(cx);
            stats.endFunctionExecution(start, fn.hasResult());
        }
        catch (FunctionInvocationTargetException fite) {
            FunctionException functionException = null;
            functionException = fn.isHA() ? new FunctionException(new InternalFunctionInvocationTargetException(fite.getMessage())) : new FunctionException(fite);
            this.handleException(functionException, fn, cx, sender, dm);
        }
        catch (BucketMovedException bme) {
            FunctionException functionException = null;
            functionException = fn.isHA() ? new FunctionException(new InternalFunctionInvocationTargetException(bme)) : new FunctionException(bme);
            this.handleException(functionException, fn, cx, sender, dm);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.handleException(t, fn, cx, sender, dm);
        }
    }

    public ResultCollector execute(String functionName) {
        if (functionName == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString());
        }
        this.isFnSerializationReqd = false;
        Function functionObject = FunctionService.getFunction(functionName);
        if (functionObject == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_FUNCTION_NAMED_0_IS_NOT_REGISTERED.toLocalizedString(functionName));
        }
        return this.executeFunction(functionObject);
    }

    public ResultCollector execute(Function function) throws FunctionException {
        if (function == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString());
        }
        if (function.isHA() && !function.hasResult()) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH.toLocalizedString());
        }
        String id = function.getId();
        if (id == null) {
            throw new IllegalArgumentException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_GET_ID_RETURNED_NULL.toLocalizedString());
        }
        this.isFnSerializationReqd = true;
        return this.executeFunction(function);
    }

    @Override
    public final void setWaitOnExceptionFlag(boolean waitOnException) {
        this.waitOnException = waitOnException;
    }

    public boolean getWaitOnExceptionFlag() {
        return this.waitOnException;
    }

    @Override
    public void setForwardExceptions(boolean forward) {
        this.forwardExceptions = forward;
    }

    public boolean isForwardExceptions() {
        return this.forwardExceptions;
    }

    @Override
    public void setIgnoreDepartedMembers(boolean ignore) {
        this.ignoreDepartedMembers = ignore;
        if (ignore) {
            this.setWaitOnExceptionFlag(true);
        }
    }

    public boolean isIgnoreDepartedMembers() {
        return this.ignoreDepartedMembers;
    }

    protected abstract ResultCollector executeFunction(Function var1);

    public abstract void validateExecution(Function var1, Set var2);

    public final LocalResultCollector<?, ?> getLocalResultCollector(Function function, ResultCollector<?, ?> rc) {
        if (rc instanceof LocalResultCollector) {
            return (LocalResultCollector)rc;
        }
        return new LocalResultCollectorImpl(function, rc, this);
    }

    public byte[] getFunctionAttributes(String functionId) {
        if (functionId == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("functionId instance "));
        }
        return idToFunctionAttributes.get(functionId);
    }

    public void removeFunctionAttributes(String functionId) {
        idToFunctionAttributes.remove(functionId);
    }

    public void addFunctionAttributes(String functionId, byte[] functionAttributes) {
        idToFunctionAttributes.put(functionId, functionAttributes);
    }

    public ResultCollector execute(String functionName, boolean hasResult) throws FunctionException {
        byte functionState;
        if (functionName == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString());
        }
        Function functionObject = FunctionService.getFunction(functionName);
        if (functionObject == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_FUNCTION_NAMED_0_IS_NOT_REGISTERED.toLocalizedString(functionObject));
        }
        byte registeredFunctionState = AbstractExecution.getFunctionState(functionObject.isHA(), functionObject.hasResult(), functionObject.optimizeForWrite());
        if (registeredFunctionState != (functionState = AbstractExecution.getFunctionState(hasResult, hasResult, false))) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH_CLIENT_SERVER.toLocalizedString(functionName));
        }
        this.isFnSerializationReqd = false;
        return this.executeFunction(functionObject);
    }

    public ResultCollector execute(String functionName, boolean hasResult, boolean isHA) throws FunctionException {
        byte functionState;
        if (functionName == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString());
        }
        if (isHA && !hasResult) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH.toLocalizedString());
        }
        Function functionObject = FunctionService.getFunction(functionName);
        if (functionObject == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_FUNCTION_NAMED_0_IS_NOT_REGISTERED.toLocalizedString(functionObject));
        }
        byte registeredFunctionState = AbstractExecution.getFunctionState(functionObject.isHA(), functionObject.hasResult(), functionObject.optimizeForWrite());
        if (registeredFunctionState != (functionState = AbstractExecution.getFunctionState(isHA, hasResult, false))) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH_CLIENT_SERVER.toLocalizedString(functionName));
        }
        this.isFnSerializationReqd = false;
        return this.executeFunction(functionObject);
    }

    public ResultCollector execute(String functionName, boolean hasResult, boolean isHA, boolean isOptimizeForWrite) throws FunctionException {
        byte functionState;
        if (functionName == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString());
        }
        if (isHA && !hasResult) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH.toLocalizedString());
        }
        Function functionObject = FunctionService.getFunction(functionName);
        if (functionObject == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_FUNCTION_NAMED_0_IS_NOT_REGISTERED.toLocalizedString(functionObject));
        }
        byte registeredFunctionState = AbstractExecution.getFunctionState(functionObject.isHA(), functionObject.hasResult(), functionObject.optimizeForWrite());
        if (registeredFunctionState != (functionState = AbstractExecution.getFunctionState(isHA, hasResult, isOptimizeForWrite))) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH_CLIENT_SERVER.toLocalizedString(functionName));
        }
        this.isFnSerializationReqd = false;
        return this.executeFunction(functionObject);
    }

    private void handleException(Throwable functionException, Function fn, FunctionContext cx, ResultSender sender, DM dm) {
        FunctionStats stats = FunctionStats.getFunctionStats(fn.getId(), dm.getSystem());
        if (logger.isDebugEnabled()) {
            logger.debug("Exception occured on local node while executing Function: {}", fn.getId(), functionException);
        }
        stats.endFunctionExecutionWithException(fn.hasResult());
        if (fn.hasResult()) {
            if (this.waitOnException || this.forwardExceptions) {
                sender.lastResult(functionException);
            } else {
                ((InternalResultSender)sender).setException(functionException);
            }
        } else {
            logger.warn(LocalizedMessage.create(LocalizedStrings.FunctionService_EXCEPTION_ON_LOCAL_NODE), functionException);
        }
    }

    public static interface ExecutionNodesListener {
        public void afterExecutionNodesSet(AbstractExecution var1);

        public void reset();
    }
}

