/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.FunctionStreamingReplyMessage;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gemfire.internal.cache.execute.DistributedRegionFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.cache.execute.LocalResultCollector;
import com.gemstone.gemfire.internal.cache.execute.MultiRegionFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.StreamingFunctionOperation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;

public class FunctionStreamingResultCollector
extends ReplyProcessor21
implements ResultCollector {
    private static final Logger logger = LogService.getLogger();
    protected ResultCollector userRC;
    protected Function fn;
    volatile RuntimeException colEx;
    protected boolean resultCollected = false;
    protected final AtomicInteger msgsBeingProcessed = new AtomicInteger();
    private final Map<InternalDistributedMember, Status> statusMap = new HashMap<InternalDistributedMember, Status>();
    private Set<InternalDistributedMember> removedNodes = new HashSet<InternalDistributedMember>();
    private volatile boolean finishedWaiting = false;
    private StreamingFunctionOperation functionResultWaiter;
    private final Object processSingleResult = new Object();
    protected AbstractExecution execution;
    protected volatile boolean endResultRecieved = false;
    protected volatile List<FunctionInvocationTargetException> fites;

    public FunctionStreamingResultCollector(StreamingFunctionOperation streamingFunctionOperation, InternalDistributedSystem system, Set members, ResultCollector rc, Function function, AbstractExecution execution) {
        super(system.getDistributionManager(), system, members, null, function.hasResult());
        this.functionResultWaiter = streamingFunctionOperation;
        this.userRC = rc;
        this.fn = function;
        this.execution = execution;
        this.fites = Collections.synchronizedList(new ArrayList());
        if (rc instanceof LocalResultCollector) {
            ((LocalResultCollector)rc).setProcessor(this);
        }
    }

    public void addResult(DistributedMember memId, Object resultOfSingleExecution) {
        if (this.userRC != null && !this.endResultRecieved) {
            try {
                this.userRC.addResult(memId, resultOfSingleExecution);
            }
            catch (RuntimeException badre) {
                this.colEx = badre;
            }
            catch (Exception bade) {
                this.colEx = new RuntimeException(bade);
            }
        }
    }

    @Override
    public void endResults() {
        if (this.userRC != null) {
            this.userRC.endResults();
            this.endResultRecieved = true;
        }
    }

    @Override
    public void clearResults() {
        if (this.userRC != null) {
            this.endResultRecieved = false;
            this.userRC.clearResults();
        }
        this.fites.clear();
    }

    public Object getResult() throws FunctionException {
        if (this.resultCollected) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_RESULTS_ALREADY_COLLECTED.toLocalizedString());
        }
        this.resultCollected = true;
        if (this.userRC != null) {
            block17: {
                try {
                    if (this.execution instanceof DistributedRegionFunctionExecutor || this.execution instanceof MultiRegionFunctionExecutor) {
                        this.waitForCacheOrFunctionException(0L);
                    } else {
                        this.waitForRepliesUninterruptibly(0L);
                    }
                    if (this.removedNodes != null && this.removedNodes.size() != 0) {
                        this.clearResults();
                        this.execution = this.execution.setIsReExecute();
                        ResultCollector newRc = null;
                        newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                        return newRc.getResult();
                    }
                    if (!this.execution.getWaitOnExceptionFlag() && this.fites.size() > 0) {
                        throw new FunctionException(this.fites.get(0));
                    }
                }
                catch (FunctionInvocationTargetException fite) {
                    if (!(this.execution instanceof DistributedRegionFunctionExecutor) && !(this.execution instanceof MultiRegionFunctionExecutor) || !this.fn.isHA()) {
                        throw new FunctionException(fite);
                    }
                    if (this.execution.isClientServerMode()) {
                        this.clearResults();
                        InternalFunctionInvocationTargetException iFITE = new InternalFunctionInvocationTargetException(fite.getMessage());
                        throw new FunctionException(iFITE);
                    }
                    this.clearResults();
                    this.execution = this.execution.setIsReExecute();
                    ResultCollector newRc = null;
                    newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                    return newRc.getResult();
                }
                catch (CacheClosedException e) {
                    if (!(this.execution instanceof DistributedRegionFunctionExecutor) && !(this.execution instanceof MultiRegionFunctionExecutor) || !this.fn.isHA()) {
                        FunctionInvocationTargetException fite = new FunctionInvocationTargetException(e.getMessage());
                        throw new FunctionException(fite);
                    }
                    if (this.execution.isClientServerMode()) {
                        this.clearResults();
                        InternalFunctionInvocationTargetException fite = new InternalFunctionInvocationTargetException(e.getMessage());
                        throw new FunctionException(fite);
                    }
                    this.clearResults();
                    this.execution = this.execution.setIsReExecute();
                    ResultCollector newRc = null;
                    newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                    return newRc.getResult();
                }
                catch (ForceReattemptException e) {
                    if (!(this.execution instanceof DistributedRegionFunctionExecutor) && !(this.execution instanceof MultiRegionFunctionExecutor) || !this.fn.isHA()) {
                        FunctionInvocationTargetException fite = new FunctionInvocationTargetException(e.getMessage());
                        throw new FunctionException(fite);
                    }
                    if (this.execution.isClientServerMode()) {
                        this.clearResults();
                        InternalFunctionInvocationTargetException fite = new InternalFunctionInvocationTargetException(e.getMessage());
                        throw new FunctionException(fite);
                    }
                    this.clearResults();
                    this.execution = this.execution.setIsReExecute();
                    ResultCollector newRc = null;
                    newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                    return newRc.getResult();
                }
                catch (ReplyException e) {
                    if (this.execution.waitOnException || this.execution.forwardExceptions) break block17;
                    throw new FunctionException(e.getCause());
                }
            }
            return this.userRC.getResult();
        }
        return null;
    }

    public Object getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
        long timeoutInMillis = unit.toMillis(timeout);
        if (this.resultCollected) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_RESULTS_ALREADY_COLLECTED.toLocalizedString());
        }
        this.resultCollected = true;
        if (this.userRC != null) {
            block17: {
                try {
                    long timeBefore = System.currentTimeMillis();
                    boolean isNotTimedOut = this.execution instanceof DistributedRegionFunctionExecutor || this.execution instanceof MultiRegionFunctionExecutor ? this.waitForCacheOrFunctionException(timeoutInMillis) : this.waitForRepliesUninterruptibly(timeoutInMillis);
                    if (!isNotTimedOut) {
                        throw new FunctionException(LocalizedStrings.ExecuteFunction_RESULTS_NOT_COLLECTED_IN_TIME_PROVIDED.toLocalizedString());
                    }
                    long timeAfter = System.currentTimeMillis();
                    if ((timeoutInMillis -= timeAfter - timeBefore) < 0L) {
                        timeoutInMillis = 0L;
                    }
                    if (this.removedNodes != null && this.removedNodes.size() != 0) {
                        this.clearResults();
                        this.execution = this.execution.setIsReExecute();
                        ResultCollector newRc = null;
                        newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                        return newRc.getResult(timeoutInMillis, unit);
                    }
                    if (!this.execution.getWaitOnExceptionFlag() && this.fites.size() > 0) {
                        throw new FunctionException(this.fites.get(0));
                    }
                }
                catch (FunctionInvocationTargetException fite) {
                    if (!(this.execution instanceof DistributedRegionFunctionExecutor) && !(this.execution instanceof MultiRegionFunctionExecutor) || !this.fn.isHA()) {
                        throw new FunctionException(fite);
                    }
                    if (this.execution.isClientServerMode()) {
                        this.clearResults();
                        InternalFunctionInvocationTargetException iFITE = new InternalFunctionInvocationTargetException(fite.getMessage());
                        throw new FunctionException(iFITE);
                    }
                    this.clearResults();
                    this.execution = this.execution.setIsReExecute();
                    ResultCollector newRc = null;
                    newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                    return newRc.getResult(timeoutInMillis, unit);
                }
                catch (CacheClosedException e) {
                    if (!(this.execution instanceof DistributedRegionFunctionExecutor) && !(this.execution instanceof MultiRegionFunctionExecutor) || !this.fn.isHA()) {
                        FunctionInvocationTargetException fite = new FunctionInvocationTargetException(e.getMessage());
                        throw new FunctionException(fite);
                    }
                    if (this.execution.isClientServerMode()) {
                        this.clearResults();
                        InternalFunctionInvocationTargetException fite = new InternalFunctionInvocationTargetException(e.getMessage());
                        throw new FunctionException(fite);
                    }
                    this.clearResults();
                    this.execution = this.execution.setIsReExecute();
                    ResultCollector newRc = null;
                    newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                    return newRc.getResult(timeoutInMillis, unit);
                }
                catch (ForceReattemptException e) {
                    if (!(this.execution instanceof DistributedRegionFunctionExecutor) && !(this.execution instanceof MultiRegionFunctionExecutor) || !this.fn.isHA()) {
                        FunctionInvocationTargetException fite = new FunctionInvocationTargetException(e.getMessage());
                        throw new FunctionException(fite);
                    }
                    if (this.execution.isClientServerMode()) {
                        this.clearResults();
                        InternalFunctionInvocationTargetException fite = new InternalFunctionInvocationTargetException(e.getMessage());
                        throw new FunctionException(fite);
                    }
                    this.clearResults();
                    this.execution = this.execution.setIsReExecute();
                    ResultCollector newRc = null;
                    newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                    return newRc.getResult(timeoutInMillis, unit);
                }
                catch (ReplyException e) {
                    if (this.execution.waitOnException || this.execution.forwardExceptions) break block17;
                    throw new FunctionException(e.getCause());
                }
            }
            return this.userRC.getResult(timeoutInMillis, unit);
        }
        return null;
    }

    @Override
    protected void postFinish() {
        if (this.execution.getWaitOnExceptionFlag() && this.fites.size() > 0) {
            for (int index2 = 0; index2 < this.fites.size(); ++index2) {
                this.functionResultWaiter.processData(this.fites.get(index2), true, this.fites.get(index2).getMemberId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
        if (id == null) return;
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            if (this.removeMember(id, true)) {
                FunctionInvocationTargetException fe;
                if (this.execution instanceof DistributedRegionFunctionExecutor || this.execution instanceof MultiRegionFunctionExecutor) {
                    if (!this.fn.isHA()) {
                        fe = new FunctionInvocationTargetException(LocalizedStrings.MemberMessage_MEMBERRESPONSE_GOT_MEMBERDEPARTED_EVENT_FOR_0_CRASHED_1.toLocalizedString(id, crashed), id);
                    } else {
                        fe = new InternalFunctionInvocationTargetException(LocalizedStrings.DistributionMessage_DISTRIBUTIONRESPONSE_GOT_MEMBERDEPARTED_EVENT_FOR_0_CRASHED_1.toLocalizedString(id, crashed), id);
                        if (this.execution.isClientServerMode()) {
                            if (this.userRC != null) {
                                this.endResultRecieved = false;
                                this.userRC.endResults();
                                this.userRC.clearResults();
                            }
                        } else {
                            if (this.removedNodes == null) {
                                this.removedNodes = new HashSet<InternalDistributedMember>();
                            }
                            this.removedNodes.add(id);
                        }
                    }
                    this.fites.add(fe);
                } else {
                    fe = new FunctionInvocationTargetException(LocalizedStrings.MemberMessage_MEMBERRESPONSE_GOT_MEMBERDEPARTED_EVENT_FOR_0_CRASHED_1.toLocalizedString(id, crashed), id);
                }
                this.fites.add(fe);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.checkIfDone();
            return;
        }
    }

    public boolean waitForCacheOrFunctionException(long timeout) throws CacheException, ForceReattemptException {
        boolean timedOut = false;
        try {
            if (timeout == 0L) {
                this.waitForRepliesUninterruptibly();
                timedOut = true;
            } else {
                timedOut = this.waitForRepliesUninterruptibly(timeout);
            }
        }
        catch (ReplyException e) {
            this.removeMember(e.getSender(), true);
            Throwable t = e.getCause();
            if (t instanceof CacheException) {
                throw (CacheException)t;
            }
            if (t instanceof RegionDestroyedException) {
                throw (RegionDestroyedException)t;
            }
            if (t instanceof ForceReattemptException) {
                throw new ForceReattemptException("Peer requests reattempt", t);
            }
            if (t instanceof PrimaryBucketException) {
                throw new PrimaryBucketException("Peer failed primary test", t);
            }
            if (t instanceof CancelException) {
                this.execution.failedNodes.add(e.getSender().getId());
                String msg = "PartitionResponse got remote CacheClosedException, throwing PartitionedRegionCommunicationException";
                logger.debug("{}, throwing ForceReattemptException", msg, t);
                throw (CancelException)t;
            }
            if (e.getCause() instanceof FunctionException) {
                throw (FunctionException)e.getCause();
            }
            e.handleAsUnexpected();
        }
        return timedOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DistributionMessage msg) {
        block13: {
            if (!this.waitingOnMember(msg.getSender())) {
                return;
            }
            this.msgsBeingProcessed.incrementAndGet();
            try {
                ReplyMessage m = (ReplyMessage)msg;
                if (m.getException() == null) {
                    FunctionStreamingReplyMessage functionReplyMsg = (FunctionStreamingReplyMessage)m;
                    Object result = functionReplyMsg.getResult();
                    boolean isLast = false;
                    Object object = this.processSingleResult;
                    synchronized (object) {
                        isLast = this.trackMessage(functionReplyMsg);
                        this.functionResultWaiter.processData(result, isLast, msg.getSender());
                    }
                    if (isLast) {
                        super.process(msg, false);
                    }
                    break block13;
                }
                if (this.execution.forwardExceptions || this.execution.waitOnException && !(m.getException().getCause() instanceof BucketMovedException)) {
                    Object object = this.processSingleResult;
                    synchronized (object) {
                        this.functionResultWaiter.processData(m.getException().getCause(), true, msg.getSender());
                    }
                }
                super.process(msg, false);
            }
            finally {
                this.msgsBeingProcessed.decrementAndGet();
                this.checkIfDone();
            }
        }
    }

    protected boolean trackMessage(FunctionStreamingReplyMessage m) {
        Status status = this.statusMap.get(m.getSender());
        if (status == null) {
            status = new Status();
            this.statusMap.put(m.getSender(), status);
        }
        return status.trackMessage(m);
    }

    @Override
    protected boolean stillWaiting() {
        if (this.finishedWaiting) {
            return false;
        }
        if (this.msgsBeingProcessed.get() > 0 && this.numMembers() > 0) {
            return true;
        }
        this.finishedWaiting = this.finishedWaiting || !this.stillWaitingFromNodes();
        return !this.finishedWaiting;
    }

    protected boolean stillWaitingFromNodes() {
        if (this.shutdown) {
            ReplyException re;
            this.exception = re = new ReplyException(new DistributedSystemDisconnectedException(LocalizedStrings.ReplyProcessor21_ABORTED_DUE_TO_SHUTDOWN.toLocalizedString()));
            return false;
        }
        return this.numMembers() > 0;
    }

    @Override
    protected synchronized void processException(ReplyException ex) {
        if (this.execution.isForwardExceptions()) {
            return;
        }
        if (ex.getCause() instanceof CacheClosedException || ex.getCause() instanceof ForceReattemptException || ex.getCause() instanceof BucketMovedException) {
            this.exception = ex;
        } else if (!this.execution.getWaitOnExceptionFlag()) {
            this.exception = ex;
        }
    }

    @Override
    protected boolean stopBecauseOfExceptions() {
        if (this.execution.isIgnoreDepartedMembers()) {
            return false;
        }
        return super.stopBecauseOfExceptions();
    }

    protected class Status {
        int msgsProcessed = 0;
        int numMsgs = 0;

        protected Status() {
        }

        protected boolean trackMessage(FunctionStreamingReplyMessage m) {
            ++this.msgsProcessed;
            if (m.isLastMessage()) {
                this.numMsgs = m.getMessageNumber() + 1;
            }
            return this.msgsProcessed == this.numMsgs;
        }
    }
}

