/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.internal.FunctionServiceManager;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.execute.MultiRegionFunctionExecutor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Set;

public class InternalFunctionService {
    private static final FunctionServiceManager funcServiceManager = new FunctionServiceManager();

    public static Execution onRegions(Set<Region> regions) {
        if (regions == null) {
            throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("regions set"));
        }
        if (regions.contains(null)) {
            throw new IllegalArgumentException(LocalizedStrings.OnRegionsFunctions_THE_REGION_SET_FOR_ONREGIONS_HAS_NULL.toLocalizedString());
        }
        if (regions.isEmpty()) {
            throw new IllegalArgumentException(LocalizedStrings.OnRegionsFunctions_THE_REGION_SET_IS_EMPTY_FOR_ONREGIONS.toLocalizedString());
        }
        for (Region region : regions) {
            if (!InternalFunctionService.isClientRegion(region)) continue;
            throw new UnsupportedOperationException(LocalizedStrings.OnRegionsFunctions_NOT_SUPPORTED_FOR_CLIENT_SERVER.toLocalizedString());
        }
        return new MultiRegionFunctionExecutor(regions);
    }

    private static boolean isClientRegion(Region region) {
        LocalRegion localRegion = (LocalRegion)region;
        return localRegion.hasServerProxy() || AbstractRegion.isBridgeLoader(localRegion.getCacheLoader()) || AbstractRegion.isBridgeWriter(localRegion.getCacheWriter());
    }

    public static Execution onServers(RegionService regionService, String ... groups) {
        return funcServiceManager.onServers(regionService, groups);
    }

    public static Execution onServer(RegionService regionService, String ... groups) {
        return funcServiceManager.onServer(regionService, groups);
    }

    public static Execution onServers(Pool pool, String ... groups) {
        return funcServiceManager.onServers(pool, groups);
    }

    public static Execution onServer(Pool pool, String ... groups) {
        return funcServiceManager.onServer(pool, groups);
    }
}

