/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionException;
import com.gemstone.gemfire.internal.cache.execute.InternalResultSender;
import com.gemstone.gemfire.internal.cache.execute.LocalResultCollector;
import com.gemstone.gemfire.internal.cache.execute.ServerToClientFunctionResultSender;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionedRegionFunctionStreamingMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class PartitionedRegionFunctionResultSender
implements InternalResultSender {
    private static final Logger logger = LogService.getLogger();
    PartitionedRegionFunctionStreamingMessage msg = null;
    private final DM dm;
    private final PartitionedRegion pr;
    private final long time;
    private final boolean forwardExceptions;
    private ResultCollector rc;
    private ServerToClientFunctionResultSender serverSender;
    private boolean localLastResultRecieved = false;
    private boolean onlyLocal = false;
    private boolean onlyRemote = false;
    private boolean completelyDoneFromRemote = false;
    private final Function function;
    private boolean enableOrderedResultStreming;
    private Set<Integer> bucketSet;

    public PartitionedRegionFunctionResultSender(DM dm, PartitionedRegion pr2, long time, PartitionedRegionFunctionStreamingMessage msg, Function function, Set<Integer> bucketSet) {
        this.msg = msg;
        this.dm = dm;
        this.pr = pr2;
        this.time = time;
        this.function = function;
        this.bucketSet = bucketSet;
        this.forwardExceptions = false;
    }

    public PartitionedRegionFunctionResultSender(DM dm, PartitionedRegion partitionedRegion, long time, ResultCollector rc, ServerToClientFunctionResultSender sender, boolean onlyLocal, boolean onlyRemote, boolean forwardExceptions, Function function, Set<Integer> bucketSet) {
        this.dm = dm;
        this.pr = partitionedRegion;
        this.time = time;
        this.rc = rc;
        this.serverSender = sender;
        this.onlyLocal = onlyLocal;
        this.onlyRemote = onlyRemote;
        this.forwardExceptions = forwardExceptions;
        this.function = function;
        this.bucketSet = bucketSet;
    }

    @Override
    public void lastResult(Object oneResult) {
        if (!this.function.hasResult()) {
            throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
        }
        if (!(this.forwardExceptions && oneResult instanceof Throwable || this.pr.getDataStore().areAllBucketsHosted(this.bucketSet))) {
            throw new BucketMovedException(LocalizedStrings.FunctionService_BUCKET_MIGRATED_TO_ANOTHER_NODE.toLocalizedString());
        }
        if (this.serverSender != null) {
            if (this.localLastResultRecieved) {
                return;
            }
            if (this.onlyLocal) {
                this.lastClientSend(this.dm.getDistributionManagerId(), oneResult);
                this.rc.endResults();
                this.localLastResultRecieved = true;
            } else {
                this.lastResult(oneResult, this.rc, false, true, this.dm.getDistributionManagerId());
            }
        } else {
            if (this.msg != null) {
                try {
                    this.msg.sendReplyForOneResult(this.dm, this.pr, this.time, oneResult, true, this.enableOrderedResultStreming);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            } else {
                if (this.localLastResultRecieved) {
                    return;
                }
                if (this.onlyLocal) {
                    this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                    this.rc.endResults();
                    this.localLastResultRecieved = true;
                } else {
                    this.lastResult(oneResult, this.rc, false, true, this.dm.getDistributionManagerId());
                }
                FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReceived();
            }
            FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReturned();
        }
    }

    private synchronized void lastResult(Object oneResult, ResultCollector collector, boolean lastRemoteResult, boolean lastLocalResult, DistributedMember memberID) {
        if (lastRemoteResult) {
            this.completelyDoneFromRemote = true;
        }
        if (lastLocalResult) {
            this.localLastResultRecieved = true;
        }
        if (this.serverSender != null) {
            if (this.completelyDoneFromRemote && this.localLastResultRecieved) {
                this.lastClientSend(memberID, oneResult);
                collector.endResults();
            } else {
                this.clientSend(oneResult, memberID);
            }
        } else if (this.completelyDoneFromRemote && this.localLastResultRecieved) {
            collector.addResult(memberID, oneResult);
            collector.endResults();
        } else {
            collector.addResult(memberID, oneResult);
        }
    }

    public void lastResult(Object oneResult, boolean completelyDone, ResultCollector reply, DistributedMember memberID) {
        logger.debug("PartitionedRegionFunctionResultSender Sending lastResult {}", oneResult);
        if (this.serverSender != null) {
            if (completelyDone) {
                if (this.onlyRemote) {
                    this.lastClientSend(memberID, oneResult);
                    reply.endResults();
                } else {
                    this.lastResult(oneResult, reply, true, false, memberID);
                }
            } else {
                this.clientSend(oneResult, memberID);
            }
        } else {
            if (completelyDone) {
                if (this.onlyRemote) {
                    reply.addResult(memberID, oneResult);
                    reply.endResults();
                } else {
                    this.lastResult(oneResult, reply, true, false, memberID);
                }
            } else {
                reply.addResult(memberID, oneResult);
            }
            FunctionStats.getFunctionStats(this.function.getId(), this.dm == null ? null : this.dm.getSystem()).incResultsReceived();
        }
        FunctionStats.getFunctionStats(this.function.getId(), this.dm == null ? null : this.dm.getSystem()).incResultsReturned();
    }

    @Override
    public void sendResult(Object oneResult) {
        if (!this.function.hasResult()) {
            throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
        }
        if (this.serverSender != null) {
            logger.debug("PartitionedRegionFunctionResultSender sending result from local node to client {}", oneResult);
            this.clientSend(oneResult, this.dm.getDistributionManagerId());
        } else {
            if (this.msg != null) {
                try {
                    logger.debug("PartitionedRegionFunctionResultSender sending result from remote node {}", oneResult);
                    this.msg.sendReplyForOneResult(this.dm, this.pr, this.time, oneResult, false, this.enableOrderedResultStreming);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            } else {
                logger.debug("PartitionedRegionFunctionResultSender adding result to ResultCollector on local node {}", oneResult);
                this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReceived();
            }
            FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReturned();
        }
    }

    private void clientSend(Object oneResult, DistributedMember memberID) {
        this.serverSender.sendResult(oneResult, memberID);
    }

    private void lastClientSend(DistributedMember memberID, Object lastResult) {
        this.serverSender.lastResult(lastResult, memberID);
    }

    @Override
    public void sendException(Throwable exception) {
        InternalFunctionException iFunxtionException = new InternalFunctionException(exception);
        this.lastResult(iFunxtionException);
        this.localLastResultRecieved = true;
    }

    @Override
    public void setException(Throwable exception) {
        if (this.serverSender != null) {
            this.serverSender.setException(exception);
        } else {
            ((LocalResultCollector)this.rc).setException(exception);
            logger.fatal(LocalizedMessage.create(LocalizedStrings.PartitionedRegionFunctionResultSender_UNEXPECTED_EXCEPTION_DURING_FUNCTION_EXECUTION_ON_LOCAL_NODE), exception);
        }
        this.rc.endResults();
        this.localLastResultRecieved = true;
    }

    @Override
    public void enableOrderedResultStreming(boolean enable) {
        this.enableOrderedResultStreming = enable;
    }

    @Override
    public boolean isLocallyExecuted() {
        return this.msg == null;
    }

    @Override
    public boolean isLastResultReceived() {
        return this.localLastResultRecieved;
    }
}

