/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.DistributedRegionFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.DistributedRegionFunctionResultSender;
import com.gemstone.gemfire.internal.cache.execute.FunctionStreamingResultCollector;
import com.gemstone.gemfire.internal.cache.execute.MemberFunctionResultSender;
import com.gemstone.gemfire.internal.cache.execute.MultiRegionFunctionExecutor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public abstract class StreamingFunctionOperation {
    protected final InternalDistributedSystem sys;
    protected Set recipients = null;
    protected ResultCollector rc;
    protected Function functionObject;
    protected HashMap<InternalDistributedMember, Object> memberArgs;
    protected ResultSender resultSender = null;
    protected ResultCollector reply;
    protected int totalLastMsgRecieved = 0;

    public StreamingFunctionOperation(InternalDistributedSystem sys, ResultCollector rc, Function function, HashMap<InternalDistributedMember, Object> memberArgs, Set recipients, ResultSender resultSender) {
        this.sys = sys;
        this.rc = rc;
        this.functionObject = function;
        this.memberArgs = memberArgs;
        this.recipients = recipients;
        this.resultSender = resultSender;
    }

    public StreamingFunctionOperation(InternalDistributedSystem sys, ResultCollector rc, Function function, ResultSender resultSender) {
        this.sys = sys;
        this.rc = rc;
        this.functionObject = function;
        this.resultSender = resultSender;
    }

    public void processData(Object result, boolean lastMsg, DistributedMember memberID) {
        boolean completelyDone = false;
        if (lastMsg) {
            ++this.totalLastMsgRecieved;
        }
        if (this.totalLastMsgRecieved == this.recipients.size()) {
            completelyDone = true;
        }
        if (this.resultSender instanceof MemberFunctionResultSender) {
            MemberFunctionResultSender rs = (MemberFunctionResultSender)this.resultSender;
            rs.lastResult(result, completelyDone, this.reply, memberID);
        } else if (completelyDone) {
            ((DistributedRegionFunctionResultSender)this.resultSender).lastResult(result, memberID);
        } else {
            ((DistributedRegionFunctionResultSender)this.resultSender).sendResult(result, memberID);
        }
    }

    public ResultCollector getFunctionResultFrom(Set recipients, Function function, AbstractExecution execution) {
        if (recipients.isEmpty()) {
            return this.rc;
        }
        FunctionStreamingResultCollector processor = new FunctionStreamingResultCollector(this, this.sys, recipients, this.rc, function, execution);
        this.reply = processor;
        for (InternalDistributedMember recip : this.memberArgs.keySet()) {
            DistributionMessage m = null;
            m = execution instanceof DistributedRegionFunctionExecutor || execution instanceof MultiRegionFunctionExecutor ? this.createRequestMessage(Collections.singleton(recip), processor, execution.isReExecute(), execution.isFnSerializationReqd()) : this.createRequestMessage(Collections.singleton(recip), processor, false, execution.isFnSerializationReqd());
            this.sys.getDistributionManager().putOutgoing(m);
        }
        return processor;
    }

    protected abstract DistributionMessage createRequestMessage(Set<InternalDistributedMember> var1, FunctionStreamingResultCollector var2, boolean var3, boolean var4);
}

