/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.internal.Endpoint;
import com.gemstone.gemfire.cache.client.internal.EndpointManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PoolManagerImpl;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.execute.ServerFunctionExecutor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class TransactionFunctionService {
    private static final ConcurrentMap<DistributedMember, ServerLocation> memberToServerLocation = new ConcurrentHashMap<DistributedMember, ServerLocation>();

    private TransactionFunctionService() {
    }

    public static Execution onTransaction(TransactionId transactionId) {
        Execution execution = null;
        GemFireCacheImpl cache = GemFireCacheImpl.getExisting("getting transaction execution");
        if (cache.hasPool()) {
            if (cache.getLoggerI18n().fineEnabled()) {
                cache.getLoggerI18n().fine("TxFunctionService: inClientMode");
            }
            PoolImpl pool = (PoolImpl)TransactionFunctionService.getPool(cache);
            InternalDistributedMember member = ((TXId)transactionId).getMemberId();
            ServerLocation loc = (ServerLocation)memberToServerLocation.get(member);
            if (loc == null) {
                loc = TransactionFunctionService.getServerLocationForMember(pool, member);
                if (loc == null) {
                    throw new TransactionDataNodeHasDepartedException("Could not connect to member:" + member);
                }
                memberToServerLocation.put(member, loc);
            }
            pool.setupServerAffinity(false);
            pool.setServerAffinityLocation(loc);
            if (cache.getLoggerI18n().fineEnabled()) {
                cache.getLoggerI18n().fine("TxFunctionService: setting server affinity to:" + loc + " which represents member:" + member);
            }
            execution = FunctionService.onServer(pool).withArgs(transactionId);
            ((ServerFunctionExecutor)execution).setOnBehalfOfTXFunctionService(true);
        } else {
            if (cache.getLoggerI18n().fineEnabled()) {
                cache.getLoggerI18n().fine("TxFunctionService: inPeerMode");
            }
            TXId txId = (TXId)transactionId;
            InternalDistributedMember member = txId.getMemberId();
            execution = FunctionService.onMember(cache.getDistributedSystem(), member).withArgs(transactionId);
        }
        return execution;
    }

    private static ServerLocation getServerLocationForMember(PoolImpl pool, DistributedMember member) {
        Map<ServerLocation, Endpoint> endPoints = pool.getEndpointMap();
        for (Endpoint endPoint : endPoints.values()) {
            if (!endPoint.getMemberId().equals(member)) continue;
            return endPoint.getLocation();
        }
        return null;
    }

    private static Pool getPool(GemFireCacheImpl cache) {
        Pool pool = cache.getDefaultPool();
        if (pool == null) {
            Collection<Pool> pools = TransactionFunctionService.getPools();
            if (pools.size() > 1) {
                throw new IllegalStateException("More than one pools found");
            }
            pool = pools.iterator().next();
        }
        return pool;
    }

    private static Collection<Pool> getPools() {
        Collection<Pool> pools = PoolManagerImpl.getPMI().getMap().values();
        Iterator<Pool> itr = pools.iterator();
        while (itr.hasNext()) {
            PoolImpl pool = (PoolImpl)itr.next();
            if (!pool.isUsedByGateway()) continue;
            itr.remove();
        }
        return pools;
    }

    public static class ListenerForTransactionFunctionService
    implements EndpointManager.EndpointListener {
        @Override
        public void endpointNoLongerInUse(Endpoint endpoint) {
        }

        @Override
        public void endpointCrashed(Endpoint endpoint) {
        }

        @Override
        public void endpointNowInUse(Endpoint endpoint) {
            assert (endpoint != null);
            memberToServerLocation.put(endpoint.getMemberId(), endpoint.getLocation());
        }
    }
}

