/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute.util;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.ArrayList;
import org.apache.logging.log4j.Logger;

public class NestedTransactionFunction
implements Function {
    private static final Logger logger = LogService.getLogger();
    public static final int COMMIT = 1;
    public static final int ROLLBACK = 2;
    private static final long serialVersionUID = 1400965724856341543L;

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public void execute(FunctionContext context) {
        Cache cache = CacheFactory.getAnyInstance();
        ArrayList args = (ArrayList)context.getArguments();
        TXId txId = null;
        int action = 0;
        try {
            txId = (TXId)args.get(0);
            action = (Integer)args.get(1);
        }
        catch (ClassCastException e) {
            logger.info("CommitFunction should be invoked with a TransactionId as an argument i.e. withArgs(txId).execute(function)");
            throw e;
        }
        CacheTransactionManager txMgr = cache.getCacheTransactionManager();
        Boolean result = false;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (txMgr.tryResume(txId)) {
            if (isDebugEnabled) {
                logger.debug("CommitFunction: resumed transaction: {}", txId);
            }
            if (action == 1) {
                if (isDebugEnabled) {
                    logger.debug("CommitFunction: committing transaction: {}", txId);
                }
                txMgr.commit();
            } else if (action == 2) {
                if (isDebugEnabled) {
                    logger.debug("CommitFunction: rolling back transaction: {}", txId);
                }
                txMgr.rollback();
            } else {
                throw new IllegalStateException("unknown transaction termination action");
            }
            result = true;
        }
        if (isDebugEnabled) {
            logger.debug("CommitFunction: for transaction: {} sending result: {}", txId, result);
        }
        context.getResultSender().lastResult(result);
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public boolean optimizeForWrite() {
        return true;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

