/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute.util;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.execute.util.NestedTransactionFunction;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class RollbackFunction
implements Function {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1377183180063184795L;

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public void execute(FunctionContext context) {
        Cache cache = CacheFactory.getAnyInstance();
        TXId txId = null;
        try {
            txId = (TXId)context.getArguments();
        }
        catch (ClassCastException e) {
            logger.info("RollbackFunction should be invoked with a TransactionId as an argument i.e. withArgs(txId).execute(function)");
            throw e;
        }
        InternalDistributedMember member = txId.getMemberId();
        Boolean result = false;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (cache.getDistributedSystem().getDistributedMember().equals(member)) {
            CacheTransactionManager txMgr;
            if (isDebugEnabled) {
                logger.debug("RollbackFunction: for transaction: {} rolling back locally", txId);
            }
            if ((txMgr = cache.getCacheTransactionManager()).tryResume(txId)) {
                if (isDebugEnabled) {
                    logger.debug("RollbackFunction: resumed transaction: {}", txId);
                }
                txMgr.rollback();
                result = true;
            }
        } else {
            ArrayList<Serializable> args = new ArrayList<Serializable>();
            args.add(txId);
            args.add(Integer.valueOf(2));
            Execution ex = FunctionService.onMember(cache.getDistributedSystem(), member).withArgs(args);
            if (isDebugEnabled) {
                logger.debug("RollbackFunction: for transaction: {} executing NestedTransactionFunction on member: {}", txId, member);
            }
            try {
                List list = (List)ex.execute(new NestedTransactionFunction()).getResult();
                result = (Boolean)list.get(0);
            }
            catch (FunctionException fe) {
                throw new TransactionDataNodeHasDepartedException("Could not Rollback on member:" + member);
            }
        }
        if (isDebugEnabled) {
            logger.debug("RollbackFunction: for transaction: {} returning result: {}", txId, result);
        }
        context.getResultSender().lastResult(result);
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public boolean optimizeForWrite() {
        return true;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

