/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class ThreadIdentifier
implements DataSerializable {
    private static final long serialVersionUID = 3366884860834823186L;
    private byte[] membershipID;
    private long threadID;
    public static final long MAX_THREAD_PER_CLIENT = 1000000L;
    public static final int MAX_BUCKET_PER_PR = 1000;
    public static final long WAN_BITS_MASK = -4294967296L;

    public ThreadIdentifier() {
    }

    public ThreadIdentifier(byte[] mid, long threadId) {
        this.membershipID = mid;
        this.threadID = threadId;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ThreadIdentifier)) {
            return false;
        }
        return this.threadID == ((ThreadIdentifier)obj).threadID && Arrays.equals(this.membershipID, ((ThreadIdentifier)obj).membershipID);
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        if (this.membershipID != null && this.membershipID.length > 0) {
            for (int i = 0; i < this.membershipID.length; ++i) {
                result = 37 * result + this.membershipID[i];
            }
        }
        result = 37 * result + (int)this.threadID;
        result = 37 * result + (int)(this.threadID >>> 32);
        return result;
    }

    public byte[] getMembershipID() {
        return this.membershipID;
    }

    public long getThreadID() {
        return this.threadID;
    }

    public static String toDisplayString(long tid) {
        StringBuilder sb = new StringBuilder();
        long lower = Bits.THREAD_ID.extract(tid);
        if (lower != tid) {
            sb.append("0x");
            sb.append(Long.toHexString(tid >> Bits.THREAD_ID.width));
            sb.append("|");
        }
        sb.append(lower);
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThreadId[");
        sb.append(ThreadIdentifier.toDisplayString(this.threadID));
        sb.append("]");
        return sb.toString();
    }

    public String expensiveToString() {
        Object mbr;
        try {
            mbr = InternalDistributedMember.readEssentialData(new DataInputStream(new ByteArrayInputStream(this.membershipID)));
        }
        catch (Exception e) {
            mbr = this.membershipID;
        }
        return "ThreadId[" + mbr + "; thread " + ThreadIdentifier.toDisplayString(this.threadID) + "]";
    }

    public static long getRealThreadID(long tid) {
        return Bits.THREAD_ID.extract(tid) % 1000000L;
    }

    public static long getRealThreadIDIncludingWan(long tid) {
        return ThreadIdentifier.getRealThreadID(tid) | tid & 0xFFFFFFFF00000000L;
    }

    public static boolean isPutAllFakeThreadID(long tid) {
        return Bits.THREAD_ID.extract(tid) / 1000000L > 0L;
    }

    public static boolean isParallelWANThreadID(long tid) {
        return WanType.matches(tid) ? true : tid / 1000000L > 1002L;
    }

    public static boolean isWanTypeThreadID(long tid) {
        return WanType.matches(tid);
    }

    public static long createFakeThreadIDForBulkOp(int bucketNumber, long originatingThreadId) {
        return 1000000L * (long)(bucketNumber + 1) + originatingThreadId;
    }

    public static long createFakeThreadIDForParallelGSPrimaryBucket(int bucketId, long originatingThreadId, int gatewayIndex) {
        return WanType.PRIMARY.generateWanId(originatingThreadId, bucketId, gatewayIndex);
    }

    public static long createFakeThreadIDForParallelGSSecondaryBucket(int bucketId, long originatingThreadId, int gatewayIndex) {
        return WanType.SECONDARY.generateWanId(originatingThreadId, bucketId, gatewayIndex);
    }

    public static long createFakeThreadIDForParallelGateway(int index2, long originatingThreadId, int gatewayIndex) {
        return WanType.PARALLEL.generateWanId(originatingThreadId, index2, gatewayIndex);
    }

    public boolean isSameMember(ThreadIdentifier other) {
        return Arrays.equals(this.membershipID, other.membershipID);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.membershipID = DataSerializer.readByteArray(in);
        this.threadID = in.readLong();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeByteArray(this.membershipID, out);
        out.writeLong(this.threadID);
    }

    protected static final class Bits
    extends Enum<Bits> {
        public static final /* enum */ Bits THREAD_ID = new Bits(0, 32);
        public static final /* enum */ Bits WAN = new Bits(32, 16);
        public static final /* enum */ Bits WAN_TYPE = new Bits(48, 8);
        public static final /* enum */ Bits GATEWAY_ID = new Bits(56, 4);
        public static final /* enum */ Bits RESERVED = new Bits(60, 4);
        private final int position;
        private final int width;
        private static final /* synthetic */ Bits[] $VALUES;

        public static Bits[] values() {
            return (Bits[])$VALUES.clone();
        }

        public static Bits valueOf(String name) {
            return Enum.valueOf(Bits.class, name);
        }

        private Bits(int position, int width) {
            this.position = position;
            this.width = width;
        }

        public long mask() {
            return (1L << this.width) - 1L;
        }

        public long shift(long val) {
            assert (val <= this.mask());
            return val << this.position;
        }

        public long extract(long val) {
            return val >> this.position & this.mask();
        }

        static {
            $VALUES = new Bits[]{THREAD_ID, WAN, WAN_TYPE, GATEWAY_ID, RESERVED};
        }
    }

    public static final class WanType
    extends Enum<WanType> {
        public static final /* enum */ WanType RESERVED = new WanType();
        public static final /* enum */ WanType PRIMARY = new WanType();
        public static final /* enum */ WanType SECONDARY = new WanType();
        public static final /* enum */ WanType PARALLEL = new WanType();
        private static final /* synthetic */ WanType[] $VALUES;

        public static WanType[] values() {
            return (WanType[])$VALUES.clone();
        }

        public static WanType valueOf(String name) {
            return Enum.valueOf(WanType.class, name);
        }

        public long generateWanId(long threadId, long offset, int gatewayIndex) {
            assert (this != RESERVED);
            return Bits.WAN_TYPE.shift(this.ordinal()) | Bits.WAN.shift(offset) | Bits.GATEWAY_ID.shift(gatewayIndex) | threadId;
        }

        public static boolean matches(long tid) {
            return Bits.WAN_TYPE.extract(tid) > 0L;
        }

        static {
            $VALUES = new WanType[]{RESERVED, PRIMARY, SECONDARY, PARALLEL};
        }
    }
}

