/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.locks;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.locks.GFEAbstractQueuedSynchronizer;
import java.util.concurrent.TimeUnit;

public class ReentrantReadWriteWriteShareLock {
    static final int READ_MODE = 0;
    static final int WRITE_SHARED_MODE = 1;
    static final int WRITE_EXCLUSIVE_MODE = 2;
    static final int MODE_MASK = 3;
    static final int RELEASE_ALL_MASK = 8;
    private CASSync sync;
    private static int WAIT_THRESHOLD;
    private static InternalDistributedSystem DSYS;

    public ReentrantReadWriteWriteShareLock(boolean allowLockUpgrade) {
        this.sync = new CASSync(allowLockUpgrade);
    }

    public void resetOwnerId() {
        this.sync.ownerId = null;
    }

    public boolean attemptReadLock(long msecs) throws InterruptedException {
        return ReentrantReadWriteWriteShareLock.lockInSharedMode(this.sync, msecs, 0, null);
    }

    public void releaseReadLock(boolean releaseAll) {
        this.sync.releaseShared(releaseAll ? 8 : 0, null);
    }

    public boolean attemptWriteShareLock(long msecs, Object id) throws InterruptedException {
        return ReentrantReadWriteWriteShareLock.lockInSharedMode(this.sync, msecs, 1, id);
    }

    public void releaseWriteShareLock(boolean releaseAll, Object id) {
        this.sync.releaseShared(releaseAll ? 9 : 1, id);
    }

    public boolean attemptWriteExclusiveLock(long msecs, Object id) throws InterruptedException {
        if (msecs < 0L) {
            msecs = Long.MAX_VALUE;
        } else if (msecs == 0L) {
            return this.sync.tryAcquire(2, id);
        }
        long timeoutMillis = WAIT_THRESHOLD > 0 ? TimeUnit.SECONDS.toMillis(WAIT_THRESHOLD) : msecs;
        boolean res = false;
        while (msecs > timeoutMillis) {
            if (this.sync.tryAcquireNanos(2, id, TimeUnit.MILLISECONDS.toNanos(timeoutMillis))) {
                res = true;
                break;
            }
            DSYS.getCancelCriterion().checkCancelInProgress(null);
            msecs -= timeoutMillis;
        }
        if (!res) {
            res = this.sync.tryAcquireNanos(2, null, TimeUnit.MILLISECONDS.toNanos(msecs));
        }
        return res;
    }

    public void releaseWriteExclusiveLock(boolean releaseAll, Object id) {
        this.sync.release(releaseAll ? 10 : 2, id);
    }

    public static void clearStatics() {
        DSYS = null;
        WAIT_THRESHOLD = -1;
    }

    private static boolean lockInSharedMode(CASSync sync, long msecs, int sharedMode, Object id) throws InterruptedException {
        if (msecs < 0L) {
            msecs = Long.MAX_VALUE;
        } else if (msecs == 0L) {
            return sync.tryAcquireShared(sharedMode, id) >= 0;
        }
        long timeoutMillis = WAIT_THRESHOLD > 0 ? TimeUnit.SECONDS.toMillis(WAIT_THRESHOLD) : msecs;
        boolean res = false;
        while (msecs > timeoutMillis) {
            if (sync.tryAcquireSharedNanos(sharedMode, id, TimeUnit.MILLISECONDS.toNanos(timeoutMillis))) {
                res = true;
                break;
            }
            DSYS.getCancelCriterion().checkCancelInProgress(null);
            msecs -= timeoutMillis;
        }
        if (!res) {
            res = sync.tryAcquireSharedNanos(sharedMode, null, TimeUnit.MILLISECONDS.toNanos(msecs));
        }
        return res;
    }

    static {
        int timeoutSecs;
        DSYS = InternalDistributedSystem.getConnectedInstance();
        WAIT_THRESHOLD = DSYS != null ? ((timeoutSecs = DSYS.getConfig().getAckWaitThreshold()) > 0 ? timeoutSecs : -1) : -1;
    }

    static final class CASSync
    extends GFEAbstractQueuedSynchronizer {
        static final int READ_SHARED_BITS = 16;
        static final int WRITE_EXCLUSIVE_BITS = 8;
        static final int WRITE_SHARED_BITS = 8;
        static final int READ_SHARED_MASK = 65535;
        static final int MAX_READ_SHARED_COUNT = 65535;
        static final int EXCLUSIVE_ONE = 0x1000000;
        static final int WRITE_SHARE_ONE = 65536;
        static final int MAX_WRITE_SHARED_COUNT = 255;
        static final int MAX_EXCLUSIVE_COUNT = 255;
        static final int WRITE_SHARED_MASK = 0xFF0000;
        static final int WRITE_EXCLUSIVE_MASK = -16777216;
        private final boolean allowUpgradeOfWriteShare;
        private Object ownerId;

        private static int exclusiveCount(int c) {
            return (0xFF000000 & c) >>> 24;
        }

        private static int writeSharedCount(int c) {
            return (0xFF0000 & c) >> 16;
        }

        private static int readSharedCount(int c) {
            return 0xFFFF & c;
        }

        public CASSync(boolean allowUpgradeOfWriteShare) {
            this.allowUpgradeOfWriteShare = allowUpgradeOfWriteShare;
        }

        @Override
        protected boolean tryAcquire(int arg, Object id) {
            assert (arg == 2);
            while (true) {
                int currentState = this.getState();
                int currentHolds = CASSync.exclusiveCount(currentState);
                int currentWriteSharedHolds = CASSync.writeSharedCount(currentState);
                int currentReadHolds = CASSync.readSharedCount(currentState);
                if (currentReadHolds > 0) {
                    return false;
                }
                if (currentWriteSharedHolds > 0) {
                    if (!id.equals(this.ownerId)) {
                        return false;
                    }
                    if (this.allowUpgradeOfWriteShare) {
                        if (currentHolds > 0 && currentHolds == 255) {
                            throw new InternalGemFireError("Maximum write lock count exceeded!");
                        }
                        int newState = currentState + 0x1000000 - 65536;
                        if (!this.compareAndSetState(currentState, newState)) continue;
                        break;
                    }
                    return false;
                }
                if (currentHolds > 0) {
                    if (currentHolds == 255) {
                        throw new InternalGemFireError("Maximum write lock count exceeded!");
                    }
                    if (!id.equals(this.ownerId)) {
                        return false;
                    }
                }
                if (this.compareAndSetState(currentState, currentState + 0x1000000)) break;
            }
            this.ownerId = id;
            return true;
        }

        @Override
        protected boolean tryRelease(int arg, Object id) {
            int newState;
            int currentState;
            boolean releaseAll;
            assert ((arg & 3) == 2);
            assert (id != null);
            if (!id.equals(this.ownerId)) {
                throw new InternalGemFireError("an attempt to release lock by a non owner");
            }
            boolean bl = releaseAll = (arg & 8) == 8;
            do {
                int writeExclusiveCount;
                if ((writeExclusiveCount = CASSync.exclusiveCount(currentState = this.getState())) != 0) continue;
                throw new IllegalMonitorStateException();
            } while (!this.compareAndSetState(currentState, newState = releaseAll ? currentState & 0xFFFFFF : currentState - 0x1000000));
            return true;
        }

        @Override
        protected int tryAcquireShared(int arg, Object id) {
            int currentWriteSharedHolds;
            assert (arg == 0 || arg == 1);
            while (true) {
                int currentState = this.getState();
                int currentHolds = CASSync.exclusiveCount(currentState);
                currentWriteSharedHolds = CASSync.writeSharedCount(currentState);
                int currentReadHolds = CASSync.readSharedCount(currentState);
                if (currentHolds > 0) {
                    return -1;
                }
                if (arg == 0) {
                    if (currentReadHolds == 65535) {
                        throw new InternalGemFireError("Maximum read lock count exceeded!");
                    }
                    if (!this.compareAndSetState(currentState, currentState + 1)) continue;
                    if (currentReadHolds + 1 == 65535) {
                        return 0;
                    }
                    return 1;
                }
                if (currentWriteSharedHolds > 0) {
                    if (!id.equals(this.ownerId)) {
                        return -1;
                    }
                    if (currentWriteSharedHolds == 255) {
                        throw new InternalGemFireError("Maximum write share lock count exceeded!");
                    }
                }
                if (this.compareAndSetState(currentState, currentState + 65536)) break;
            }
            if (currentWriteSharedHolds + 1 == 255) {
                this.ownerId = id;
                return 0;
            }
            this.ownerId = id;
            return 1;
        }

        @Override
        protected boolean tryReleaseShared(int arg, Object id) {
            assert ((arg & 3) == 1 || (arg & 3) == 0);
            boolean releaseAll = (arg & 8) == 8;
            while (true) {
                int newState;
                int currentState = this.getState();
                if ((arg & 3) == 1) {
                    assert (id != null);
                    if (!id.equals(this.ownerId)) {
                        throw new InternalGemFireError("an attempt to release lock by a non owner");
                    }
                    int writeSharedCount = CASSync.writeSharedCount(currentState);
                    if (writeSharedCount == 0) {
                        throw new IllegalMonitorStateException();
                    }
                    newState = releaseAll ? currentState & 0xFF00FFFF : currentState - 65536;
                    if (!this.compareAndSetState(currentState, newState)) continue;
                    return true;
                }
                int readCount = CASSync.readSharedCount(currentState);
                if (readCount == 0) {
                    throw new IllegalMonitorStateException();
                }
                newState = releaseAll ? currentState & 0xFFFF0000 : currentState - 1;
                if (this.compareAndSetState(currentState, newState)) break;
            }
            return true;
        }

        @Override
        protected boolean isHeldExclusively() {
            throw new UnsupportedOperationException();
        }
    }
}

