/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.lru;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.internal.OverflowQueueWithDMStats;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEvictorTask;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.MemoryEvent;
import com.gemstone.gemfire.internal.cache.control.MemoryEventType;
import com.gemstone.gemfire.internal.cache.control.ResourceListener;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gnu.trove.TObjectLongHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;

public class HeapEvictor
implements ResourceListener<MemoryEvent> {
    private static final Logger logger = LogService.getLogger();
    public static final int MAX_EVICTOR_THREADS = Integer.getInteger("gemfire.HeapLRUCapacityController.MAX_EVICTOR_THREADS", Runtime.getRuntime().availableProcessors() * 4);
    public static final boolean DISABLE_HEAP_EVICTIOR_THREAD_POOL = Boolean.getBoolean("gemfire.HeapLRUCapacityController.DISABLE_HEAP_EVICTIOR_THREAD_POOL");
    public static final boolean EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST = Boolean.valueOf(System.getProperty("gemfire.HeapLRUCapacityController.evictHighEntryCountBucketsFirst", "true"));
    public static final int MINIMUM_ENTRIES_PER_BUCKET = Integer.getInteger("gemfire.HeapLRUCapacityController.inlineEvictionThreshold", 0);
    public static final long TOTAL_BYTES_TO_EVICT_FROM_HEAP;
    public static final int BUCKET_SORTING_INTERVAL;
    private ThreadPoolExecutor evictorThreadPool = null;
    private AtomicBoolean mustEvict = new AtomicBoolean(false);
    private final Cache cache;
    private ArrayList testTaskSetSizes = new ArrayList();
    private BlockingQueue<Runnable> poolQueue;
    private AtomicBoolean isRunning = new AtomicBoolean(true);

    public HeapEvictor(Cache gemFireCache) {
        this.cache = gemFireCache;
        this.initializeEvictorThreadPool();
    }

    private List<LocalRegion> getAllRegionList() {
        ArrayList<LocalRegion> allRegionList = new ArrayList<LocalRegion>();
        InternalResourceManager irm = (InternalResourceManager)this.cache.getResourceManager();
        for (ResourceListener<MemoryEvent> listener : irm.getMemoryEventListeners()) {
            LocalRegion lr;
            if (listener instanceof PartitionedRegion) {
                PartitionedRegion pr2 = (PartitionedRegion)listener;
                if (!pr2.getEvictionAttributes().getAlgorithm().isLRUHeap() || pr2.getDataStore() == null) continue;
                allRegionList.addAll(pr2.getDataStore().getAllLocalBucketRegions());
                continue;
            }
            if (!(listener instanceof LocalRegion) || !(lr = (LocalRegion)listener).getEvictionAttributes().getAlgorithm().isLRUHeap()) continue;
            allRegionList.add(lr);
        }
        if (MINIMUM_ENTRIES_PER_BUCKET > 0) {
            Iterator iter = allRegionList.iterator();
            while (iter.hasNext()) {
                LocalRegion lr = (LocalRegion)iter.next();
                if (!(lr instanceof BucketRegion) || ((BucketRegion)lr).getNumEntriesInVM() > (long)MINIMUM_ENTRIES_PER_BUCKET) continue;
                iter.remove();
            }
        }
        return allRegionList;
    }

    private List<LocalRegion> getAllSortedRegionList() {
        List<LocalRegion> allRegionList = this.getAllRegionList();
        final TObjectLongHashMap sizes = new TObjectLongHashMap(allRegionList.size());
        for (LocalRegion r : allRegionList) {
            long size2 = r instanceof BucketRegion ? (long)((BucketRegion)r).getSizeForEviction() : (long)r.size();
            sizes.put(r, size2);
        }
        Collections.sort(allRegionList, new Comparator<LocalRegion>(){

            @Override
            public int compare(LocalRegion r1, LocalRegion r2) {
                long numEntries2;
                long numEntries1 = sizes.get(r1);
                if (numEntries1 > (numEntries2 = sizes.get(r2))) {
                    return -1;
                }
                if (numEntries1 < numEntries2) {
                    return 1;
                }
                return 0;
            }
        });
        return allRegionList;
    }

    public GemFireCacheImpl getGemFireCache() {
        return (GemFireCacheImpl)this.cache;
    }

    private void initializeEvictorThreadPool() {
        final LoggingThreadGroup evictorThreadGroup = LoggingThreadGroup.createThreadGroup("EvictorThreadGroup", logger);
        ThreadFactory evictorThreadFactory = new ThreadFactory(){
            private int next = 0;

            @Override
            public Thread newThread(Runnable command) {
                Thread t = new Thread(evictorThreadGroup, command, "EvictorThread " + this.next++);
                t.setDaemon(true);
                return t;
            }
        };
        if (!DISABLE_HEAP_EVICTIOR_THREAD_POOL) {
            this.poolQueue = new OverflowQueueWithDMStats(this.getGemFireCache().getCachePerfStats().getEvictionQueueStatHelper());
            this.evictorThreadPool = new ThreadPoolExecutor(MAX_EVICTOR_THREADS, MAX_EVICTOR_THREADS, 15L, TimeUnit.SECONDS, this.poolQueue, evictorThreadFactory);
        }
    }

    private void submitRegionEvictionTask(Callable<Object> task) {
        this.evictorThreadPool.submit(task);
    }

    public ThreadPoolExecutor getEvictorThreadPool() {
        if (this.isRunning.get()) {
            return this.evictorThreadPool;
        }
        return null;
    }

    public int getRunningAndScheduledTasks() {
        if (this.isRunning.get()) {
            return this.evictorThreadPool.getActiveCount() + this.evictorThreadPool.getQueue().size();
        }
        return -1;
    }

    private void createAndSubmitWeightedRegionEvictionTasks() {
        List<LocalRegion> allRegionList = this.getAllSortedRegionList();
        float numEntriesInVm = 0.0f;
        for (LocalRegion lr : allRegionList) {
            if (lr instanceof BucketRegion) {
                numEntriesInVm += (float)((BucketRegion)lr).getSizeForEviction();
                continue;
            }
            numEntriesInVm += (float)lr.getRegionMap().sizeInVM();
        }
        for (LocalRegion lr : allRegionList) {
            ArrayList<LocalRegion> regionsForSingleTask = new ArrayList<LocalRegion>(1);
            float regionEntryCnt = 0.0f;
            regionEntryCnt = lr instanceof BucketRegion ? (float)((BucketRegion)lr).getSizeForEviction() : (float)lr.getRegionMap().sizeInVM();
            float percentage = regionEntryCnt / numEntriesInVm;
            long bytesToEvictPerTask = (long)((float)TOTAL_BYTES_TO_EVICT_FROM_HEAP * percentage);
            regionsForSingleTask.add(lr);
            if (!this.mustEvict()) break;
            this.submitRegionEvictionTask(new RegionEvictorTask(regionsForSingleTask, this, bytesToEvictPerTask));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Set<Callable<Object>> createRegionEvictionTasks() {
        HashSet<Callable<Object>> evictorTaskSet = new HashSet<Callable<Object>>();
        int threadsAvailable = this.getEvictorThreadPool().getCorePoolSize();
        long bytesToEvictPerTask = TOTAL_BYTES_TO_EVICT_FROM_HEAP / (long)threadsAvailable;
        List<LocalRegion> allRegionList = this.getAllRegionList();
        Collections.shuffle(allRegionList);
        int allRegionSetSize = allRegionList.size();
        if (allRegionList.isEmpty()) {
            return evictorTaskSet;
        }
        if (allRegionSetSize <= threadsAvailable) {
            for (LocalRegion localRegion : allRegionList) {
                ArrayList<LocalRegion> regionList = new ArrayList<LocalRegion>(1);
                regionList.add(localRegion);
                RegionEvictorTask task = new RegionEvictorTask(regionList, this, bytesToEvictPerTask);
                evictorTaskSet.add(task);
            }
            for (RegionEvictorTask regionEvictorTask : evictorTaskSet) {
                this.testTaskSetSizes.add(regionEvictorTask.getRegionList().size());
            }
            return evictorTaskSet;
        }
        int numRegionsInTask = allRegionSetSize / threadsAvailable;
        Object var8_11 = null;
        Iterator<LocalRegion> itr = allRegionList.iterator();
        for (int i = 0; i < threadsAvailable; ++i) {
            ArrayList<LocalRegion> arrayList = new ArrayList<LocalRegion>(numRegionsInTask);
            for (int j = 1; j <= numRegionsInTask; ++j) {
                if (!itr.hasNext()) continue;
                arrayList.add(itr.next());
            }
            evictorTaskSet.add(new RegionEvictorTask(arrayList, this, bytesToEvictPerTask));
        }
        while (itr.hasNext()) {
            void var8_12;
            var8_12.add(itr.next());
        }
        for (RegionEvictorTask regionEvictorTask : evictorTaskSet) {
            this.testTaskSetSizes.add(regionEvictorTask.getRegionList().size());
        }
        return evictorTaskSet;
    }

    @Override
    public void onEvent(MemoryEvent event) {
        if (this.isRunning.get() && event.isLocal()) {
            if (((MemoryEventType)((Object)event.getType())).isEvictionUp() || ((MemoryEventType)((Object)event.getType())).isEvictMore()) {
                this.mustEvict.set(true);
                if (!DISABLE_HEAP_EVICTIOR_THREAD_POOL) {
                    while (true) {
                        try {
                            if (EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST) {
                                this.createAndSubmitWeightedRegionEvictionTasks();
                            } else {
                                for (Callable<Object> task : this.createRegionEvictionTasks()) {
                                    this.submitRegionEvictionTask(task);
                                }
                            }
                            RegionEvictorTask.setLastTaskCompletionTime(System.currentTimeMillis());
                        }
                        catch (RegionDestroyedException regionDestroyedException) {
                            continue;
                        }
                        break;
                    }
                }
            } else if (((MemoryEventType)((Object)event.getType())).isEvictionDown() || ((MemoryEventType)((Object)event.getType())).isEvictionDisabled()) {
                this.mustEvict.set(false);
            }
        }
    }

    public boolean mustEvict() {
        return this.mustEvict.get();
    }

    public void close() {
        this.getEvictorThreadPool().shutdownNow();
        this.isRunning.set(false);
    }

    public ArrayList testOnlyGetSizeOfTasks() {
        if (this.isRunning.get()) {
            return this.testTaskSetSizes;
        }
        return null;
    }

    static {
        BUCKET_SORTING_INTERVAL = Integer.getInteger("gemfire.HeapLRUCapacityController.higherEntryCountBucketCalculationInterval", 100);
        float evictionBurstPercentage = Float.parseFloat(System.getProperty("gemfire.HeapLRUCapacityController.evictionBurstPercentage", "0.4"));
        long maxTenuredBytes = InternalResourceManager.getTenuredPoolMaxMemory();
        TOTAL_BYTES_TO_EVICT_FROM_HEAP = (long)((double)maxTenuredBytes * 0.01 * (double)evictionBurstPercentage);
    }
}

