/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.lru;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import java.util.concurrent.atomic.AtomicLong;

public class LRUStatistics {
    private final Statistics stats;
    protected int limitId;
    protected int destroysLimitId;
    protected int counterId;
    protected int evictionsId;
    protected int destroysId;
    protected int evaluationsId;
    protected int greedyReturnsId;
    private final AtomicLong counter = new AtomicLong();
    private final AtomicLong limit = new AtomicLong();
    private final AtomicLong destroysLimit = new AtomicLong();
    private final AtomicLong destroys = new AtomicLong();
    private final AtomicLong evictions = new AtomicLong();

    public LRUStatistics(StatisticsFactory factory, String name, EnableLRU helper) {
        String statName = helper.getStatisticsName() + "-" + name;
        this.stats = factory.createAtomicStatistics(helper.getStatisticsType(), statName);
        if (!helper.getEvictionAlgorithm().isLRUHeap()) {
            this.limitId = helper.getLimitStatId();
        }
        this.destroysLimitId = helper.getDestroysLimitStatId();
        this.counterId = helper.getCountStatId();
        this.evictionsId = helper.getEvictionsStatId();
        this.destroysId = helper.getDestroysStatId();
        this.evaluationsId = helper.getEvaluationsStatId();
        this.greedyReturnsId = helper.getGreedyReturnsStatId();
    }

    public LRUStatistics(StatisticsFactory factory, String name, StatisticsType statisticsType) {
        this.stats = factory.createAtomicStatistics(statisticsType, name);
        this.limitId = 0;
        this.destroysLimitId = 0;
        this.counterId = 0;
        this.evictionsId = 0;
        this.destroysId = 0;
        this.evaluationsId = 0;
        this.greedyReturnsId = 0;
    }

    public void close() {
        this.stats.close();
    }

    public long getCounter() {
        return this.counter.get();
    }

    public void setLimit(long newValue) {
        Assert.assertTrue(newValue > 0L, "limit must be positive, an attempt was made to set it to: " + newValue);
        long oldValue = this.limit.get();
        if (oldValue != newValue) {
            this.limit.set(newValue);
            this.stats.setLong(this.limitId, newValue);
        }
    }

    public void setDestroysLimit(long newValue) {
        Assert.assertTrue(newValue > 0L, "destroys limit must be positive, an attempt was made to set it to: " + newValue);
        long oldValue = this.destroysLimit.get();
        if (oldValue != newValue) {
            this.destroysLimit.set(newValue);
            this.stats.setLong(this.destroysLimitId, newValue);
        }
    }

    public long getLimit() {
        return this.limit.get();
    }

    public long getDestroysLimit() {
        return this.destroysLimit.get();
    }

    public void updateCounter(long delta) {
        if (delta != 0L) {
            this.counter.getAndAdd(delta);
            this.stats.incLong(this.counterId, delta);
        }
    }

    public void resetCounter() {
        if (this.counter.get() != 0L) {
            this.counter.set(0L);
            this.stats.setLong(this.counterId, 0L);
        }
    }

    public void decrementCounter(long delta) {
        if (delta != 0L) {
            this.counter.addAndGet(-delta);
            this.stats.setLong(this.counterId, this.counter.get());
        }
    }

    public void incEvictions() {
        this.evictions.getAndAdd(1L);
        this.stats.incLong(this.evictionsId, 1L);
    }

    public void incEvictions(long delta) {
        this.evictions.getAndAdd(delta);
        this.stats.incLong(this.evictionsId, delta);
    }

    public long getEvictions() {
        return this.evictions.get();
    }

    public void resetDestroys() {
        if (this.destroys.get() != 0L) {
            this.destroys.set(0L);
            this.stats.setLong(this.destroysId, 0L);
        }
    }

    public void incDestroys() {
        this.destroys.getAndAdd(1L);
        this.stats.incLong(this.destroysId, 1L);
    }

    public long getDestroys() {
        return this.destroys.get();
    }

    public void incEvaluations(long numEvals) {
        this.stats.incLong(this.evaluationsId, numEvals);
    }

    public void incGreedyReturns(long numEvals) {
        this.stats.incLong(this.greedyReturnsId, numEvals);
    }

    public Statistics getStats() {
        return this.stats;
    }
}

