/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.lru;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import com.gemstone.gemfire.internal.cache.AbstractLRURegionMap;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.lru.LRUAlgorithm;
import com.gemstone.gemfire.internal.cache.lru.LRUStatistics;
import com.gemstone.gemfire.internal.cache.lru.Sizeable;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Properties;

public final class MemLRUCapacityController
extends LRUAlgorithm
implements Declarable {
    private static final long serialVersionUID = 6364183985590572514L;
    private static final int OVERHEAD_PER_ENTRY = 250;
    public static final int DEFAULT_MAXIMUM_MEGABYTES = 10;
    public static final String MAXIMUM_MEGABYTES = "maximum-megabytes";
    public static final String SIZER_IMPL = "sizer";
    private static final long ONE_MEG = 0x100000L;
    protected static final StatisticsType statType;
    private long limit = 0xA00000L;
    private ObjectSizer sizer;
    private int perEntryOverHead = 250;

    public MemLRUCapacityController(Region region) {
        this(10, region);
    }

    public MemLRUCapacityController(int megabytes, Region region) {
        this(megabytes, null, region);
    }

    public MemLRUCapacityController(int megabytes, ObjectSizer sizerImpl, Region region) {
        this(megabytes, sizerImpl, EvictionAction.DEFAULT_EVICTION_ACTION, region);
    }

    public MemLRUCapacityController(int megabytes, ObjectSizer sizerImpl, EvictionAction evictionAction, Region region) {
        super(evictionAction, region);
        this.setMaximumMegabytes(megabytes);
        this.setSizer(sizerImpl);
    }

    @Override
    public void init(Properties props) {
        String prop = null;
        String sizerStr = null;
        sizerStr = props.getProperty(SIZER_IMPL);
        if (sizerStr != null) {
            try {
                Class<?> c = ClassPathLoader.getLatest().forName(sizerStr);
                this.setSizer((ObjectSizer)c.newInstance());
            }
            catch (Exception e) {
                IllegalArgumentException ex = new IllegalArgumentException(LocalizedStrings.MemLRUCapacityController_COULD_NOT_CREATE_SIZER_INSTANCE_GIVEN_THE_CLASS_NAME_0.toLocalizedString(this.sizer));
                ex.initCause(e);
                throw ex;
            }
        }
        if ((prop = props.getProperty(MAXIMUM_MEGABYTES)) != null) {
            this.limit = (long)Integer.parseInt(prop) * 0x100000L;
        }
        if ((prop = props.getProperty("eviction-action")) != null) {
            this.setEvictionAction(EvictionAction.parseAction(prop));
        }
    }

    @Override
    public Properties getProperties() {
        long megLimit;
        Properties props = new Properties();
        if (this.evictionAction != EvictionAction.DEFAULT_EVICTION_ACTION) {
            props.setProperty("eviction-action", this.evictionAction.toString());
        }
        if ((megLimit = this.limit / 0x100000L) != 10L) {
            props.setProperty(MAXIMUM_MEGABYTES, String.valueOf(megLimit));
        }
        if (this.sizer != null) {
            props.setProperty(SIZER_IMPL, this.sizer.getClass().getName());
        }
        return props;
    }

    public void setMaximumMegabytes(int megabytes) {
        if (megabytes <= 0) {
            throw new IllegalArgumentException(LocalizedStrings.MemLRUCapacityController_MEMLRUCONTROLLER_LIMIT_MUST_BE_POSTIVE_0.toLocalizedString(megabytes));
        }
        this.limit = (long)megabytes * 0x100000L;
        if (this.bucketRegion != null) {
            this.bucketRegion.setLimit(this.limit);
        } else if (this.stats != null) {
            this.stats.setLimit(this.limit);
        }
    }

    @Override
    public void setLimit(int maximum) {
        this.setMaximumMegabytes(maximum);
    }

    public void setEntryOverHead(int entryOverHead) {
        this.perEntryOverHead = entryOverHead;
    }

    private void setSizer(ObjectSizer sizer) {
        this.sizer = sizer;
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    protected EnableLRU createLRUHelper() {
        return new LRUAlgorithm.AbstractEnableLRU(){

            @Override
            public EvictionAlgorithm getEvictionAlgorithm() {
                return EvictionAlgorithm.LRU_MEMORY;
            }

            @Override
            public int entrySize(Object key2, Object value2) throws IllegalArgumentException {
                if (value2 == Token.TOMBSTONE) {
                    return 0;
                }
                int size2 = MemLRUCapacityController.this.getPerEntryOverhead();
                int keySize = MemLRUCapacityController.this.sizeof(key2);
                int valueSize = MemLRUCapacityController.this.sizeof(value2);
                size2 += keySize;
                return size2 += valueSize;
            }

            @Override
            public StatisticsType getStatisticsType() {
                return statType;
            }

            @Override
            public String getStatisticsName() {
                return "MemLRUStatistics";
            }

            @Override
            public int getLimitStatId() {
                return statType.nameToId("bytesAllowed");
            }

            @Override
            public int getCountStatId() {
                return statType.nameToId("byteCount");
            }

            @Override
            public int getEvictionsStatId() {
                return statType.nameToId("lruEvictions");
            }

            @Override
            public int getDestroysStatId() {
                return statType.nameToId("lruDestroys");
            }

            @Override
            public int getDestroysLimitStatId() {
                return statType.nameToId("lruDestroysLimit");
            }

            @Override
            public int getEvaluationsStatId() {
                return statType.nameToId("lruEvaluations");
            }

            @Override
            public int getGreedyReturnsStatId() {
                return statType.nameToId("lruGreedyReturns");
            }

            @Override
            public boolean mustEvict(LRUStatistics stats, Region region, int delta) {
                return stats.getCounter() + (long)delta > stats.getLimit();
            }
        };
    }

    static int basicSizeof(Object o, ObjectSizer sizer) throws IllegalArgumentException {
        boolean cdChangingForm = o instanceof AbstractLRURegionMap.CDValueWrapper;
        if (cdChangingForm) {
            o = ((AbstractLRURegionMap.CDValueWrapper)o).getValue();
        }
        if (o == null || o == Token.INVALID || o == Token.LOCAL_INVALID || o == Token.DESTROYED || o == Token.TOMBSTONE) {
            return 0;
        }
        int size2 = o instanceof byte[] || o instanceof String ? ObjectSizer.DEFAULT.sizeof(o) : (o instanceof Sizeable ? ((Sizeable)o).getSizeInBytes() : (sizer != null ? sizer.sizeof(o) : ObjectSizer.DEFAULT.sizeof(o)));
        if (cdChangingForm) {
            size2 += CachedDeserializableFactory.overhead();
        }
        return size2;
    }

    protected int sizeof(Object o) throws IllegalArgumentException {
        return MemLRUCapacityController.basicSizeof(o, this.sizer);
    }

    public int getPerEntryOverhead() {
        return this.perEntryOverHead;
    }

    @Override
    public boolean equals(Object cc) {
        if (!super.equals(cc)) {
            return false;
        }
        MemLRUCapacityController other = (MemLRUCapacityController)cc;
        return this.limit == other.limit;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = (int)((long)result + this.limit);
        return result;
    }

    @Override
    public String toString() {
        return "MemLRUCapacityController with a capacity of " + this.getLimit() + " megabytes and and eviction action " + this.getEvictionAction();
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        String bytesAllowedDesc = "Number of total bytes allowed in this region.";
        String byteCountDesc = "Number of bytes in region.";
        String lruEvictionsDesc = "Number of total entry evictions triggered by LRU.";
        String lruDestroysDesc = "Number of entries destroyed in the region through both destroy cache operations and eviction. Reset to zero each time it exceeds lruDestroysLimit.";
        String lruDestroysLimitDesc = "Maximum number of entry destroys triggered by LRU before scan occurs.";
        String lruEvaluationsDesc = "Number of entries evaluated during LRU operations.";
        String lruGreedyReturnsDesc = "Number of non-LRU entries evicted during LRU operations";
        statType = f.createType("MemLRUStatistics", "Statistics about byte based Least Recently Used region entry disposal", new StatisticDescriptor[]{f.createLongGauge("bytesAllowed", "Number of total bytes allowed in this region.", "bytes"), f.createLongGauge("byteCount", "Number of bytes in region.", "bytes"), f.createLongCounter("lruEvictions", "Number of total entry evictions triggered by LRU.", "entries"), f.createLongCounter("lruDestroys", "Number of entries destroyed in the region through both destroy cache operations and eviction. Reset to zero each time it exceeds lruDestroysLimit.", "entries"), f.createLongGauge("lruDestroysLimit", "Maximum number of entry destroys triggered by LRU before scan occurs.", "entries"), f.createLongCounter("lruEvaluations", "Number of entries evaluated during LRU operations.", "entries"), f.createLongCounter("lruGreedyReturns", "Number of non-LRU entries evicted during LRU operations", "entries")});
    }
}

