/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class BucketProfileUpdateMessage
extends DistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    private int prId;
    private int bucketId;
    private int processorId = 0;
    private BucketAdvisor.BucketProfile profile;

    public BucketProfileUpdateMessage() {
    }

    @Override
    public final int getProcessorType() {
        return 77;
    }

    private BucketProfileUpdateMessage(Set recipients, int partitionedRegionId, int processorId, int bucketId, BucketAdvisor.BucketProfile profile) {
        this.setRecipients(recipients);
        this.processorId = processorId;
        this.prId = partitionedRegionId;
        this.bucketId = bucketId;
        this.profile = profile;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public boolean sendViaJGroups() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        try {
            PartitionedRegion pr2 = PartitionedRegion.getPRFromId(this.prId);
            pr2.getRegionAdvisor().putBucketProfile(this.bucketId, this.profile);
        }
        catch (PRLocallyDestroyedException fre) {
            if (logger.isDebugEnabled()) {
                logger.debug("<region locally destroyed> ///{}", this);
            }
        }
        catch (RegionDestroyedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("<region destroyed> ///{}", this);
            }
        }
        catch (CancelException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("<cache closed> ///{}", this);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ignore) {
            SystemFailure.checkFailure();
        }
        finally {
            if (this.processorId != 0) {
                ReplyMessage.send(this.getSender(), this.processorId, null, (ReplySender)dm);
            }
        }
    }

    public static ReplyProcessor21 send(Set recipients, DM dm, int prId, int bucketId, BucketAdvisor.BucketProfile bp, boolean requireAck) {
        if (recipients.isEmpty()) {
            return null;
        }
        ReplyProcessor21 rp = null;
        int procId = 0;
        if (requireAck) {
            rp = new ReplyProcessor21(dm, (Collection)recipients);
            procId = rp.getProcessorId();
        }
        BucketProfileUpdateMessage m = new BucketProfileUpdateMessage(recipients, prId, procId, bucketId, bp);
        dm.putOutgoing(m);
        return rp;
    }

    @Override
    public int getDSFID() {
        return 41;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.prId = in.readInt();
        this.bucketId = in.readInt();
        this.processorId = in.readInt();
        this.profile = (BucketAdvisor.BucketProfile)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.prId);
        out.writeInt(this.bucketId);
        out.writeInt(this.processorId);
        DataSerializer.writeObject(this.profile, out);
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        String className = this.getClass().getName();
        String shortName = className.substring(className.lastIndexOf(46, className.lastIndexOf(46) - 1) + 1);
        return buff.append(shortName).append("(prid=").append(this.prId).append("; bucketid=").append(this.bucketId).append("; sender=").append(this.getSender()).append("]; processorId=").append(this.processorId).append("; profile=").append(this.profile).append(")").toString();
    }
}

