/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.PRHARedundancyProvider;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionStats;
import com.gemstone.gemfire.internal.cache.partitioned.RecoveryRunnable;

public final class CreateMissingBucketsTask
extends RecoveryRunnable {
    public CreateMissingBucketsTask(PRHARedundancyProvider prhaRedundancyProvider) {
        super(prhaRedundancyProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run2() {
        PartitionedRegion leaderRegion = ColocationHelper.getLeaderRegion(this.redundancyProvider.prRegion);
        PartitionedRegion.RecoveryLock lock = leaderRegion.getRecoveryLock();
        lock.lock();
        try {
            this.createMissingBuckets(this.redundancyProvider.prRegion);
        }
        finally {
            lock.unlock();
        }
    }

    protected void createMissingBuckets(PartitionedRegion region) {
        PartitionedRegion parentRegion = ColocationHelper.getColocatedRegion(region);
        if (parentRegion == null) {
            return;
        }
        this.createMissingBuckets(parentRegion);
        for (int i = 0; i < region.getTotalNumberOfBuckets(); ++i) {
            if (parentRegion.getRegionAdvisor().getBucketAdvisor(i).getBucketRedundancy() == region.getRegionAdvisor().getBucketAdvisor(i).getBucketRedundancy()) continue;
            long startTime = PartitionedRegionStats.startTime();
            region.getRedundancyProvider().createBucketAtomically(i, 0, startTime, true, null);
        }
    }
}

