/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.DataLocationException;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessageWithDirectReply;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.versions.DiskVersionTag;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class DestroyMessage
extends PartitionMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private Object cbArg;
    private Operation op;
    ClientProxyMembershipID bridgeContext;
    EventID eventId;
    InternalDistributedMember originalSender;
    private Object expectedOldValue;
    protected FilterRoutingInfo filterInfo;
    protected VersionTag versionTag;
    private static final byte HAS_VERSION_TAG = 1;
    private static final byte PERSISTENT_TAG = 2;
    protected static final short CACHE_WRITE = 4096;

    public DestroyMessage() {
    }

    protected DestroyMessage(Set recipients, boolean notifyOnly, int regionId, DirectReplyProcessor processor, EntryEventImpl event, Object expectedOldValue) {
        super(recipients, regionId, processor, event);
        this.expectedOldValue = expectedOldValue;
        this.key = event.getKey();
        this.cbArg = event.getRawCallbackArgument();
        this.op = event.getOperation();
        this.notificationOnly = notifyOnly;
        this.bridgeContext = event.getContext();
        this.eventId = event.getEventId();
        this.versionTag = event.getVersionTag();
    }

    DestroyMessage(DestroyMessage original, EntryEventImpl event, Set members) {
        this(original);
        if (event != null) {
            this.posDup = event.isPossibleDuplicate();
            this.versionTag = event.getVersionTag();
        }
    }

    DestroyMessage(DestroyMessage original) {
        this.expectedOldValue = original.expectedOldValue;
        this.regionId = original.regionId;
        this.processorId = original.processorId;
        this.key = original.key;
        this.cbArg = original.cbArg;
        this.op = original.op;
        this.notificationOnly = true;
        this.bridgeContext = original.bridgeContext;
        this.originalSender = original.getSender();
        this.eventId = original.eventId;
        this.posDup = original.posDup;
        this.versionTag = original.versionTag;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    public static Set notifyListeners(Set cacheOpReceivers, Set adjunctRecipients, FilterRoutingInfo filterRoutingInfo, PartitionedRegion r, EntryEventImpl event, DirectReplyProcessor processor) {
        DestroyMessage msg = new DestroyMessage(Collections.EMPTY_SET, true, r.getPRId(), processor, event, null);
        msg.versionTag = event.getVersionTag();
        return msg.relayToListeners(cacheOpReceivers, adjunctRecipients, filterRoutingInfo, event, r, processor);
    }

    public static DestroyResponse send(DistributedMember recipient, PartitionedRegion r, EntryEventImpl event, Object expectedOldValue) throws ForceReattemptException {
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        DestroyResponse p = new DestroyResponse(r.getSystem(), recipients, (Object)false);
        p.requireResponse();
        DestroyMessage m = new DestroyMessage(recipients, false, r.getPRId(), p, event, expectedOldValue);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.DestroyMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    @Override
    public PartitionMessage getMessageForRelayToListeners(EntryEventImpl event, Set members) {
        DestroyMessage msg = new DestroyMessage(this, event, members);
        msg.expectedOldValue = null;
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) throws EntryExistsException, DataLocationException {
        InternalDistributedMember eventSender = this.originalSender;
        if (eventSender == null) {
            eventSender = this.getSender();
        }
        EntryEventImpl event = null;
        if (r.keyRequiresRegionContext()) {
            ((KeyWithRegionContext)this.key).setRegionContext(r);
        }
        if (this.bridgeContext != null) {
            event = new EntryEventImpl(r, this.getOperation(), this.key, null, this.getCallbackArg(), false, eventSender, true);
            event.setContext(this.bridgeContext);
        } else {
            event = new EntryEventImpl((LocalRegion)r, this.getOperation(), this.key, null, this.getCallbackArg(), false, (DistributedMember)eventSender, true, false);
        }
        if (this.versionTag != null) {
            this.versionTag.replaceNullIDs(this.getSender());
            event.setVersionTag(this.versionTag);
        }
        event.setInvokePRCallbacks(!this.notificationOnly);
        Assert.assertTrue(this.eventId != null);
        event.setEventId(this.eventId);
        event.setPossibleDuplicate(this.posDup);
        PartitionedRegionDataStore ds = r.getDataStore();
        boolean sendReply = true;
        if (!this.notificationOnly) {
            Assert.assertTrue(ds != null, "This process should have storage for an item in " + this.toString());
            try {
                Integer bucket = PartitionedRegionHelper.getHashKey(r, null, this.key, null, this.cbArg);
                event.setCausedByMessage(this);
                r.getDataView().destroyOnRemote(event, true, this.expectedOldValue);
                if (!logger.isTraceEnabled(LogMarker.DM)) return sendReply;
                logger.trace(LogMarker.DM, "{} updated bucket: {} with key: {}", this.getClass().getName(), bucket, this.key);
                return sendReply;
            }
            catch (CacheWriterException cwe) {
                this.sendReply(this.getSender(), this.processorId, dm, new ReplyException(cwe), r, startTime);
                boolean bl = false;
                return bl;
            }
            catch (EntryNotFoundException eee) {
                logger.trace(LogMarker.DM, "{}: operateOnRegion caught EntryNotFoundException", this.getClass().getName());
                ReplyMessage.send(this.getSender(), this.getProcessorId(), new ReplyException(eee), this.getReplySender(dm), r.isInternalRegion());
                sendReply = false;
                return sendReply;
            }
            catch (PrimaryBucketException pbe) {
                this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(pbe), r, startTime);
                sendReply = false;
                return sendReply;
            }
            finally {
                this.versionTag = event.getVersionTag();
            }
        } else {
            EntryEventImpl e2 = this.createListenerEvent(event, r, dm.getDistributionManagerId());
            r.invokeDestroyCallbacks(EnumListenerEvent.AFTER_DESTROY, e2, r.isInitialized(), true);
        }
        return sendReply;
    }

    @Override
    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, PartitionedRegion pr2, long startTime) {
        if (pr2 != null && startTime > 0L) {
            pr2.getPrStats().endPartitionMessagesProcessing(startTime);
        }
        if (ex == null) {
            DestroyReplyMessage.send(this.getSender(), this.getReplySender(dm), this.processorId, this.versionTag, pr2 != null && pr2.isInternalRegion());
        } else {
            ReplyMessage.send(this.getSender(), this.processorId, ex, this.getReplySender(dm), pr2 != null && pr2.isInternalRegion());
        }
    }

    @Override
    public int getDSFID() {
        return 73;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        boolean hasFilterInfo;
        super.fromData(in);
        this.setKey(DataSerializer.readObject(in));
        this.cbArg = DataSerializer.readObject(in);
        this.op = Operation.fromOrdinal(in.readByte());
        this.notificationOnly = in.readBoolean();
        this.bridgeContext = ClientProxyMembershipID.readCanonicalized(in);
        this.originalSender = (InternalDistributedMember)DataSerializer.readObject(in);
        this.eventId = (EventID)DataSerializer.readObject(in);
        this.expectedOldValue = DataSerializer.readObject(in);
        boolean bl = hasFilterInfo = (this.flags & 0x400) != 0;
        if (hasFilterInfo) {
            this.filterInfo = new FilterRoutingInfo();
            InternalDataSerializer.invokeFromData(this.filterInfo, in);
        }
        this.versionTag = (VersionTag)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.getKey(), out);
        DataSerializer.writeObject(this.cbArg, out);
        out.writeByte(this.op.ordinal);
        out.writeBoolean(this.notificationOnly);
        DataSerializer.writeObject(this.bridgeContext, out);
        DataSerializer.writeObject(this.originalSender, out);
        DataSerializer.writeObject(this.eventId, out);
        DataSerializer.writeObject(this.expectedOldValue, out);
        if (this.filterInfo != null) {
            InternalDataSerializer.invokeToData(this.filterInfo, out);
        }
        DataSerializer.writeObject(this.versionTag, out);
    }

    @Override
    protected short computeCompressedShort(short s) {
        s = super.computeCompressedShort(s);
        if (this.filterInfo != null) {
            s = (short)(s | 0x400);
        }
        return s;
    }

    @Override
    public EventID getEventID() {
        return this.eventId;
    }

    EntryEventImpl createListenerEvent(EntryEventImpl sourceEvent, PartitionedRegion r, InternalDistributedMember member) {
        EntryEventImpl e2;
        if (this.notificationOnly && this.bridgeContext == null) {
            e2 = sourceEvent;
        } else {
            e2 = new EntryEventImpl(sourceEvent);
            if (this.bridgeContext != null) {
                e2.setContext(this.bridgeContext);
            }
        }
        e2.setRegion(r);
        e2.setOriginRemote(true);
        e2.setInvokePRCallbacks(!this.notificationOnly);
        if (this.filterInfo != null) {
            e2.setLocalFilterInfo(this.filterInfo.getFilterInfo(member));
        }
        if (this.versionTag != null) {
            this.versionTag.replaceNullIDs(this.getSender());
            e2.setVersionTag(this.versionTag);
        }
        return e2;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.getKey());
        if (this.originalSender != null) {
            buff.append("; originalSender=").append(this.originalSender);
        }
        if (this.bridgeContext != null) {
            buff.append("; bridgeContext=").append(this.bridgeContext);
        }
        if (this.eventId != null) {
            buff.append("; eventId=").append(this.eventId);
        }
        if (this.versionTag != null) {
            buff.append("; version=").append(this.versionTag);
        }
        if (this.filterInfo != null) {
            buff.append("; ").append(this.filterInfo);
        }
    }

    protected final Object getKey() {
        return this.key;
    }

    private final void setKey(Object key2) {
        this.key = key2;
    }

    public final Operation getOperation() {
        return this.op;
    }

    protected final Object getCallbackArg() {
        return this.cbArg;
    }

    @Override
    public void setFilterInfo(FilterRoutingInfo filterInfo) {
        if (filterInfo != null) {
            this.filterInfo = filterInfo;
        }
    }

    public static class DestroyResponse
    extends PartitionMessage.PartitionResponse {
        VersionTag versionTag;

        DestroyResponse(InternalDistributedSystem ds, Set recipients, Object key2) {
            super(ds, recipients, false);
        }

        void setResponse(VersionTag versionTag) {
            this.versionTag = versionTag;
        }

        public VersionTag getVersionTag() {
            return this.versionTag;
        }
    }

    public static class DestroyReplyMessage
    extends ReplyMessage {
        private VersionTag versionTag;

        public DestroyReplyMessage() {
        }

        static void send(InternalDistributedMember recipient, ReplySender dm, int procId, VersionTag versionTag, boolean internal) {
            Assert.assertTrue(recipient != null, "DestroyReplyMessage NULL recipient");
            DestroyReplyMessage m = new DestroyReplyMessage(recipient, procId, versionTag);
            m.internal = internal;
            dm.putOutgoing(m);
        }

        DestroyReplyMessage(InternalDistributedMember recipient, int procId, VersionTag versionTag) {
            this.setProcessorId(procId);
            this.setRecipient(recipient);
            this.versionTag = versionTag;
        }

        @Override
        public int getDSFID() {
            return 150;
        }

        @Override
        public void process(DM dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "DestroyReplyMessage process invoking reply processor with processorId: {}", this.processorId);
            }
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "DestroyReplyMessage processor not found");
                }
                return;
            }
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
            }
            if (rp instanceof DestroyResponse) {
                DestroyResponse processor = (DestroyResponse)rp;
                if (this.versionTag != null) {
                    this.versionTag.replaceNullIDs(this.getSender());
                }
                processor.setResponse(this.versionTag);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.debug("{} processed {} ", rp, this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            int b = this.versionTag != null ? 1 : 0;
            b = (byte)(b | (this.versionTag instanceof DiskVersionTag ? 2 : 0));
            out.writeByte(b);
            if (this.versionTag != null) {
                InternalDataSerializer.invokeToData(this.versionTag, out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            boolean persistentTag;
            super.fromData(in);
            byte b = in.readByte();
            boolean hasTag = (b & 1) != 0;
            boolean bl = persistentTag = (b & 2) != 0;
            if (hasTag) {
                this.versionTag = VersionTag.create(persistentTag, in);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = super.getStringBuilder();
            if (this.versionTag != null) {
                sb.append(" version=").append(this.versionTag);
            }
            sb.append(" from ");
            sb.append(this.getSender());
            ReplyException ex = this.getException();
            if (ex != null) {
                sb.append(" with exception ");
                sb.append(ex);
            }
            return sb.toString();
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }
    }
}

