/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.BucketDump;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gnu.trove.TObjectIntProcedure;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;

public final class FetchEntriesMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;

    public FetchEntriesMessage() {
    }

    private FetchEntriesMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
    }

    public static FetchEntriesResponse send(InternalDistributedMember recipient, PartitionedRegion r, int bucketId) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "FetchEntriesMessage NULL reply message");
        FetchEntriesResponse p = new FetchEntriesResponse(r.getSystem(), r, recipient, bucketId);
        FetchEntriesMessage m = new FetchEntriesMessage(recipient, r.getPRId(), p, bucketId);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.FetchEntriesMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr2, long startTime) throws CacheException, ForceReattemptException {
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "FetchEntriesMessage operateOnRegion: {}", pr2.getFullPath());
        }
        PartitionedRegionDataStore ds = pr2.getDataStore();
        BucketRegion entries = null;
        if (ds != null) {
            entries = ds.handleRemoteGetEntries(this.bucketId);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "FetchKeysMessage send keys back using processorId: {}", this.getProcessorId());
            }
        } else {
            logger.warn(LocalizedMessage.create(LocalizedStrings.FetchEntriesMessage_FETCHKEYSMESSAGE_DATA_STORE_NOT_CONFIGURED_FOR_THIS_MEMBER));
        }
        pr2.getPrStats().endPartitionMessagesProcessing(startTime);
        FetchEntriesReplyMessage.send(this.getSender(), this.getProcessorId(), dm, this.bucketId, entries);
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
        buff.append("; recipient=").append(this.getRecipient());
    }

    @Override
    public int getDSFID() {
        return 46;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
    }

    public static class FetchEntriesResponse
    extends ReplyProcessor21 {
        private final PartitionedRegion pr;
        private volatile RegionVersionVector returnRVV;
        private final HashMap<Object, Object> returnValue;
        private final HashMap<Object, VersionTag> returnVersions = new HashMap();
        private final Map<VersionSource, VersionSource> canonicalMembers = new ConcurrentHashMap<VersionSource, VersionSource>();
        private final Object endLock = new Object();
        private volatile int chunksProcessed;
        private volatile int chunksExpected;
        private volatile boolean lastChunkReceived;
        private int bucketId;
        private InternalDistributedMember recipient;

        public FetchEntriesResponse(InternalDistributedSystem ds, PartitionedRegion pr2, final InternalDistributedMember recipient, final int bucketId) {
            super(ds, Collections.singleton(recipient));
            this.pr = pr2;
            this.bucketId = bucketId;
            this.recipient = recipient;
            this.returnValue = new HashMap<Object, Object>(){
                private static final long serialVersionUID = 0L;

                @Override
                public String toString() {
                    return "Bucket id = " + bucketId + " from member = " + recipient + ": " + super.toString();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            ReplyMessage reply;
            Object returnValue;
            if (msg instanceof ReplyMessage && (returnValue = (reply = (ReplyMessage)msg).getReturnValue()) instanceof RegionVersionVector) {
                this.returnRVV = (RegionVersionVector)returnValue;
                Object object = this.endLock;
                synchronized (object) {
                    if (this.allMessagesReceived(true)) {
                        super.process(msg);
                    }
                }
                return;
            }
            super.process(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processChunk(FetchEntriesReplyMessage msg) {
            boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.DM);
            boolean doneProcessing = false;
            if (msg.getException() != null) {
                this.process(msg);
            } else {
                boolean deserializingKey = true;
                try {
                    ByteArrayInputStream byteStream = new ByteArrayInputStream(msg.chunk);
                    DataInputStream in = new DataInputStream(byteStream);
                    boolean requiresRegionContext = this.pr.keyRequiresRegionContext();
                    while (in.available() > 0) {
                        deserializingKey = true;
                        Object key2 = DataSerializer.readObject(in);
                        if (key2 != null) {
                            if (requiresRegionContext) {
                                ((KeyWithRegionContext)key2).setRegionContext(this.pr);
                            }
                            deserializingKey = false;
                            Object value2 = DataSerializer.readObject(in);
                            VersionTag versionTag = (VersionTag)DataSerializer.readObject(in);
                            if (this.canonicalMembers.containsKey(versionTag.getMemberID())) {
                                versionTag.setMemberID(this.canonicalMembers.get(versionTag.getMemberID()));
                            } else {
                                this.canonicalMembers.put((VersionSource)versionTag.getMemberID(), (VersionSource)versionTag.getMemberID());
                            }
                            HashMap<Object, Object> hashMap = this.returnValue;
                            synchronized (hashMap) {
                                this.returnValue.put(key2, value2);
                                this.returnVersions.put(key2, versionTag);
                                continue;
                            }
                        }
                        Assert.assertTrue(in.available() == 0);
                    }
                    Object object = this.endLock;
                    synchronized (object) {
                        ++this.chunksProcessed;
                        if (msg.seriesNum + 1 == msg.numSeries && msg.lastInSeries) {
                            this.chunksExpected = msg.msgNum + 1;
                            this.lastChunkReceived = true;
                        }
                        if (this.allMessagesReceived(msg.hasRVV)) {
                            doneProcessing = true;
                        }
                        if (isDebugEnabled) {
                            logger.trace(LogMarker.DM, "{} chunksProcessed={},lastChunkReceived={},chunksExpected={},done={}", this, this.chunksProcessed, this.lastChunkReceived, this.chunksExpected, doneProcessing);
                        }
                    }
                }
                catch (Exception e) {
                    if (deserializingKey) {
                        this.processException(new ReplyException(LocalizedStrings.FetchEntriesMessage_ERROR_DESERIALIZING_KEYS.toLocalizedString(), e));
                    } else {
                        this.processException(new ReplyException(LocalizedStrings.FetchEntriesMessage_ERROR_DESERIALIZING_VALUES.toLocalizedString(), e));
                    }
                    this.checkIfDone();
                }
                if (doneProcessing) {
                    this.process(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean allMessagesReceived(boolean hasRVV) {
            Object object = this.endLock;
            synchronized (object) {
                return this.lastChunkReceived && this.chunksExpected == this.chunksProcessed && (!hasRVV || this.returnRVV != null);
            }
        }

        public BucketDump waitForEntries() throws ForceReattemptException {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    logger.debug("FetchKeysResponse got remote cancellation; forcing reattempt. {}", t.getMessage(), t);
                    throw new ForceReattemptException(LocalizedStrings.FetchEntriesMessage_FETCHKEYSRESPONSE_GOT_REMOTE_CANCELLATION_FORCING_REATTEMPT.toLocalizedString(), t);
                }
                if (t instanceof ForceReattemptException) {
                    throw new ForceReattemptException(LocalizedStrings.FetchEntriesMessage_PEER_REQUESTS_REATTEMPT.toLocalizedString(), t);
                }
                e.handleAsUnexpected();
            }
            if (!this.lastChunkReceived) {
                throw new ForceReattemptException(LocalizedStrings.FetchEntriesMessage_NO_REPLIES_RECEIVED.toLocalizedString());
            }
            for (Map.Entry<Object, Object> entry : this.returnValue.entrySet()) {
                Object value2 = entry.getValue();
                if (!(value2 instanceof CachedDeserializable)) continue;
                entry.setValue(((CachedDeserializable)value2).getDeserializedValue(null, null));
            }
            return new BucketDump(this.bucketId, this.recipient, this.returnRVV, this.returnValue, this.returnVersions);
        }
    }

    public static final class FetchEntriesReplyMessage
    extends ReplyMessage {
        int bucketId;
        int seriesNum;
        int msgNum;
        int numSeries;
        boolean lastInSeries;
        transient byte[] chunk;
        transient HeapDataOutputStream chunkStream;
        private boolean hasRVV;
        private static final Version[] dsfidVersions = new Version[]{Version.GFE_80};

        @Override
        public Version[] getSerializationVersions() {
            return dsfidVersions;
        }

        public FetchEntriesReplyMessage() {
        }

        private FetchEntriesReplyMessage(InternalDistributedMember dest, int processorId, int buckId, HeapDataOutputStream chunk, int seriesNum, int msgNum, int numSeries, boolean lastInSeries, boolean hasRVV) {
            this.setRecipient(dest);
            this.setProcessorId(processorId);
            this.bucketId = buckId;
            this.seriesNum = seriesNum;
            this.msgNum = msgNum;
            this.numSeries = numSeries;
            this.lastInSeries = lastInSeries;
            this.chunkStream = chunk;
            this.hasRVV = hasRVV;
        }

        public static void send(final InternalDistributedMember recipient, final int processorId, final DM dm, final int bucketId, BucketRegion keys) throws ForceReattemptException {
            Assert.assertTrue(recipient != null, "FetchEntriesReplyMessage NULL reply message");
            boolean numSeries = true;
            boolean seriesNum = false;
            final RegionVersionVector rvv = keys.getVersionVector();
            if (rvv != null) {
                RegionVersionVector clone = rvv.getCloneForTransmission();
                ReplyMessage.send(recipient, processorId, clone, (ReplySender)dm);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Starting PR entries chunking for {} entries", keys.size());
            }
            try {
                boolean finished = FetchEntriesReplyMessage.chunkMap(recipient, keys, InitialImageOperation.CHUNK_SIZE_IN_BYTES, false, new TObjectIntProcedure(){
                    int msgNum = 0;
                    boolean last = false;

                    @Override
                    public boolean execute(Object a, int b) {
                        HeapDataOutputStream chunk = (HeapDataOutputStream)a;
                        this.last = b > 0;
                        try {
                            boolean okay = FetchEntriesReplyMessage.sendChunk(recipient, processorId, bucketId, dm, chunk, 0, this.msgNum++, 1, this.last, rvv != null);
                            return okay;
                        }
                        catch (CancelException e) {
                            return false;
                        }
                    }
                });
                if (logger.isDebugEnabled()) {
                    logger.debug("{} PR entries chunking", finished ? "Finished" : "DID NOT complete");
                }
            }
            catch (IOException io) {
                throw new ForceReattemptException(LocalizedStrings.FetchEntriesMessage_UNABLE_TO_SEND_RESPONSE_TO_FETCHENTRIES_REQUEST.toLocalizedString(), io);
            }
        }

        static boolean sendChunk(InternalDistributedMember recipient, int processorId, int bucketId, DM dm, HeapDataOutputStream chunk, int seriesNum, int msgNum, int numSeries, boolean lastInSeries, boolean hasRVV) {
            FetchEntriesReplyMessage reply = new FetchEntriesReplyMessage(recipient, processorId, bucketId, chunk, seriesNum, msgNum, numSeries, lastInSeries, hasRVV);
            Set failures = dm.putOutgoing(reply);
            return failures == null || failures.size() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean chunkMap(InternalDistributedMember receiver, BucketRegion map, int CHUNK_SIZE_IN_BYTES, boolean includeValues, TObjectIntProcedure proc) throws IOException {
            Iterator it = map.entrySet().iterator();
            boolean keepGoing = true;
            boolean sentLastChunk = false;
            HeapDataOutputStream mos = new HeapDataOutputStream(InitialImageOperation.CHUNK_SIZE_IN_BYTES + 2048, receiver.getVersionObject());
            do {
                mos.reset();
                int avgItemSize = 0;
                int itemCount = 0;
                while (mos.size() + avgItemSize < InitialImageOperation.CHUNK_SIZE_IN_BYTES && it.hasNext()) {
                    RegionEntry re;
                    LocalRegion.NonTXEntry entry = (LocalRegion.NonTXEntry)it.next();
                    RegionEntry regionEntry = re = entry.getRegionEntry();
                    synchronized (regionEntry) {
                        Object value2 = re._getValueUse(map, true);
                        if (value2 == null) {
                            value2 = re.getSerializedValueOnDisk((LocalRegion)entry.getRegion());
                        }
                        if (!Token.isRemoved(value2)) {
                            VersionStamp stamp;
                            VersionTag versionTag;
                            DataSerializer.writeObject(re.getKey(), mos);
                            if (Token.isInvalid(value2)) {
                                value2 = null;
                            }
                            VersionTag versionTag2 = versionTag = (stamp = re.getVersionStamp()) != null ? stamp.asVersionTag() : null;
                            if (versionTag != null) {
                                versionTag.replaceNullIDs(map.getVersionMember());
                            }
                            DataSerializer.writeObject(value2, mos);
                            DataSerializer.writeObject(versionTag, mos);
                            avgItemSize = mos.size() / ++itemCount;
                        }
                    }
                }
                DataSerializer.writeObject(null, mos);
                int lastMsg = it.hasNext() ? 0 : 1;
                keepGoing = proc.execute(mos, lastMsg);
                boolean bl = sentLastChunk = lastMsg == 1 && keepGoing;
            } while (keepGoing && it.hasNext());
            return sentLastChunk;
        }

        @Override
        public void process(DM dm, ReplyProcessor21 p) {
            long startTime = this.getTimestamp();
            FetchEntriesResponse processor = (FetchEntriesResponse)p;
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "FetchEntriesReplyMessage processor not found");
                }
                return;
            }
            processor.processChunk(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            this.toDataPre_GFE_8_0_0_0(out);
            out.writeBoolean(this.hasRVV);
        }

        public void toDataPre_GFE_8_0_0_0(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.bucketId);
            out.writeInt(this.seriesNum);
            out.writeInt(this.msgNum);
            out.writeInt(this.numSeries);
            out.writeBoolean(this.lastInSeries);
            DataSerializer.writeObjectAsByteArray(this.chunkStream, out);
        }

        @Override
        public int getDSFID() {
            return 65;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.fromDataPre_GFE_8_0_0_0(in);
            this.hasRVV = in.readBoolean();
        }

        public void fromDataPre_GFE_8_0_0_0(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.bucketId = in.readInt();
            this.seriesNum = in.readInt();
            this.msgNum = in.readInt();
            this.numSeries = in.readInt();
            this.lastInSeries = in.readBoolean();
            this.chunk = DataSerializer.readByteArray(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("FetchEntriesReplyMessage ").append("processorid=").append(this.processorId).append(",bucketId=").append(this.bucketId);
            if (this.getSender() != null) {
                sb.append(",sender=").append(this.getSender());
            }
            sb.append(",seriesNum=").append(this.seriesNum).append(",msgNum=").append(this.msgNum).append(",numSeries=").append(this.numSeries).append(",lastInSeries=").append(this.lastInSeries);
            if (this.chunk != null) {
                sb.append(",size=").append(this.chunk.length);
            } else if (this.chunkStream != null) {
                sb.append(",size=").append(this.chunkStream.size());
            }
            if (this.getException() != null) {
                sb.append(",exception=").append(this.getException());
            }
            return sb.toString();
        }
    }
}

