/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.TransactionDataNotColocatedException;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.DataLocationException;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessageWithDirectReply;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class GetMessage
extends PartitionMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private Object cbArg;
    private transient boolean forceUseOfPRExecutor;
    private ClientProxyMembershipID context;
    private boolean returnTombstones;
    protected static final int HAS_LOADER = 64;
    protected static final int CAN_START_TX = 128;
    private static final boolean ORDER_PR_GETS = Boolean.getBoolean("gemfire.order-pr-gets");

    public GetMessage() {
    }

    private GetMessage(InternalDistributedMember recipient, int regionId, DirectReplyProcessor processor, Object key2, Object aCallbackArgument, ClientProxyMembershipID context, boolean returnTombstones) {
        super(recipient, regionId, processor);
        this.key = key2;
        this.cbArg = aCallbackArgument;
        this.context = context;
        this.returnTombstones = returnTombstones;
    }

    @Override
    public final int getProcessorType() {
        if (this.forceUseOfPRExecutor) {
            return 78;
        }
        if (ORDER_PR_GETS) {
            return 78;
        }
        return 74;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected final boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) throws ForceReattemptException {
        BucketRegion.RawValue valueBytes;
        EntryEventImpl event;
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "GetMessage operateOnRegion: {}", r.getFullPath());
        }
        PartitionedRegionDataStore ds = r.getDataStore();
        if (this.getTXUniqId() != -1) assert (r.getDataView() instanceof TXStateProxy);
        if (ds != null) {
            event = EntryEventImpl.createVersionTagHolder();
            try {
                if (r.keyRequiresRegionContext()) {
                    ((KeyWithRegionContext)this.key).setRegionContext(r);
                }
                KeyInfo keyInfo = r.getKeyInfo(this.key, this.cbArg);
                boolean lockEntry = this.forceUseOfPRExecutor || this.isDirectAck();
                Object val = r.getDataView().getSerializedValue(r, keyInfo, !lockEntry, this.context, event, this.returnTombstones);
                if (val == BucketRegion.REQUIRES_ENTRY_LOCK) {
                    Assert.assertTrue(!lockEntry);
                    this.forceUseOfPRExecutor = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Rescheduling GetMessage due to possible cache-miss");
                    }
                    this.schedule(dm);
                    return false;
                }
                valueBytes = val instanceof BucketRegion.RawValue ? (BucketRegion.RawValue)val : new BucketRegion.RawValue(val);
            }
            catch (DistributedSystemDisconnectedException sde) {
                this.sendReply(this.getSender(), this.processorId, dm, new ReplyException(new ForceReattemptException(LocalizedStrings.GetMessage_OPERATION_GOT_INTERRUPTED_DUE_TO_SHUTDOWN_IN_PROGRESS_ON_REMOTE_VM.toLocalizedString(), sde)), r, startTime);
                return false;
            }
            catch (PrimaryBucketException pbe) {
                this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(pbe), r, startTime);
                return false;
            }
            catch (DataLocationException e) {
                this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(e), r, startTime);
                return false;
            }
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.debug("GetMessage sending serialized value {} back via GetReplyMessage using processorId: {}", valueBytes, this.getProcessorId());
            }
        } else {
            throw new InternalGemFireError(LocalizedStrings.GetMessage_GET_MESSAGE_SENT_TO_WRONG_MEMBER.toLocalizedString());
        }
        r.getPrStats().endPartitionMessagesProcessing(startTime);
        GetReplyMessage.send(this.getSender(), this.getProcessorId(), valueBytes, this.getReplySender(dm), event.getVersionTag());
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.key).append("; callback arg=").append(this.cbArg).append("; context=").append(this.context);
    }

    @Override
    public int getDSFID() {
        return 120;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.key = DataSerializer.readObject(in);
        this.cbArg = DataSerializer.readObject(in);
        this.context = (ClientProxyMembershipID)DataSerializer.readObject(in);
        this.returnTombstones = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.key, out);
        DataSerializer.writeObject(this.cbArg, out);
        DataSerializer.writeObject(this.context, out);
        out.writeBoolean(this.returnTombstones);
    }

    public void setKey(Object key2) {
        this.key = key2;
    }

    public static GetResponse send(InternalDistributedMember recipient, PartitionedRegion r, Object key2, Object aCallbackArgument, ClientProxyMembershipID requestingClient, boolean returnTombstones) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "PRDistribuedGetReplyMessage NULL reply message");
        GetResponse p = new GetResponse(r.getSystem(), Collections.singleton(recipient), key2);
        GetMessage m = new GetMessage(recipient, r.getPRId(), p, key2, aCallbackArgument, requestingClient, returnTombstones);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.GetMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    public static class GetResponse
    extends PartitionMessage.PartitionResponse {
        private volatile GetReplyMessage getReply;
        private volatile boolean returnValueReceived;
        private volatile long start;
        final Object key;
        private VersionTag versionTag;

        public GetResponse(InternalDistributedSystem ds, Set recipients, Object key2) {
            super(ds, recipients, false);
            this.key = key2;
        }

        @Override
        public void process(DistributionMessage msg) {
            if (DistributionStats.enableClockStats) {
                this.start = DistributionStats.getStatTime();
            }
            if (msg instanceof GetReplyMessage) {
                GetReplyMessage reply = (GetReplyMessage)msg;
                if (reply.valueInBytes != null || reply.valueType == 3 || reply.valueType == 4) {
                    this.getReply = reply;
                }
                this.returnValueReceived = true;
                this.versionTag = reply.versionTag;
            }
            super.process(msg);
        }

        public Object getValue(boolean preferCD) throws ForceReattemptException {
            GetReplyMessage reply = this.getReply;
            try {
                if (reply != null) {
                    switch (reply.valueType) {
                        case 1: {
                            return reply.valueInBytes;
                        }
                        case 3: {
                            return Token.INVALID;
                        }
                        case 4: {
                            return Token.TOMBSTONE;
                        }
                    }
                    if (reply.valueInBytes != null) {
                        if (preferCD) {
                            return CachedDeserializableFactory.create(reply.valueInBytes);
                        }
                        return BlobHelper.deserializeBlob(reply.valueInBytes, reply.remoteVersion, null);
                    }
                    return null;
                }
                return null;
            }
            catch (IOException e) {
                throw new ForceReattemptException(LocalizedStrings.GetMessage_UNABLE_TO_DESERIALIZE_VALUE_IOEXCEPTION.toLocalizedString(), e);
            }
            catch (ClassNotFoundException e) {
                throw new ForceReattemptException(LocalizedStrings.GetMessage_UNABLE_TO_DESERIALIZE_VALUE_CLASSNOTFOUNDEXCEPTION.toLocalizedString(), e);
            }
        }

        public VersionTag getVersionTag() {
            return this.versionTag;
        }

        public Object waitForResponse(boolean preferCD) throws ForceReattemptException {
            try {
                this.waitForCacheException();
                if (DistributionStats.enableClockStats) {
                    this.getDistributionManager().getStats().incReplyHandOffTime(this.start);
                }
            }
            catch (EntryNotFoundException enfe) {
                throw enfe;
            }
            catch (ForceReattemptException e) {
                e.checkKey(this.key);
                String msg = "GetResponse got ForceReattemptException; rethrowing";
                logger.debug("GetResponse got ForceReattemptException; rethrowing", (Throwable)e);
                throw e;
            }
            catch (TransactionDataNotColocatedException e) {
                throw e;
            }
            if (!this.returnValueReceived) {
                throw new ForceReattemptException(LocalizedStrings.GetMessage_NO_RETURN_VALUE_RECEIVED.toLocalizedString());
            }
            return this.getValue(preferCD);
        }
    }

    public static final class GetReplyMessage
    extends ReplyMessage {
        private transient BucketRegion.RawValue rawVal;
        byte valueType;
        static final byte VALUE_IS_SERIALIZED_OBJECT = 0;
        static final byte VALUE_IS_BYTES = 1;
        static final byte VALUE_IS_INVALID = 3;
        static final byte VALUE_IS_TOMBSTONE = 4;
        static final byte VALUE_HAS_VERSION_TAG = 8;
        public transient byte[] valueInBytes;
        public VersionTag versionTag;
        public transient Version remoteVersion;

        public GetReplyMessage() {
        }

        private GetReplyMessage(int processorId, BucketRegion.RawValue val, VersionTag versionTag) {
            this.setProcessorId(processorId);
            this.rawVal = val;
            Object rval = val.getRawValue();
            this.valueType = rval == Token.TOMBSTONE ? (byte)4 : (Token.isInvalid(rval) ? (byte)3 : (val.isValueByteArray() ? (byte)1 : 0));
            this.versionTag = versionTag;
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public static void send(InternalDistributedMember recipient, int processorId, BucketRegion.RawValue val, ReplySender replySender, VersionTag versionTag) throws ForceReattemptException {
            Assert.assertTrue(recipient != null, "PRDistribuedGetReplyMessage NULL reply message");
            GetReplyMessage m = new GetReplyMessage(processorId, val, versionTag);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.DM);
            long startTime = this.getTimestamp();
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM, "GetReplyMessage process invoking reply processor with processorId: {}", this.processorId);
            }
            if (processor == null) {
                if (isDebugEnabled) {
                    logger.debug("GetReplyMessage processor not found");
                }
                return;
            }
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
            }
            processor.process(this);
            if (isDebugEnabled) {
                logger.debug("{} Processed {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return 125;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            boolean hasVersionTag = this.versionTag != null;
            byte flags = this.valueType;
            if (hasVersionTag) {
                flags = (byte)(flags | 8);
            }
            out.writeByte(flags);
            if (this.valueType == 1) {
                DataSerializer.writeByteArray((byte[])this.rawVal.getRawValue(), out);
            } else {
                this.rawVal.writeAsByteArray(out);
            }
            if (hasVersionTag) {
                DataSerializer.writeObject(this.versionTag, out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            byte flags = in.readByte();
            boolean hasVersionTag = (flags & 8) != 0;
            if (hasVersionTag) {
                flags = (byte)(flags & 0xFFFFFFF7);
            }
            this.valueType = flags;
            this.valueInBytes = DataSerializer.readByteArray(in);
            if (flags != 1) {
                this.remoteVersion = InternalDataSerializer.getVersionForDataStreamOrNull(in);
            }
            if (hasVersionTag) {
                this.versionTag = (VersionTag)DataSerializer.readObject(in);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("GetReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            if (this.valueType == 4) {
                sb.append(" returning tombstone token.");
            } else if (this.valueType == 3) {
                sb.append(" returning invalid token.");
            } else if (this.rawVal != null) {
                sb.append(" returning serialized value=").append(this.rawVal);
            } else if (this.valueInBytes == null) {
                sb.append(" returning null value");
            } else {
                sb.append(" returning serialized value of len=").append(this.valueInBytes.length);
            }
            if (this.versionTag != null) {
                sb.append(" version=").append(this.versionTag);
            }
            return sb.toString();
        }
    }
}

