/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.partitioned.IdentityRequestMessage;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class IdentityUpdateMessage
extends DistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private int processorId;
    private int newId;

    public IdentityUpdateMessage() {
    }

    public IdentityUpdateMessage(Set recipients, int processorId, int newId) {
        this.setRecipients(recipients);
        this.processorId = processorId;
        this.newId = newId;
    }

    @Override
    public int getProcessorType() {
        return 75;
    }

    @Override
    protected void process(DistributionManager dm) {
        try {
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{}: processing message {}", this.getClass().getName(), this);
            }
            IdentityRequestMessage.setLatestId(this.newId);
            ReplyMessage.send(this.getSender(), this.getProcessorId(), null, (ReplySender)dm);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.debug("{} Caught throwable {}", this, t.getMessage(), t);
        }
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    public static IdentityUpdateResponse send(Set recipients, InternalDistributedSystem is, int currentPRId) {
        Assert.assertTrue(recipients != null, "IdentityUpdateMessage NULL recipients set");
        IdentityRequestMessage.setLatestId(currentPRId);
        IdentityUpdateResponse p = new IdentityUpdateResponse(is, recipients);
        IdentityUpdateMessage m = new IdentityUpdateMessage(recipients, p.getProcessorId(), currentPRId);
        is.getDistributionManager().putOutgoing(m);
        return p;
    }

    @Override
    public int getDSFID() {
        return 51;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
        this.newId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
        out.writeInt(this.newId);
    }

    @Override
    public String toString() {
        return new StringBuffer().append(this.getClass().getName()).append("(sender=").append(this.getSender()).append("; processorId=").append(this.processorId).append("; newPRId=").append(this.newId).append(")").toString();
    }

    public static class IdentityUpdateResponse
    extends ReplyProcessor21 {
        public IdentityUpdateResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, (Collection)recipients);
        }

        @Override
        protected synchronized void processException(ReplyException ex) {
            logger.debug("IdentityUpdateResponse ignoring exception {}", ex.getMessage(), ex);
        }
    }
}

