/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexCreationException;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.MultiIndexCreationException;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.internal.index.IndexCreationData;
import com.gemstone.gemfire.cache.query.internal.index.PartitionedIndex;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionException;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.partitioned.RegionAdvisor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class IndexCreationMsg
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    HashSet<IndexCreationData> indexDefinitions;

    IndexCreationMsg(Set recipients, int regionId, ReplyProcessor21 processor, HashSet<IndexCreationData> indexDefinitions) {
        super(recipients, regionId, processor);
        this.indexDefinitions = indexDefinitions;
    }

    public IndexCreationMsg() {
    }

    @Override
    protected final boolean failIfRegionMissing() {
        return false;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr2, long startTime) throws CacheException, ForceReattemptException {
        PartitionedIndex prIndex;
        HashMap<String, Integer> indexBucketsMap;
        ReplyException replyEx = null;
        boolean result = false;
        List<Index> indexes = null;
        ArrayList<String> failedIndexNames = new ArrayList<String>();
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (IndexCreationData icd : this.indexDefinitions) {
                sb.append(icd.getIndexName()).append(" ");
            }
            logger.debug("Processing index creation message on this remote partitioned region vm for indexes: {}", sb);
        }
        try {
            indexes = pr2.createIndexes(true, this.indexDefinitions);
        }
        catch (IndexCreationException e1) {
            replyEx = new ReplyException(LocalizedStrings.IndexCreationMsg_REMOTE_INDEX_CREAION_FAILED.toLocalizedString(), e1);
        }
        catch (MultiIndexCreationException exx) {
            failedIndexNames.addAll(exx.getExceptionsMap().keySet());
            if (logger.isDebugEnabled()) {
                StringBuffer exceptionMsgs = new StringBuffer();
                for (Exception ex : exx.getExceptionsMap().values()) {
                    exceptionMsgs.append(ex.getMessage()).append("\n");
                }
                logger.debug("Got an MultiIndexCreationException with \n: {}", exceptionMsgs);
                logger.debug("{} indexes were created succesfully", failedIndexNames.size());
            }
            replyEx = new ReplyException(LocalizedStrings.IndexCreationMsg_REMOTE_INDEX_CREAION_FAILED.toLocalizedString(), exx);
        }
        if (null == replyEx) {
            result = true;
        }
        if (result) {
            indexBucketsMap = new HashMap<String, Integer>();
            for (Index index2 : indexes) {
                prIndex = (PartitionedIndex)index2;
                indexBucketsMap.put(prIndex.getName(), prIndex.getNumberOfIndexedBuckets());
            }
            this.sendReply(this.getSender(), this.getProcessorId(), dm, replyEx, result, indexBucketsMap, pr2.getDataStore().getAllLocalBuckets().size());
        } else {
            indexBucketsMap = new HashMap();
            for (IndexCreationData icd : this.indexDefinitions) {
                if (failedIndexNames.contains(icd.getIndexName())) continue;
                prIndex = pr2.getIndex(icd.getIndexName());
                indexBucketsMap.put(icd.getIndexName(), prIndex.getNumberOfIndexedBuckets());
            }
            this.sendReply(this.getSender(), this.getProcessorId(), dm, replyEx, result, indexBucketsMap, pr2.getDataStore().getAllLocalBuckets().size());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Multi Index creation completed on remote host and has sent the reply to the originating vm.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void process(DistributionManager dm) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        Throwable thr = null;
        boolean sendReply = true;
        PartitionedRegion pr2 = null;
        try {
            block45: {
                if (isDebugEnabled) {
                    logger.debug("Trying to get pr with id: {}", this.regionId);
                }
                try {
                    if (isDebugEnabled) {
                        logger.debug("Again trying to get pr with id : {}", this.regionId);
                    }
                    pr2 = PartitionedRegion.getPRFromId(this.regionId);
                    if (isDebugEnabled) {
                        logger.debug("Index creation message got the pr {}", pr2);
                    }
                    if (null != pr2) break block45;
                    boolean wait = true;
                    int attempts = 0;
                    while (wait && attempts < 30) {
                        dm.getCancelCriterion().checkCancelInProgress(null);
                        if (isDebugEnabled) {
                            logger.debug("Waiting for Partitioned Region to be intialized with id {}for processing index creation messages", this.regionId);
                        }
                        try {
                            boolean interrupted = Thread.interrupted();
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                                dm.getCancelCriterion().checkCancelInProgress(e);
                            }
                            finally {
                                if (interrupted) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            pr2 = PartitionedRegion.getPRFromId(this.regionId);
                            if (null != pr2) {
                                wait = false;
                                if (isDebugEnabled) {
                                    logger.debug("Indexcreation message got the pr {}", pr2);
                                }
                            }
                            ++attempts;
                        }
                        catch (CancelException ignorAndLoopWait) {
                            if (!isDebugEnabled) continue;
                            logger.debug("IndexCreationMsg waiting for pr to be properly created with prId : {}", this.regionId);
                        }
                    }
                }
                catch (CancelException letPRInitialized) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Waiting for notification from pr being properly created on {}", this.regionId);
                    }
                    boolean wait = true;
                    while (wait) {
                        dm.getCancelCriterion().checkCancelInProgress(null);
                        try {
                            boolean interrupted = Thread.interrupted();
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                                dm.getCancelCriterion().checkCancelInProgress(e);
                            }
                            finally {
                                if (interrupted) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            pr2 = PartitionedRegion.getPRFromId(this.regionId);
                            wait = false;
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Indexcreation message got the pr {}", pr2);
                        }
                        catch (CancelException ignorAndLoopWait) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("IndexCreationMsg waiting for pr to be properly created with prId : {}", this.regionId);
                        }
                    }
                }
            }
            if (pr2 == null) {
                String msg = LocalizedStrings.IndexCreationMsg_COULD_NOT_GET_PARTITIONED_REGION_FROM_ID_0_FOR_MESSAGE_1_RECEIVED_ON_MEMBER_2_MAP_3.toLocalizedString(this.regionId, this, dm.getId(), PartitionedRegion.dumpPRId());
                throw new PartitionedRegionException(msg, new RegionNotFoundException(msg));
            }
            sendReply = this.operateOnPartitionedRegion(dm, pr2, 0L);
        }
        catch (PRLocallyDestroyedException pre) {
            if (isDebugEnabled) {
                logger.debug("Region is locally Destroyed ");
            }
            thr = pre;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (this.processorId == 0) {
                logger.debug("{} exception while processing message:{}", this, t.getMessage(), t);
            } else if (logger.isDebugEnabled(LogMarker.DM) && t instanceof RuntimeException) {
                logger.debug(LogMarker.DM, "Exception caught while processing message: {}", t.getMessage(), t);
            }
            if (t instanceof RegionDestroyedException && pr2 != null) {
                if (pr2.isClosed) {
                    logger.info(LocalizedMessage.create(LocalizedStrings.IndexCreationMsg_REGION_IS_LOCALLY_DESTROYED_THROWING_REGIONDESTROYEDEXCEPTION_FOR__0, pr2));
                    thr = new RegionDestroyedException(LocalizedStrings.IndexCreationMsg_REGION_IS_LOCALLY_DESTROYED_ON_0.toLocalizedString(dm.getId()), pr2.getFullPath());
                }
            } else {
                thr = t;
            }
        }
        finally {
            if (sendReply && this.processorId != 0) {
                ReplyException rex = null;
                if (thr != null) {
                    rex = new ReplyException(thr);
                }
                this.sendReply(this.getSender(), this.processorId, dm, rex, pr2, 0L);
            }
        }
    }

    public static PartitionMessage.PartitionResponse send(InternalDistributedMember recipient, PartitionedRegion pr2, HashSet<IndexCreationData> indexDefinitions) {
        HashSet<Object> recipients;
        RegionAdvisor advisor = (RegionAdvisor)pr2.getDistributionAdvisor();
        if (null == recipient) {
            recipients = new HashSet<InternalDistributedMember>(advisor.adviseDataStore());
        } else {
            recipients = new HashSet<InternalDistributedMember>();
            recipients.add(recipient);
        }
        for (InternalDistributedMember internalDistributedMember : recipients) {
            if (internalDistributedMember.getVersionObject().compareTo(Version.GFE_81) >= 0) continue;
            throw new UnsupportedOperationException("Indexes should not be created during rolling upgrade");
        }
        IndexCreationResponse processor = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Will be sending create index msg to : {}", ((Object)recipients).toString());
        }
        if (recipients.size() > 0) {
            processor = (IndexCreationResponse)new IndexCreationMsg().createReplyProcessor(pr2, recipients);
        }
        IndexCreationMsg indexCreationMsg = new IndexCreationMsg(recipients, pr2.getPRId(), processor, indexDefinitions);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending index creation message: {}, to member(s) {}.", indexCreationMsg, recipients);
        }
        pr2.getDistributionManager().putOutgoing(indexCreationMsg);
        return processor;
    }

    @Override
    PartitionMessage.PartitionResponse createReplyProcessor(PartitionedRegion r, Set recipients) {
        return new IndexCreationResponse(r.getSystem(), recipients);
    }

    void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, boolean result, Map<String, Integer> indexBucketsMap, int numTotalBuckets) {
        IndexCreationReplyMsg.send(member, procId, dm, ex, result, indexBucketsMap, numTotalBuckets);
    }

    @Override
    public int getDSFID() {
        return 52;
    }

    @Override
    public final void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.indexDefinitions = DataSerializer.readHashSet(in);
    }

    @Override
    public Version[] getSerializationVersions() {
        return new Version[]{Version.GFE_81};
    }

    public final void fromDataPre_GFE_8_1_0_0(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        String name = in.readUTF();
        String fromClause = in.readUTF();
        String indexedExpression = in.readUTF();
        byte indexType = in.readByte();
        IndexType itype = null;
        if (0 == indexType) {
            itype = IndexType.PRIMARY_KEY;
        } else if (1 == indexType) {
            itype = IndexType.FUNCTIONAL;
        } else if (2 == indexType) {
            itype = IndexType.HASH;
        }
        boolean importsNeeded = in.readBoolean();
        String importStr = null;
        if (importsNeeded) {
            importStr = in.readUTF();
        }
        IndexCreationData icd = new IndexCreationData(name);
        icd.setIndexData(itype, fromClause, indexedExpression, importStr);
        this.indexDefinitions = new HashSet();
        this.indexDefinitions.add(icd);
    }

    public final void toDataPre_GFE_8_1_0_0(DataOutput out) throws IOException {
    }

    @Override
    public final void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeHashSet(this.indexDefinitions, out);
    }

    @Override
    public final String toString() {
        StringBuffer sb = new StringBuffer();
        for (IndexCreationData icd : this.indexDefinitions) {
            sb.append(icd.getIndexName()).append(" ");
        }
        return sb.toString();
    }

    public static final class IndexCreationReplyMsg
    extends ReplyMessage {
        private boolean result;
        private Map<String, Integer> indexBucketsMap;
        private int numTotalBuckets;
        private boolean isDataStore;

        public IndexCreationReplyMsg() {
        }

        IndexCreationReplyMsg(int processorId, ReplyException ex, boolean result, boolean isDataStore, Map<String, Integer> indexBucketsMap, int numTotalBuckets) {
            super.setException(ex);
            this.result = result;
            this.indexBucketsMap = indexBucketsMap;
            this.numTotalBuckets = numTotalBuckets;
            this.isDataStore = isDataStore;
            this.setProcessorId(processorId);
        }

        @Override
        public int getDSFID() {
            return 68;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.result = in.readBoolean();
            this.indexBucketsMap = (Map)DataSerializer.readObject(in);
            this.numTotalBuckets = in.readInt();
            this.isDataStore = in.readBoolean();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.result);
            DataSerializer.writeObject(this.indexBucketsMap, out);
            out.writeInt(this.numTotalBuckets);
            out.writeBoolean(this.isDataStore);
        }

        public static void send(InternalDistributedMember recipient, int processorId, DM dm, ReplyException ex, boolean result, Map<String, Integer> indexBucketsMap, int numTotalBuckets) {
            IndexCreationReplyMsg indMsg = new IndexCreationReplyMsg(processorId, ex, result, result, indexBucketsMap, numTotalBuckets);
            indMsg.setRecipient(recipient);
            dm.putOutgoing(indMsg);
        }

        @Override
        public final void process(DM dm, ReplyProcessor21 p) {
            IndexCreationResponse processor;
            if (logger.isDebugEnabled()) {
                logger.debug("Processor id is : {}", this.processorId);
            }
            if ((processor = (IndexCreationResponse)p) != null) {
                processor.setResponse(this.result, this.indexBucketsMap, this.numTotalBuckets);
                processor.process(this);
            }
        }
    }

    public static class IndexCreationResult {
        private Map<String, Integer> indexBucketsMap;
        private int numTotalBuckets;

        IndexCreationResult(Map<String, Integer> indexBucketsMap, int numTotalBuckets) {
            this.indexBucketsMap = indexBucketsMap;
            this.numTotalBuckets = numTotalBuckets;
        }

        public Map<String, Integer> getIndexBucketsMap() {
            return this.indexBucketsMap;
        }
    }

    public static class IndexCreationResponse
    extends PartitionMessage.PartitionResponse {
        private Map<String, Integer> indexBucketsMap;
        private int numTotalBuckets;

        IndexCreationResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, recipients);
        }

        public IndexCreationResult waitForResult() throws CacheException, ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (RuntimeException re) {
                if (re instanceof PartitionedRegionException) {
                    if (!(re.getCause() instanceof RegionNotFoundException)) {
                        throw re;
                    }
                }
                throw re;
            }
            return new IndexCreationResult(this.indexBucketsMap, this.numTotalBuckets);
        }

        public void setResponse(boolean result, Map<String, Integer> indexBucketsMap, int numTotalBuckets) {
            this.indexBucketsMap = indexBucketsMap;
            this.numTotalBuckets = numTotalBuckets;
        }
    }
}

