/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class ManageBucketMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;
    private int bucketSize;
    private boolean forceCreation;

    public ManageBucketMessage() {
    }

    private ManageBucketMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId, int bucketSize, boolean hostItNow) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
        this.bucketSize = bucketSize;
        this.forceCreation = hostItNow;
    }

    public ManageBucketMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    @Override
    public final int getProcessorType() {
        return 77;
    }

    public static NodeResponse send(InternalDistributedMember recipient, PartitionedRegion r, int bucketId, int bucketSize, boolean forceCreation) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "ManageBucketMessage NULL recipient");
        NodeResponse p = new NodeResponse(r.getSystem(), recipient);
        ManageBucketMessage m = new ManageBucketMessage(recipient, r.getPRId(), p, bucketId, bucketSize, forceCreation);
        p.enableSevereAlertProcessing();
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.ManageBucketMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    @Override
    public boolean canParticipateInTransaction() {
        return false;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) {
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "ManageBucketMessage operateOnRegion: {}", r.getFullPath());
        }
        r.waitOnInitialization();
        r.checkReadiness();
        PartitionedRegionDataStore prDs = r.getDataStore();
        boolean managingBucket = prDs.handleManageBucketRequest(this.bucketId, this.bucketSize, this.sender, this.forceCreation);
        r.getPrStats().endPartitionMessagesProcessing(startTime);
        if (managingBucket) {
            this.checkSenderStillAlive(r, this.getSender());
            ManageBucketReplyMessage.sendAcceptance(this.getSender(), this.getProcessorId(), dm);
        } else {
            ManageBucketReplyMessage.sendRefusal(this.getSender(), this.getProcessorId(), dm);
        }
        return false;
    }

    private void checkSenderStillAlive(PartitionedRegion r, InternalDistributedMember sender) {
        if (!r.getDistributionAdvisor().containsId(sender)) {
            r.getRedundancyProvider().finishIncompleteBucketCreation(this.bucketId);
        }
    }

    @Override
    public int getDSFID() {
        return 53;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
        this.bucketSize = in.readInt();
        this.forceCreation = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
        out.writeInt(this.bucketSize);
        out.writeBoolean(this.forceCreation);
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId).append("; bucketSize=").append(this.bucketSize);
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    public static class NodeResponse
    extends ReplyProcessor21 {
        private volatile ManageBucketReplyMessage msg;

        public NodeResponse(InternalDistributedSystem ds, InternalDistributedMember recipient) {
            super(ds, recipient);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof ManageBucketReplyMessage) {
                    ManageBucketReplyMessage reply;
                    this.msg = reply = (ManageBucketReplyMessage)msg;
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "NodeResponse return value is {} isInitializing {}", reply.acceptedBucket, reply.notYetInitialized);
                    }
                } else {
                    Assert.assertTrue(msg instanceof ReplyMessage);
                }
            }
            finally {
                super.process(msg);
            }
        }

        public boolean waitForAcceptance() throws ForceReattemptException {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    logger.debug("NodeResponse got remote cancellation, throwing PartitionedRegionCommunication Exception. {}", t.getMessage(), t);
                    throw new ForceReattemptException(LocalizedStrings.ManageBucketMessage_NODERESPONSE_GOT_REMOTE_CANCELLATION_THROWING_PARTITIONEDREGIONCOMMUNICATION_EXCEPTION.toLocalizedString(), t);
                }
                if (t instanceof PRLocallyDestroyedException) {
                    logger.debug("NodeResponse got local destroy on the PartitionRegion , throwing ForceReattemptException. {}", t.getMessage(), t);
                    throw new ForceReattemptException(LocalizedStrings.ManageBucketMessage_NODERESPONSE_GOT_LOCAL_DESTROY_ON_THE_PARTITIONREGION_THROWING_FORCEREATTEMPTEXCEPTION.toLocalizedString(), t);
                }
                if (t instanceof PartitionOfflineException) {
                    throw (PartitionOfflineException)t;
                }
                if (t instanceof ForceReattemptException) {
                    String msg = "NodeResponse got ForceReattemptException due to local destroy on the PartitionRegion.";
                    logger.debug(msg, t);
                    throw (ForceReattemptException)t;
                }
                e.handleAsUnexpected();
            }
            return this.msg != null && this.msg.acceptedBucket;
        }

        public boolean rejectedDueToInitialization() {
            return this.msg != null && this.msg.notYetInitialized;
        }
    }

    public static final class ManageBucketReplyMessage
    extends ReplyMessage {
        protected boolean acceptedBucket;
        protected boolean notYetInitialized;

        public ManageBucketReplyMessage() {
        }

        public ManageBucketReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private ManageBucketReplyMessage(int processorId, boolean accept, boolean initializing) {
            this.processorId = processorId;
            this.acceptedBucket = accept;
            this.notYetInitialized = initializing;
        }

        public static void sendRefusal(InternalDistributedMember recipient, int processorId, DM dm) {
            Assert.assertTrue(recipient != null, "ManageBucketReplyMessage NULL reply message");
            ManageBucketReplyMessage m = new ManageBucketReplyMessage(processorId, false, false);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        public static void sendStillInitializing(InternalDistributedMember recipient, int processorId, DM dm) {
            ManageBucketReplyMessage m = new ManageBucketReplyMessage(processorId, false, true);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        public static void sendAcceptance(InternalDistributedMember recipient, int processorId, DM dm) {
            Assert.assertTrue(recipient != null, "ManageBucketReplyMessage NULL reply message");
            ManageBucketReplyMessage m = new ManageBucketReplyMessage(processorId, true, false);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "ManageBucketReplyMessage process invoking reply processor with processorId: {}", this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "ManageBucketReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.acceptedBucket);
            out.writeBoolean(this.notYetInitialized);
        }

        @Override
        public int getDSFID() {
            return 69;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.acceptedBucket = in.readBoolean();
            this.notYetInitialized = in.readBoolean();
        }

        @Override
        public String toString() {
            return new StringBuffer().append("ManageBucketReplyMessage ").append("processorid=").append(this.processorId).append(" accepted bucket=").append(this.acceptedBucket).append(" isInitializing=").append(this.notYetInitialized).toString();
        }
    }
}

