/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class MoveBucketMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private volatile int bucketId;
    private volatile InternalDistributedMember source;

    public MoveBucketMessage() {
    }

    private MoveBucketMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId, InternalDistributedMember source) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
        this.source = source;
    }

    public static MoveBucketResponse send(InternalDistributedMember recipient, PartitionedRegion region, int bucketId, InternalDistributedMember source) {
        Assert.assertTrue(recipient != null, "MoveBucketMessage NULL recipient");
        MoveBucketResponse response = new MoveBucketResponse(region.getSystem(), recipient, region);
        MoveBucketMessage msg = new MoveBucketMessage(recipient, region.getPRId(), response, bucketId, source);
        Set failures = region.getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            return null;
        }
        region.getPrStats().incPartitionMessagesSent();
        return response;
    }

    public MoveBucketMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected final boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion region, long startTime) throws ForceReattemptException {
        PartitionedRegionDataStore dataStore = region.getDataStore();
        boolean moved = dataStore.moveBucket(this.bucketId, this.source, true);
        region.getPrStats().endPartitionMessagesProcessing(startTime);
        MoveBucketReplyMessage.send(this.getSender(), this.getProcessorId(), dm, null, moved);
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
        buff.append("; source=").append(this.source);
    }

    @Override
    public int getDSFID() {
        return 136;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
        this.source = (InternalDistributedMember)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
        DataSerializer.writeObject(this.source, out);
    }

    public static class MoveBucketResponse
    extends PartitionMessage.PartitionResponse {
        private volatile boolean moved = false;

        public MoveBucketResponse(InternalDistributedSystem ds, InternalDistributedMember recipient, PartitionedRegion theRegion) {
            super(ds, recipient);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof MoveBucketReplyMessage) {
                    MoveBucketReplyMessage reply = (MoveBucketReplyMessage)msg;
                    this.moved = reply.moved();
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "MoveBucketResponse is {}", this.moved);
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        @Override
        protected void processException(ReplyException ex) {
            logger.debug("MoveBucketMessage ignoring exception: {}", ex.getMessage(), ex);
        }

        public boolean waitForResponse() {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    String msg = "MoveBucketMessage got remote cancellation,";
                    logger.debug(msg, t);
                    return false;
                }
                if (t instanceof PRLocallyDestroyedException) {
                    String msg = "MoveBucketMessage got local destroy on the PartitionRegion ";
                    logger.debug(msg, t);
                    return false;
                }
                if (t instanceof ForceReattemptException) {
                    String msg = "MoveBucketMessage got ForceReattemptException due to local destroy on the PartitionRegion";
                    logger.debug(msg, t);
                    return false;
                }
                e.handleAsUnexpected();
            }
            return this.moved;
        }
    }

    public static final class MoveBucketReplyMessage
    extends ReplyMessage {
        private boolean moved;

        public MoveBucketReplyMessage() {
        }

        public MoveBucketReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private MoveBucketReplyMessage(int processorId, ReplyException re, boolean moved) {
            this.processorId = processorId;
            this.moved = moved;
            this.setException(re);
        }

        public static void send(InternalDistributedMember recipient, int processorId, DM dm, ReplyException re, boolean moved) {
            Assert.assertTrue(recipient != null, "MoveBucketReplyMessage NULL recipient");
            MoveBucketReplyMessage m = new MoveBucketReplyMessage(processorId, re, moved);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        boolean moved() {
            return this.moved;
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "MoveBucketReplyMessage process invoking reply processor with processorId: {}", this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "MoveBucketReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.moved);
        }

        @Override
        public int getDSFID() {
            return 137;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.moved = in.readBoolean();
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("MoveBucketReplyMessage ").append("processorid=").append(this.processorId).append(" moved=").append(this.moved).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }
    }
}

