/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.SerializationVersions;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessageWithDirectReply;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientTombstoneMessage;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class PRTombstoneMessage
extends PartitionMessageWithDirectReply
implements SerializationVersions {
    private static final Logger logger = LogService.getLogger();
    private static Version[] serializationVersions = new Version[]{Version.GFE_80};
    private Set<Object> keys;
    private EventID eventID;

    public PRTombstoneMessage() {
    }

    public static void send(BucketRegion r, Set<Object> keys, EventID eventID) {
        Set recipients = r.getPartitionedRegion().getRegionAdvisor().adviseAllPRNodes();
        recipients.removeAll(r.getDistributionAdvisor().adviseReplicates());
        if (recipients.size() == 0) {
            return;
        }
        Response p = new Response(r.getSystem(), recipients);
        PRTombstoneMessage m = new PRTombstoneMessage(recipients, r.getPartitionedRegion().getPRId(), p, keys, eventID);
        r.getDistributionManager().putOutgoing(m);
        try {
            p.waitForCacheException();
        }
        catch (ForceReattemptException e) {
            throw new InternalGemFireError("unexpected ForceReattemptException", e);
        }
    }

    private PRTombstoneMessage(Set<InternalDistributedMember> recipients, int regionId, PartitionMessage.PartitionResponse p, Set<Object> reapedKeys, EventID eventID) {
        super(recipients, regionId, (DirectReplyProcessor)p);
        this.keys = reapedKeys;
        this.eventID = eventID;
    }

    @Override
    protected final boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) throws ForceReattemptException {
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.debug("PRTombstoneMessage operateOnRegion: {}", r.getFullPath());
        }
        FilterProfile fp = r.getFilterProfile();
        if (this.keys != null && this.keys.size() > 0 && fp != null && CacheClientNotifier.getInstance() != null && this.eventID != null) {
            RegionEventImpl regionEvent = new RegionEventImpl(r, Operation.REGION_DESTROY, null, true, r.getGemFireCache().getMyId());
            regionEvent.setLocalFilterInfo(fp.getLocalFilterRouting(regionEvent));
            ClientTombstoneMessage clientMessage = ClientTombstoneMessage.gc((LocalRegion)r, this.keys, this.eventID);
            CacheClientNotifier.notifyClients(regionEvent, clientMessage);
        }
        return true;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; keys=").append(this.keys.size());
        buff.append("; eventID=").append(this.eventID);
    }

    @Override
    public int getDSFID() {
        return 157;
    }

    @Override
    public Version[] getSerializationVersions() {
        return serializationVersions;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.fromDataPre_GFE_8_0_0_0(in);
        this.eventID = (EventID)DataSerializer.readObject(in);
    }

    public void fromDataPre_GFE_8_0_0_0(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        int numKeys = in.readInt();
        this.keys = new HashSet<Object>(numKeys);
        for (int i = 0; i < numKeys; ++i) {
            this.keys.add(DataSerializer.readObject(in));
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        this.toDataPre_GFE_8_0_0_0(out);
        DataSerializer.writeObject(this.eventID, out);
    }

    public void toDataPre_GFE_8_0_0_0(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.keys.size());
        for (Object key2 : this.keys) {
            DataSerializer.writeObject(key2, out);
        }
    }

    private static class Response
    extends PartitionMessage.PartitionResponse {
        public Response(InternalDistributedSystem ds, Set recipients) {
            super(ds, recipients, false);
        }

        @Override
        public void process(DistributionMessage msg) {
            Throwable cause;
            ReplyMessage reply = (ReplyMessage)msg;
            if (reply.getException() != null && ((cause = reply.getException().getCause()) instanceof ForceReattemptException || cause instanceof CancelException)) {
                reply.setException(null);
            }
            super.process(reply);
        }
    }
}

