/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.partitioned.InternalPartitionDetails;
import com.gemstone.gemfire.internal.cache.partitioned.PRLoad;
import java.io.Serializable;

public class PartitionMemberInfoImpl
implements InternalPartitionDetails,
Serializable {
    private static final long serialVersionUID = 8245020687604034289L;
    private final DistributedMember distributedMember;
    private final long configuredMaxMemory;
    private final long size;
    private final int bucketCount;
    private final int primaryCount;
    private final transient PRLoad prLoad;
    private final transient long[] bucketSizes;

    public PartitionMemberInfoImpl(DistributedMember distributedMember, long configuredMaxMemory, long size2, int bucketCount, int primaryCount) {
        this.distributedMember = distributedMember;
        this.configuredMaxMemory = configuredMaxMemory;
        this.size = size2;
        this.bucketCount = bucketCount;
        this.primaryCount = primaryCount;
        this.prLoad = null;
        this.bucketSizes = null;
    }

    public PartitionMemberInfoImpl(DistributedMember distributedMember, long configuredMaxMemory, long size2, int bucketCount, int primaryCount, PRLoad prLoad, long[] bucketSizes) {
        this.distributedMember = distributedMember;
        this.configuredMaxMemory = configuredMaxMemory;
        this.size = size2;
        this.bucketCount = bucketCount;
        this.primaryCount = primaryCount;
        this.prLoad = prLoad;
        this.bucketSizes = bucketSizes;
    }

    @Override
    public int getBucketCount() {
        return this.bucketCount;
    }

    @Override
    public long getConfiguredMaxMemory() {
        return this.configuredMaxMemory;
    }

    @Override
    public DistributedMember getDistributedMember() {
        return this.distributedMember;
    }

    @Override
    public int getPrimaryCount() {
        return this.primaryCount;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public PRLoad getPRLoad() {
        return this.prLoad;
    }

    @Override
    public long getBucketSize(int bucketId) {
        if (this.bucketSizes == null) {
            throw new IllegalStateException(this + " has no bucketSizes");
        }
        if (bucketId < 0 || bucketId > this.bucketSizes.length) {
            throw new IllegalArgumentException("bucketId must be between 0 and " + this.bucketSizes.length);
        }
        return this.bucketSizes[bucketId];
    }

    public long[] getBucketSizes() {
        return this.bucketSizes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[PartitionMemberInfoImpl: ");
        sb.append("distributedMember=").append(this.distributedMember);
        sb.append(", configuredMaxMemory=").append(this.configuredMaxMemory);
        sb.append(", size=").append(this.size);
        sb.append(", bucketCount=").append(this.bucketCount);
        sb.append(", primaryCount=").append(this.primaryCount);
        if (this.prLoad != null) {
            sb.append(", prLoad=").append(this.prLoad);
            sb.append(", bucketSizes=[");
            if (this.bucketSizes == null) {
                sb.append("null");
            } else {
                for (int i = 0; i < this.bucketSizes.length; ++i) {
                    sb.append(this.bucketSizes[i]).append(", ");
                }
                sb.append("]");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        return this.distributedMember.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof PartitionMemberInfoImpl)) {
            return false;
        }
        PartitionMemberInfoImpl o = (PartitionMemberInfoImpl)other;
        return this.distributedMember.equals(o.distributedMember);
    }

    @Override
    public int compareTo(InternalPartitionDetails other) {
        return this.distributedMember.compareTo(other.getDistributedMember());
    }
}

