/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.DirectReplyMessage;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public abstract class PartitionMessageWithDirectReply
extends PartitionMessage
implements DirectReplyMessage {
    protected DirectReplyProcessor processor;
    protected boolean posDup = false;

    public PartitionMessageWithDirectReply() {
    }

    public PartitionMessageWithDirectReply(Collection<InternalDistributedMember> recipients, int regionId, DirectReplyProcessor processor) {
        super(recipients, regionId, (ReplyProcessor21)processor);
        this.processor = processor;
        this.posDup = false;
    }

    public PartitionMessageWithDirectReply(Set recipients, int regionId, DirectReplyProcessor processor, EntryEventImpl event) {
        super(recipients, regionId, (ReplyProcessor21)processor);
        this.processor = processor;
        this.posDup = event.isPossibleDuplicate();
    }

    public PartitionMessageWithDirectReply(InternalDistributedMember recipient, int regionId, DirectReplyProcessor processor) {
        super(recipient, regionId, (ReplyProcessor21)processor);
        this.processor = processor;
    }

    public PartitionMessageWithDirectReply(PartitionMessageWithDirectReply original, EntryEventImpl event) {
        super(original);
        this.processor = original.processor;
        this.posDup = event != null ? event.isPossibleDuplicate() : original.posDup;
    }

    @Override
    public boolean supportsDirectAck() {
        return true;
    }

    @Override
    public DirectReplyProcessor getDirectReplyProcessor() {
        return this.processor;
    }

    @Override
    public void registerProcessor() {
        this.processorId = this.processor.register();
    }

    @Override
    public Set relayToListeners(Set cacheOpRecipients, Set adjunctRecipients, FilterRoutingInfo filterRoutingInfo, EntryEventImpl event, PartitionedRegion r, DirectReplyProcessor p) {
        this.processor = p;
        return super.relayToListeners(cacheOpRecipients, adjunctRecipients, filterRoutingInfo, event, r, p);
    }

    @Override
    protected short computeCompressedShort(short s) {
        s = super.computeCompressedShort(s);
        if (this.posDup) {
            s = (short)(s | 8);
        }
        return s;
    }

    @Override
    protected void setBooleans(short s, DataInput in) throws IOException, ClassNotFoundException {
        super.setBooleans(s, in);
        if ((s & 8) != 0) {
            this.posDup = true;
        }
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; posDup=").append(this.posDup);
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }
}

