/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.DataLocationException;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.PutAllPartialResultException;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessageWithDirectReply;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.versions.ConcurrentCacheModificationException;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class PutAllPRMessage
extends PartitionMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private DistributedPutAllOperation.PutAllEntryData[] putAllPRData;
    private int putAllPRDataSize = 0;
    private Integer bucketId;
    ClientProxyMembershipID bridgeContext;
    private boolean skipCallbacks;
    private Object callbackArg;
    protected static final short HAS_BRIDGE_CONTEXT = 4096;
    protected static final short SKIP_CALLBACKS = 8192;
    private transient InternalDistributedSystem internalDs;
    private transient boolean directAck = false;
    transient boolean result = false;
    transient VersionedObjectList versions = null;

    public PutAllPRMessage() {
    }

    public PutAllPRMessage(int bucketId, int size2, boolean notificationOnly, boolean posDup, boolean skipCallbacks, Object callbackArg) {
        this.bucketId = bucketId;
        this.putAllPRData = new DistributedPutAllOperation.PutAllEntryData[size2];
        this.notificationOnly = notificationOnly;
        this.posDup = posDup;
        this.skipCallbacks = skipCallbacks;
        this.callbackArg = callbackArg;
        this.initTxMemberId();
    }

    public void addEntry(DistributedPutAllOperation.PutAllEntryData entry) {
        this.putAllPRData[this.putAllPRDataSize++] = entry;
    }

    public void initMessage(PartitionedRegion r, Set recipients, boolean notifyOnly, DirectReplyProcessor p) {
        this.setInternalDs(r.getSystem());
        this.setDirectAck(false);
        this.resetRecipients();
        if (recipients != null) {
            this.setRecipients(recipients);
        }
        this.regionId = r.getPRId();
        this.processor = p;
        int n = this.processorId = p == null ? 0 : p.getProcessorId();
        if (p != null && this.isSevereAlertCompatible()) {
            p.enableSevereAlertProcessing();
        }
        this.notificationOnly = notifyOnly;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    public void setPossibleDuplicate(boolean posDup) {
        this.posDup = posDup;
    }

    public int getSize() {
        return this.putAllPRDataSize;
    }

    public Set getKeys() {
        HashSet<Object> keys = new HashSet<Object>(this.getSize());
        for (int i = 0; i < this.putAllPRData.length; ++i) {
            if (this.putAllPRData[i] == null) continue;
            keys.add(this.putAllPRData[i].getKey());
        }
        return keys;
    }

    public PartitionMessage.PartitionResponse send(DistributedMember recipient, PartitionedRegion r) throws ForceReattemptException {
        Set failures;
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        PutAllResponse p = new PutAllResponse(r.getSystem(), recipients);
        this.initMessage(r, recipients, false, p);
        if (logger.isDebugEnabled()) {
            logger.debug("PutAllPRMessage.send: recipient is {}, msg is {}", recipient, this);
        }
        if ((failures = r.getDistributionManager().putOutgoing(this)) != null && failures.size() > 0) {
            throw new ForceReattemptException("Failed sending <" + this + ">");
        }
        return p;
    }

    public void setBridgeContext(ClientProxyMembershipID contx) {
        Assert.assertTrue(contx != null);
        this.bridgeContext = contx;
    }

    @Override
    public int getDSFID() {
        return -109;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        Version sourceVersion;
        super.fromData(in);
        this.bucketId = (int)InternalDataSerializer.readSignedVL(in);
        if ((this.flags & 0x1000) != 0) {
            this.bridgeContext = (ClientProxyMembershipID)DataSerializer.readObject(in);
        }
        if ((sourceVersion = InternalDataSerializer.getVersionForDataStream(in)).compareTo(Version.GFE_81) >= 0) {
            this.callbackArg = DataSerializer.readObject(in);
        }
        this.putAllPRDataSize = (int)InternalDataSerializer.readUnsignedVL(in);
        this.putAllPRData = new DistributedPutAllOperation.PutAllEntryData[this.putAllPRDataSize];
        if (this.putAllPRDataSize > 0) {
            Version version = InternalDataSerializer.getVersionForDataStreamOrNull(in);
            ByteArrayDataInput bytesIn = new ByteArrayDataInput();
            for (int i = 0; i < this.putAllPRDataSize; ++i) {
                this.putAllPRData[i] = new DistributedPutAllOperation.PutAllEntryData(in, null, i, version, bytesIn);
            }
            boolean hasTags = in.readBoolean();
            if (hasTags) {
                DistributedPutAllOperation.EntryVersionsList versionTags = DistributedPutAllOperation.EntryVersionsList.create(in);
                for (int i = 0; i < this.putAllPRDataSize; ++i) {
                    this.putAllPRData[i].versionTag = (VersionTag)versionTags.get(i);
                }
            }
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        Version receiverVersion;
        super.toData(out);
        if (this.bucketId == null) {
            InternalDataSerializer.writeSignedVL(-1L, out);
        } else {
            InternalDataSerializer.writeSignedVL(this.bucketId.intValue(), out);
        }
        if (this.bridgeContext != null) {
            DataSerializer.writeObject(this.bridgeContext, out);
        }
        if ((receiverVersion = InternalDataSerializer.getVersionForDataStream(out)).compareTo(Version.GFE_81) >= 0) {
            DataSerializer.writeObject(this.callbackArg, out);
        }
        InternalDataSerializer.writeUnsignedVL(this.putAllPRDataSize, out);
        if (this.putAllPRDataSize > 0) {
            DistributedPutAllOperation.EntryVersionsList versionTags = new DistributedPutAllOperation.EntryVersionsList(this.putAllPRDataSize);
            boolean hasTags = false;
            boolean requiresRegionContext = this.putAllPRData[0].getKey() instanceof KeyWithRegionContext;
            for (int i = 0; i < this.putAllPRDataSize; ++i) {
                if (!hasTags && this.putAllPRData[i].versionTag != null) {
                    hasTags = true;
                }
                VersionTag tag = this.putAllPRData[i].versionTag;
                versionTags.add(tag);
                this.putAllPRData[i].versionTag = null;
                this.putAllPRData[i].toData(out, requiresRegionContext);
                this.putAllPRData[i].versionTag = tag;
            }
            out.writeBoolean(hasTags);
            if (hasTags) {
                InternalDataSerializer.invokeToData(versionTags, out);
            }
        }
    }

    @Override
    protected short computeCompressedShort(short s) {
        s = super.computeCompressedShort(s);
        if (this.bridgeContext != null) {
            s = (short)(s | 0x1000);
        }
        if (this.skipCallbacks) {
            s = (short)(s | 0x2000);
        }
        return s;
    }

    @Override
    protected void setBooleans(short s, DataInput in) throws IOException, ClassNotFoundException {
        super.setBooleans(s, in);
        this.skipCallbacks = (s & 0x2000) != 0;
    }

    @Override
    public EventID getEventID() {
        if (this.putAllPRData.length > 0) {
            return this.putAllPRData[0].getEventID();
        }
        return null;
    }

    @Override
    protected final boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) throws EntryExistsException, ForceReattemptException, DataLocationException {
        boolean sendReply = true;
        InternalDistributedMember eventSender = this.getSender();
        long lastModified = 0L;
        try {
            this.result = this.doLocalPutAll(r, eventSender, lastModified);
        }
        catch (ForceReattemptException fre) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(fre), r, startTime);
            return false;
        }
        if (sendReply) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, null, r, startTime);
        }
        return false;
    }

    public EntryEventImpl getFirstEvent(PartitionedRegion r) {
        if (this.putAllPRDataSize == 0) {
            return null;
        }
        EntryEventImpl ev = new EntryEventImpl((LocalRegion)r, this.putAllPRData[0].getOp(), this.putAllPRData[0].getKey(), this.putAllPRData[0].getValue(), this.callbackArg, false, (DistributedMember)this.getSender(), true, this.putAllPRData[0].getEventID());
        return ev;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressWarnings(value={"IMSE_DONT_CATCH_IMSE"})
    public final boolean doLocalPutAll(PartitionedRegion r, InternalDistributedMember eventSender, long lastModified) throws EntryExistsException, ForceReattemptException, DataLocationException {
        int i;
        boolean didPut = false;
        long clientReadTimeOut = 10000L;
        if (r.hasServerProxy()) {
            clientReadTimeOut = r.getServerProxy().getPool().getReadTimeout();
            if (logger.isDebugEnabled()) {
                logger.debug("PutAllPRMessage: doLocalPutAll: clientReadTimeOut is {}", clientReadTimeOut);
            }
        }
        DistributedPutAllOperation dpao = null;
        EntryEventImpl baseEvent = null;
        BucketRegion bucketRegion = null;
        PartitionedRegionDataStore ds = r.getDataStore();
        InternalDistributedMember myId = r.getDistributionManager().getDistributionManagerId();
        if (!this.notificationOnly) {
            bucketRegion = ds.getInitializedBucketForId(null, this.bucketId);
            this.versions = new VersionedObjectList(this.putAllPRDataSize, true, bucketRegion.getAttributes().getConcurrencyChecksEnabled());
            baseEvent = new EntryEventImpl((LocalRegion)bucketRegion, Operation.PUTALL_CREATE, null, null, this.callbackArg, true, (DistributedMember)eventSender, !this.skipCallbacks, true);
            baseEvent.setEventId(this.putAllPRData[0].getEventID());
            if (this.bridgeContext != null) {
                baseEvent.setContext(this.bridgeContext);
            }
            baseEvent.setPossibleDuplicate(this.posDup);
            if (logger.isDebugEnabled()) {
                logger.debug("PutAllPRMessage.doLocalPutAll: eventSender is {}, baseEvent is {}, msg is {}", eventSender, baseEvent, this);
            }
            dpao = new DistributedPutAllOperation(baseEvent, this.putAllPRDataSize, false);
        }
        Object[] keys = new Object[this.putAllPRDataSize];
        boolean keyRequiresRegionContext = r.keyRequiresRegionContext();
        for (i = 0; i < this.putAllPRDataSize; ++i) {
            keys[i] = this.putAllPRData[i].getKey();
            if (!keyRequiresRegionContext) continue;
            ((KeyWithRegionContext)keys[i]).setRegionContext(r);
        }
        if (!this.notificationOnly) {
            try {
                if (this.putAllPRData.length > 0) {
                    if (this.posDup && bucketRegion.getConcurrencyChecksEnabled()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("attempting to locate version tags for retried event");
                        }
                        for (i = 0; i < this.putAllPRDataSize; ++i) {
                            if (this.putAllPRData[i].versionTag != null) continue;
                            this.putAllPRData[i].versionTag = bucketRegion.findVersionTagForClientBulkOp(this.putAllPRData[i].getEventID());
                            if (this.putAllPRData[i].versionTag == null) continue;
                            this.putAllPRData[i].versionTag.replaceNullIDs(bucketRegion.getVersionMember());
                        }
                    }
                    EventID eventID = this.putAllPRData[0].getEventID();
                    ThreadIdentifier membershipID = new ThreadIdentifier(eventID.getMembershipID(), eventID.getThreadID());
                    bucketRegion.recordBulkOpStart(membershipID);
                }
                bucketRegion.waitUntilLocked(keys);
                boolean lockedForPrimary = false;
                HashMap<Object, Object> succeeded = new HashMap<Object, Object>();
                PutAllPartialResultException.PutAllPartialResult partialKeys = new PutAllPartialResultException.PutAllPartialResult(this.putAllPRDataSize);
                Object key2 = keys[0];
                try {
                    bucketRegion.doLockForPrimary(false);
                    lockedForPrimary = true;
                    for (int i2 = 0; i2 < this.putAllPRDataSize; ++i2) {
                        EntryEventImpl ev;
                        block37: {
                            ev = PutAllPRMessage.getEventFromEntry(r, myId, eventSender, i2, this.putAllPRData, this.notificationOnly, this.bridgeContext, this.posDup, this.skipCallbacks);
                            key2 = ev.getKey();
                            ev.setPutAllOperation(dpao);
                            ev.makeSerializedNewValue();
                            try {
                                didPut = r.getDataView().putEntryOnRemote(ev, false, false, null, false, lastModified, true);
                                if (didPut && logger.isDebugEnabled()) {
                                    logger.debug("PutAllPRMessage.doLocalPutAll:putLocally success for {}", ev);
                                }
                            }
                            catch (ConcurrentCacheModificationException e) {
                                didPut = true;
                                if (!logger.isDebugEnabled()) break block37;
                                logger.debug("PutAllPRMessage.doLocalPutAll:putLocally encountered concurrent cache modification for {}", ev, e);
                            }
                        }
                        this.putAllPRData[i2].setTailKey(ev.getTailKey());
                        if (!didPut) {
                            r.checkReadiness();
                            ForceReattemptException fre = new ForceReattemptException("unable to perform put in PutAllPR, but operation should not fail");
                            fre.setHash(ev.getKey().hashCode());
                            throw fre;
                        }
                        succeeded.put(this.putAllPRData[i2].getKey(), this.putAllPRData[i2].getValue());
                        this.versions.addKeyAndVersion(this.putAllPRData[i2].getKey(), ev.getVersionTag());
                    }
                }
                catch (IllegalMonitorStateException ex) {
                    ForceReattemptException fre = new ForceReattemptException("unable to get lock for primary, retrying... ");
                    throw fre;
                }
                catch (CacheWriterException cwe) {
                    partialKeys.saveFailedKey(key2, cwe);
                }
                finally {
                    try {
                        dpao.setUseFakeEventId(true);
                        r.checkReadiness();
                        bucketRegion.getDataView().postPutAll(dpao, this.versions, bucketRegion);
                    }
                    finally {
                        if (lockedForPrimary) {
                            bucketRegion.doUnlockForPrimary();
                        }
                    }
                }
                if (!partialKeys.hasFailure()) return true;
                partialKeys.addKeysAndVersions(this.versions);
                if (!logger.isDebugEnabled()) throw new PutAllPartialResultException(partialKeys);
                logger.debug("PutAllPRMessage: partial keys applied, map to bucket {}'s keys: {}. Applied {}", this.bucketId, Arrays.toString(keys), succeeded);
                throw new PutAllPartialResultException(partialKeys);
            }
            catch (RegionDestroyedException e) {
                ds.checkRegionDestroyedOnBucket(bucketRegion, true, e);
                return true;
            }
            finally {
                bucketRegion.removeAndNotifyKeys(keys);
            }
        }
        for (i = 0; i < this.putAllPRDataSize; ++i) {
            EntryEventImpl ev = PutAllPRMessage.getEventFromEntry(r, myId, eventSender, i, this.putAllPRData, this.notificationOnly, this.bridgeContext, this.posDup, this.skipCallbacks);
            ev.setOriginRemote(true);
            if (this.callbackArg != null) {
                ev.setCallbackArgument(this.callbackArg);
            }
            r.invokePutCallbacks(ev.getOperation().isCreate() ? EnumListenerEvent.AFTER_CREATE : EnumListenerEvent.AFTER_UPDATE, ev, r.isInitialized(), true);
        }
        return true;
    }

    public VersionedObjectList getVersions() {
        return this.versions;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    public static EntryEventImpl getEventFromEntry(LocalRegion r, InternalDistributedMember myId, InternalDistributedMember eventSender, int idx, DistributedPutAllOperation.PutAllEntryData[] data, boolean notificationOnly, ClientProxyMembershipID bridgeContext, boolean posDup, boolean skipCallbacks) {
        DistributedPutAllOperation.PutAllEntryData prd = data[idx];
        EntryEventImpl ev = new EntryEventImpl(r, prd.getOp(), prd.getKey(), prd.getValue(), null, false, (DistributedMember)eventSender, !skipCallbacks, prd.getEventID());
        if (prd.getValue() == null && ev.getRegion().getAttributes().getDataPolicy() == DataPolicy.NORMAL) {
            ev.setLocalInvalid(true);
        }
        ev.setNewValue(prd.getValue());
        ev.setOldValue(prd.getOldValue());
        if (bridgeContext != null) {
            ev.setContext(bridgeContext);
        }
        ev.setInvokePRCallbacks(!notificationOnly);
        ev.setPossibleDuplicate(posDup);
        if (prd.filterRouting != null) {
            ev.setLocalFilterInfo(prd.filterRouting.getFilterInfo(myId));
        }
        if (prd.versionTag != null) {
            prd.versionTag.replaceNullIDs(eventSender);
            ev.setVersionTag(prd.versionTag);
        }
        if (notificationOnly) {
            ev.setTailKey(-1L);
        } else {
            ev.setTailKey(prd.getTailKey());
        }
        return ev;
    }

    PartitionMessage.PartitionResponse createReplyProcessor(PartitionedRegion r, Set recipients, Object key2) {
        return new PutAllResponse(r.getSystem(), recipients);
    }

    @Override
    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, PartitionedRegion pr2, long startTime) {
        if (pr2 != null) {
            if (startTime > 0L) {
                pr2.getPrStats().endPartitionMessagesProcessing(startTime);
            }
            if (!pr2.getConcurrencyChecksEnabled() && this.versions != null) {
                this.versions.clear();
            }
        }
        PutAllReplyMessage.send(member, procId, this.getReplySender(dm), this.result, this.versions, ex);
    }

    @Override
    protected final void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; putAllPRDataSize=").append(this.putAllPRDataSize).append("; bucketId=").append(this.bucketId);
        if (this.bridgeContext != null) {
            buff.append("; bridgeContext=").append(this.bridgeContext);
        }
        buff.append("; directAck=").append(this.directAck);
        for (int i = 0; i < this.putAllPRDataSize; ++i) {
            buff.append("; entry" + i + ":").append(this.putAllPRData[i].getKey()).append(",").append(this.putAllPRData[i].versionTag);
        }
    }

    public final InternalDistributedSystem getInternalDs() {
        return this.internalDs;
    }

    public final void setInternalDs(InternalDistributedSystem internalDs) {
        this.internalDs = internalDs;
    }

    public final void setDirectAck(boolean directAck) {
        this.directAck = directAck;
    }

    public static class PutAllResult {
        public boolean returnValue;
        public VersionedObjectList versions;

        public PutAllResult(boolean flag, VersionedObjectList versions) {
            this.returnValue = flag;
            this.versions = versions;
        }

        public String toString() {
            return "PutAllResult(" + this.returnValue + ", " + this.versions + ")";
        }
    }

    public static class PutAllResponse
    extends PartitionMessage.PartitionResponse {
        private volatile boolean returnValue;
        private VersionedObjectList versions;

        public PutAllResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, recipients, false);
        }

        public void setResponse(PutAllReplyMessage response) {
            this.returnValue = response.result;
            if (response.versions != null) {
                this.versions = response.versions;
                this.versions.replaceNullIDs(response.getSender());
            }
        }

        public PutAllResult waitForResult() throws CacheException, ForceReattemptException {
            this.waitForCacheException();
            return new PutAllResult(this.returnValue, this.versions);
        }
    }

    public static final class PutAllReplyMessage
    extends ReplyMessage {
        boolean result;
        VersionedObjectList versions;

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public PutAllReplyMessage() {
        }

        private PutAllReplyMessage(int processorId, boolean result, VersionedObjectList versions, ReplyException ex) {
            this.versions = versions;
            this.result = result;
            this.setProcessorId(processorId);
            this.setException(ex);
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender dm, boolean result, VersionedObjectList versions, ReplyException ex) {
            Assert.assertTrue(recipient != null, "PutAllReplyMessage NULL reply message");
            PutAllReplyMessage m = new PutAllReplyMessage(processorId, result, versions, ex);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "{}: processor not found", this);
                }
                return;
            }
            if (rp instanceof PutAllResponse) {
                PutAllResponse processor = (PutAllResponse)rp;
                processor.setResponse(this);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", rp, this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -110;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.result = in.readBoolean();
            this.versions = (VersionedObjectList)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.result);
            DataSerializer.writeObject(this.versions, out);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("PutAllReplyMessage ").append("processorid=").append(this.processorId).append(" returning ").append(this.result).append(" exception=").append(this.getException()).append(" versions= ").append(this.versions);
            return sb.toString();
        }
    }
}

