/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.PRHARedundancyProvider;
import com.gemstone.gemfire.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public abstract class RecoveryRunnable
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    protected final PRHARedundancyProvider redundancyProvider;
    private volatile Throwable failure;

    public RecoveryRunnable(PRHARedundancyProvider prhaRedundancyProvider) {
        this.redundancyProvider = prhaRedundancyProvider;
    }

    public abstract void run2();

    public void checkFailure() {
        if (this.failure != null) {
            if (this.failure instanceof RuntimeException) {
                throw (RuntimeException)this.failure;
            }
            throw new InternalGemFireError("Failure during bucket recovery ", this.failure);
        }
    }

    @Override
    public void run() {
        CancelCriterion stopper = this.redundancyProvider.prRegion.getGemFireCache().getDistributedSystem().getCancelCriterion();
        DistributedSystem.setThreadsSocketPolicy(true);
        SystemFailure.checkFailure();
        if (stopper.cancelInProgress() != null) {
            return;
        }
        try {
            this.run2();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (logger.isDebugEnabled()) {
                logger.debug("Unexpected exception in PR redundancy recovery", t);
            }
            this.failure = t;
        }
    }
}

