/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gnu.trove.TObjectIntProcedure;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class RemoteFetchKeysMessage
extends RemoteOperationMessage {
    private static final Logger logger = LogService.getLogger();

    public RemoteFetchKeysMessage() {
    }

    private RemoteFetchKeysMessage(InternalDistributedMember recipient, String regionPath, ReplyProcessor21 processor) {
        super(recipient, regionPath, processor);
    }

    @Override
    protected boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        block3: {
            if (!(r instanceof PartitionedRegion)) {
                r.waitOnInitialization();
            }
            Set keys = r.keySet();
            try {
                RemoteFetchKeysReplyMessage.send(this.getSender(), this.processorId, dm, keys);
            }
            catch (ForceReattemptException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Caught exception while sending keys: {}", e.getMessage(), e);
            }
        }
        return false;
    }

    @Override
    public int getDSFID() {
        return -37;
    }

    public static FetchKeysResponse send(LocalRegion currRegion, DistributedMember target) {
        FetchKeysResponse response = new FetchKeysResponse(currRegion.getSystem(), currRegion, (InternalDistributedMember)target);
        RemoteFetchKeysMessage msg = new RemoteFetchKeysMessage((InternalDistributedMember)target, currRegion.getFullPath(), (ReplyProcessor21)response);
        currRegion.getSystem().getDistributionManager().putOutgoing(msg);
        return response;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
    }

    public static class FetchKeysResponse
    extends ReplyProcessor21 {
        private final LocalRegion region;
        private final Set returnValue;
        private final Object endLock = new Object();
        private volatile int chunksProcessed;
        private volatile int chunksExpected;
        private volatile boolean lastChunkReceived;

        public FetchKeysResponse(InternalDistributedSystem system, LocalRegion region, InternalDistributedMember member) {
            super(system, member);
            this.region = region;
            this.returnValue = new HashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            boolean doneProcessing = false;
            try {
                RemoteFetchKeysReplyMessage fkrm;
                doneProcessing = msg instanceof RemoteFetchKeysReplyMessage ? ((fkrm = (RemoteFetchKeysReplyMessage)msg).getException() != null ? true : this.processChunk((RemoteFetchKeysReplyMessage)msg)) : true;
            }
            finally {
                if (doneProcessing) {
                    super.process(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean processChunk(RemoteFetchKeysReplyMessage msg) {
            boolean doneProcessing = false;
            try {
                ByteArrayInputStream byteStream = new ByteArrayInputStream(msg.chunk);
                DataInputStream in = new DataInputStream(byteStream);
                boolean requiresRegionContext = this.region.keyRequiresRegionContext();
                while (in.available() > 0) {
                    Object key2 = DataSerializer.readObject(in);
                    if (key2 != null) {
                        if (requiresRegionContext) {
                            ((KeyWithRegionContext)key2).setRegionContext(this.region);
                        }
                        Set set = this.returnValue;
                        synchronized (set) {
                            this.returnValue.add(key2);
                            continue;
                        }
                    }
                    Assert.assertTrue(in.available() == 0);
                }
                Object object = this.endLock;
                synchronized (object) {
                    ++this.chunksProcessed;
                    if (msg.seriesNum + 1 == msg.numSeries && msg.lastInSeries) {
                        this.lastChunkReceived = true;
                        this.chunksExpected = msg.msgNum + 1;
                    }
                    if (this.lastChunkReceived && this.chunksExpected == this.chunksProcessed) {
                        doneProcessing = true;
                    }
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "{} chunksProcessed={},lastChunkReceived={},chunksExpected={},done={}", this, this.chunksProcessed, this.lastChunkReceived, this.chunksExpected, doneProcessing);
                    }
                }
            }
            catch (Exception e) {
                this.processException(new ReplyException(LocalizedStrings.FetchKeysMessage_ERROR_DESERIALIZING_KEYS.toLocalizedString(), e));
            }
            return doneProcessing;
        }

        public Set waitForKeys() {
            block5: {
                try {
                    this.waitForRepliesUninterruptibly();
                }
                catch (ReplyException e) {
                    Throwable t = e.getCause();
                    if (t instanceof CancelException) {
                        logger.debug("RemoteFetchKeysResponse got remote CacheClosedException; forcing reattempt. {}", t.getMessage(), t);
                    }
                    if (t instanceof ForceReattemptException) {
                        logger.debug("RemoteFetchKeysResponse got remote ForceReattemptException; rethrowing. {}", e.getMessage(), e);
                    }
                    if (t instanceof RegionDestroyedException) {
                        RegionDestroyedException rde = (RegionDestroyedException)t;
                        throw rde;
                    }
                    e.handleAsUnexpected();
                    if (this.lastChunkReceived) break block5;
                    throw new TransactionException(e);
                }
            }
            return Collections.unmodifiableSet(this.returnValue);
        }
    }

    public static class RemoteFetchKeysReplyMessage
    extends ReplyMessage {
        int seriesNum;
        int msgNum;
        int numSeries;
        boolean lastInSeries;
        transient HeapDataOutputStream chunkStream;
        transient byte[] chunk;

        public RemoteFetchKeysReplyMessage() {
        }

        private RemoteFetchKeysReplyMessage(InternalDistributedMember recipient, int processorId, HeapDataOutputStream chunk, int seriesNum, int msgNum, int numSeries, boolean lastInSeries) {
            this.setRecipient(recipient);
            this.setProcessorId(processorId);
            this.seriesNum = seriesNum;
            this.msgNum = msgNum;
            this.numSeries = numSeries;
            this.lastInSeries = lastInSeries;
            this.chunkStream = chunk;
        }

        public static void send(final InternalDistributedMember recipient, final int processorId, final DM dm, Set keys) throws ForceReattemptException {
            Assert.assertTrue(recipient != null, "FetchKeysReplyMessage NULL reply message");
            boolean numSeries = true;
            boolean seriesNum = false;
            if (logger.isDebugEnabled()) {
                logger.debug("Starting pr keys chunking for {} keys to member {}", keys.size(), recipient);
            }
            try {
                boolean finished = RemoteFetchKeysReplyMessage.chunkSet(recipient, keys, InitialImageOperation.CHUNK_SIZE_IN_BYTES, false, new TObjectIntProcedure(){
                    int msgNum = 0;
                    boolean last = false;

                    @Override
                    public boolean execute(Object a, int b) {
                        HeapDataOutputStream chunk = (HeapDataOutputStream)a;
                        this.last = b > 0;
                        try {
                            boolean okay = RemoteFetchKeysReplyMessage.sendChunk(recipient, processorId, dm, chunk, 0, this.msgNum++, 1, this.last);
                            return okay;
                        }
                        catch (CancelException e) {
                            return false;
                        }
                    }
                });
                if (logger.isDebugEnabled()) {
                    logger.debug("{} pr keys chunking", finished ? "Finished" : "DID NOT complete");
                }
            }
            catch (IOException io) {
                throw new ForceReattemptException(LocalizedStrings.FetchKeysMessage_UNABLE_TO_SEND_RESPONSE_TO_FETCH_KEYS_REQUEST.toLocalizedString(), io);
            }
        }

        static boolean sendChunk(InternalDistributedMember recipient, int processorId, DM dm, HeapDataOutputStream chunk, int seriesNum, int msgNum, int numSeries, boolean lastInSeries) {
            RemoteFetchKeysReplyMessage reply = new RemoteFetchKeysReplyMessage(recipient, processorId, chunk, seriesNum, msgNum, numSeries, lastInSeries);
            Set failures = dm.putOutgoing(reply);
            return failures == null || failures.size() == 0;
        }

        static boolean chunkSet(InternalDistributedMember recipient, Set set, int CHUNK_SIZE_IN_BYTES, boolean includeValues, TObjectIntProcedure proc) throws IOException {
            Iterator it = set.iterator();
            boolean keepGoing = true;
            boolean sentLastChunk = false;
            HeapDataOutputStream mos = new HeapDataOutputStream(InitialImageOperation.CHUNK_SIZE_IN_BYTES + 2048, recipient.getVersionObject());
            do {
                mos.reset();
                int avgItemSize = 0;
                int itemCount = 0;
                while (mos.size() + avgItemSize < InitialImageOperation.CHUNK_SIZE_IN_BYTES && it.hasNext()) {
                    Object key2 = it.next();
                    DataSerializer.writeObject(key2, mos);
                    avgItemSize = mos.size() / ++itemCount;
                }
                DataSerializer.writeObject(null, mos);
                int lastMsg = it.hasNext() ? 0 : 1;
                keepGoing = proc.execute(mos, lastMsg);
                boolean bl = sentLastChunk = lastMsg == 1 && keepGoing;
            } while (keepGoing && it.hasNext());
            return sentLastChunk;
        }

        @Override
        public void process(DM dm, ReplyProcessor21 p) {
            long startTime = this.getTimestamp();
            FetchKeysResponse processor = (FetchKeysResponse)p;
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "FetchKeysReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} Remote-processed {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.seriesNum);
            out.writeInt(this.msgNum);
            out.writeInt(this.numSeries);
            out.writeBoolean(this.lastInSeries);
            DataSerializer.writeObjectAsByteArray(this.chunkStream, out);
        }

        @Override
        public int getDSFID() {
            return -38;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.seriesNum = in.readInt();
            this.msgNum = in.readInt();
            this.numSeries = in.readInt();
            this.lastInSeries = in.readBoolean();
            this.chunk = DataSerializer.readByteArray(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("RemoteFetchKeysReplyMessage ").append("processorid=").append(this.processorId);
            if (this.getSender() != null) {
                sb.append(",sender=").append(this.getSender());
            }
            sb.append(",seriesNum=").append(this.seriesNum).append(",msgNum=").append(this.msgNum).append(",numSeries=").append(this.numSeries).append(",lastInSeries=").append(this.lastInSeries);
            if (this.chunkStream != null) {
                sb.append(",size=").append(this.chunkStream.size());
            } else if (this.chunk != null) {
                sb.append(",size=").append(this.chunk.length);
            }
            if (this.getException() != null) {
                sb.append(", exception=").append(this.getException());
            }
            return sb.toString();
        }
    }
}

