/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class RemoteSizeMessage
extends RemoteOperationMessage {
    private static final Logger logger = LogService.getLogger();
    public static final int TYPE_ENTRIES = 0;
    public static final int TYPE_VALUES = 1;
    private ArrayList bucketIds;
    private int queryType;

    public RemoteSizeMessage() {
    }

    private RemoteSizeMessage(Set recipients, String regionPath, ReplyProcessor21 processor, int queryType) {
        super(recipients, regionPath, processor);
        this.queryType = queryType;
    }

    public RemoteSizeMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    public static SizeResponse send(Set recipients, LocalRegion r) {
        return RemoteSizeMessage.send(recipients, r, 0);
    }

    public static SizeResponse send(Set recipients, LocalRegion r, int queryType) {
        Assert.assertTrue(recipients != null, "RemoteSizeMessage NULL recipients set");
        SizeResponse p = new SizeResponse(r.getSystem(), recipients);
        RemoteSizeMessage m = new RemoteSizeMessage(recipients, r.getFullPath(), p, queryType);
        r.getDistributionManager().putOutgoing(m);
        return p;
    }

    @Override
    protected final boolean failIfRegionMissing() {
        return false;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return false;
    }

    @Override
    protected boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        int size2 = 0;
        if (r != null) {
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.debug("{} operateOnRegion: {}", this.getClass().getName(), r.getFullPath());
            }
            size2 = r.size();
        }
        SizeReplyMessage.send(this.getSender(), this.getProcessorId(), dm, size2);
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; bucketIds=").append(this.bucketIds);
        if (this.queryType == 0) {
            buff.append("; queryType=TYPE_ENTRIES");
        } else {
            buff.append("; queryType=TYPE_VALUES");
        }
    }

    @Override
    public int getDSFID() {
        return -36;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketIds = DataSerializer.readArrayList(in);
        this.queryType = in.readByte();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeArrayList(this.bucketIds, out);
        out.writeByte((byte)this.queryType);
    }

    public static class SizeResponse
    extends ReplyProcessor21 {
        private int returnValue;

        public SizeResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, (Collection)recipients);
        }

        @Override
        protected void processException(ReplyException ex) {
            logger.debug("SizeResponse ignoring exception: {}", ex.getMessage(), ex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof SizeReplyMessage) {
                    SizeReplyMessage reply = (SizeReplyMessage)msg;
                    this.returnValue = reply.getSize();
                }
            }
            finally {
                super.process(msg);
            }
        }

        public int waitForSize() {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RegionDestroyedException) {
                    RegionDestroyedException rde = (RegionDestroyedException)cause;
                    throw rde;
                }
                throw e;
            }
            return this.returnValue;
        }
    }

    public static final class SizeReplyMessage
    extends ReplyMessage {
        private int size;

        public SizeReplyMessage() {
        }

        private SizeReplyMessage(int processorId, int size2) {
            this.processorId = processorId;
            this.size = size2;
        }

        public SizeReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        public static void send(InternalDistributedMember recipient, int processorId, DM dm, int size2) {
            Assert.assertTrue(recipient != null, "SizeReplyMessage NULL reply message");
            SizeReplyMessage m = new SizeReplyMessage(processorId, size2);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{}: process invoking reply processor with processorId: {}", this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "{} processor not found", this.getClass().getName());
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", this.getClass().getName(), this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.size);
        }

        @Override
        public int getDSFID() {
            return -35;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.size = in.readInt();
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName()).append(" processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender()).append(" returning size=").append(this.getSize());
            return sb.toString();
        }

        public int getSize() {
            return this.size;
        }
    }
}

