/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionException;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.partitioned.RegionAdvisor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class RemoveIndexesMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private String indexName;
    private boolean removeSingleIndex;

    public RemoveIndexesMessage() {
    }

    public RemoveIndexesMessage(Set recipients, int regionId, ReplyProcessor21 processor) {
        super(recipients, regionId, processor);
    }

    public RemoveIndexesMessage(Set recipients, int regionId, ReplyProcessor21 processor, boolean removeSingleIndex, String indexName) {
        super(recipients, regionId, processor);
        this.removeSingleIndex = removeSingleIndex;
        this.indexName = indexName;
    }

    @Override
    protected final boolean failIfRegionMissing() {
        return false;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr2, long startTime) throws CacheException, QueryException, ForceReattemptException, InterruptedException {
        ReplyException replyEx = null;
        boolean result = true;
        int bucketIndexRemoved = 0;
        int numIndexesRemoved = 0;
        logger.info(LocalizedMessage.create(LocalizedStrings.RemoveIndexesMessage_WILL_REMOVE_THE_INDEXES_ON_THIS_PR___0, pr2));
        try {
            bucketIndexRemoved = this.removeSingleIndex ? pr2.removeIndex(this.indexName) : pr2.removeIndexes(true);
            numIndexesRemoved = pr2.getDataStore().getAllLocalBuckets().size();
        }
        catch (Exception ex) {
            result = false;
            replyEx = new ReplyException(ex);
        }
        this.sendReply(this.getSender(), this.getProcessorId(), dm, replyEx, result, bucketIndexRemoved, numIndexesRemoved);
        return false;
    }

    void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, boolean result, int bucketIndexesRemoved, int totalNumBuckets) {
        RemoveIndexesReplyMessage.send(member, this.processorId, dm, ex, result, bucketIndexesRemoved, totalNumBuckets);
    }

    public static PartitionMessage.PartitionResponse send(PartitionedRegion pr2, Index ind, boolean removeAllIndex) {
        RemoveIndexesResponse processor = null;
        RegionAdvisor advisor = (RegionAdvisor)pr2.getDistributionAdvisor();
        HashSet<InternalDistributedMember> recipients = new HashSet<InternalDistributedMember>(advisor.adviseDataStore());
        recipients.remove(pr2.getDistributionManager().getDistributionManagerId());
        if (recipients.size() > 0) {
            processor = (RemoveIndexesResponse)new RemoveIndexesMessage().createReplyProcessor(pr2, recipients);
        }
        if (removeAllIndex) {
            RemoveIndexesMessage rm2 = new RemoveIndexesMessage(recipients, pr2.getPRId(), (ReplyProcessor21)processor);
            pr2.getDistributionManager().putOutgoing(rm2);
        } else {
            RemoveIndexesMessage rm3 = new RemoveIndexesMessage(recipients, pr2.getPRId(), processor, true, ind.getName());
            pr2.getDistributionManager().putOutgoing(rm3);
        }
        return processor;
    }

    @Override
    PartitionMessage.PartitionResponse createReplyProcessor(PartitionedRegion r, Set recipients) {
        return new RemoveIndexesResponse(r.getSystem(), recipients);
    }

    @Override
    public int getDSFID() {
        return 59;
    }

    @Override
    public final void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.removeSingleIndex = in.readBoolean();
        if (this.removeSingleIndex) {
            this.indexName = in.readUTF();
        }
    }

    @Override
    public final void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeBoolean(this.removeSingleIndex);
        if (this.removeSingleIndex) {
            out.writeUTF(this.indexName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void process(DistributionManager dm) {
        Throwable thr = null;
        boolean sendReply = true;
        PartitionedRegion pr2 = null;
        try {
            logger.info(LocalizedMessage.create(LocalizedStrings.RemoveIndexesMessage_TRYING_TO_GET_PR_WITH_ID___0, this.regionId));
            pr2 = PartitionedRegion.getPRFromId(this.regionId);
            logger.info(LocalizedMessage.create(LocalizedStrings.RemoveIndexesMessage_REMOVE_INDEXES_MESSAGE_GOT_THE_PR__0, pr2));
            if (pr2 == null) {
                throw new PartitionedRegionException(LocalizedStrings.RemoveIndexesMessage_COULD_NOT_GET_PARTITIONED_REGION_FROM_ID_0_FOR_MESSAGE_1_RECEIVED_ON_MEMBER_2_MAP_3.toLocalizedString(this.regionId, this, dm.getId(), PartitionedRegion.dumpPRId()));
            }
            sendReply = this.operateOnPartitionedRegion(dm, pr2, 0L);
        }
        catch (PRLocallyDestroyedException pde) {
            if (logger.isDebugEnabled()) {
                logger.debug("Region is locally Destroyed ");
            }
            thr = pde;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (this.processorId == 0) {
                logger.debug("{} exception while processing message: {}", this, t.getMessage(), t);
            } else if (logger.isTraceEnabled(LogMarker.DM) && t instanceof RuntimeException) {
                logger.debug("Exception caught while processing message: {}", t.getMessage(), t);
            }
            if (t instanceof RegionDestroyedException && pr2 != null) {
                if (pr2.isClosed) {
                    logger.info(LocalizedMessage.create(LocalizedStrings.RemoveIndexesMessage_REGION_IS_LOCALLY_DESTROYED_THROWING_REGIONDESTROYEDEXCEPTION_FOR__0, pr2));
                    thr = new RegionDestroyedException(LocalizedStrings.RemoveIndexesMessage_REGION_IS_LOCALLY_DESTROYED_ON_0.toLocalizedString(dm.getId()), pr2.getFullPath());
                }
            } else {
                thr = t;
            }
        }
        finally {
            if (sendReply && this.processorId != 0) {
                ReplyException rex = null;
                if (thr != null) {
                    rex = new ReplyException(thr);
                }
                this.sendReply(this.getSender(), this.processorId, dm, rex, pr2, 0L);
            }
        }
    }

    public static final class RemoveIndexesReplyMessage
    extends ReplyMessage {
        private boolean result;
        private int numBucketsIndexesRemoved;
        private int numTotalBuckets;

        public RemoveIndexesReplyMessage() {
        }

        RemoveIndexesReplyMessage(int processorId, ReplyException ex, boolean result, int numBucketsIndexesRemoved, int numTotalBuckets) {
            super.setException(ex);
            this.result = result;
            this.numBucketsIndexesRemoved = numBucketsIndexesRemoved;
            this.numTotalBuckets = numTotalBuckets;
            this.setProcessorId(processorId);
        }

        @Override
        public int getDSFID() {
            return 60;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.result = in.readBoolean();
            this.numBucketsIndexesRemoved = in.readInt();
            this.numTotalBuckets = in.readInt();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.result);
            out.writeInt(this.numBucketsIndexesRemoved);
            out.writeInt(this.numTotalBuckets);
        }

        public static void send(InternalDistributedMember recipient, int processorId, DM dm, ReplyException ex, boolean result, int numBucketsIndexesRemoved, int numTotalBuckets) {
            RemoveIndexesReplyMessage rmIndMsg = new RemoveIndexesReplyMessage(processorId, ex, result, numBucketsIndexesRemoved, numTotalBuckets);
            rmIndMsg.setRecipient(recipient);
            dm.putOutgoing(rmIndMsg);
        }

        @Override
        public final void process(DM dm, ReplyProcessor21 p) {
            RemoveIndexesResponse processor = (RemoveIndexesResponse)p;
            if (processor != null) {
                processor.setResponse(this.result, this.numBucketsIndexesRemoved, this.numTotalBuckets);
                processor.process(this);
            }
        }
    }

    public static class RemoveIndexesResult {
        public RemoveIndexesResult(int numBucketIndexRemoved) {
        }
    }

    public static class RemoveIndexesResponse
    extends PartitionMessage.PartitionResponse {
        private int numBucketIndexRemoved;
        private int numTotalRemoteBuckets;

        public RemoveIndexesResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, recipients);
        }

        public RemoveIndexesResult waitForResults() throws CacheException, ForceReattemptException {
            this.waitForCacheException();
            return new RemoveIndexesResult(0);
        }

        public void setResponse(boolean result, int numBucketsIndexesRemoved, int numTotalBuckets) {
            this.numBucketIndexRemoved += numBucketsIndexesRemoved;
            this.numTotalRemoteBuckets += numTotalBuckets;
        }

        public int getRemoteRemovedIndexes() {
            return this.numBucketIndexRemoved;
        }

        public int getTotalRemoteBuckets() {
            return this.numTotalRemoteBuckets;
        }
    }
}

