/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned.rebalance;

import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.PartitionedRegionLoadModel;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.RebalanceDirectorAdapter;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class MovePrimariesFPR
extends RebalanceDirectorAdapter {
    private static final Logger logger = LogService.getLogger();
    private PartitionedRegionLoadModel model;

    @Override
    public void initialize(PartitionedRegionLoadModel model) {
        this.model = model;
    }

    @Override
    public void membershipChanged(PartitionedRegionLoadModel model) {
        this.initialize(model);
    }

    @Override
    public boolean nextStep() {
        this.makeFPRPrimaryForThisNode();
        return false;
    }

    private void makeFPRPrimaryForThisNode() {
        PartitionedRegion partitionedRegion = this.model.getPartitionedRegion();
        List<FixedPartitionAttributesImpl> FPAs = partitionedRegion.getFixedPartitionAttributesImpl();
        InternalDistributedMember targetId = partitionedRegion.getDistributionManager().getId();
        PartitionedRegionLoadModel.MemberRollup target = this.model.getMember(targetId);
        for (PartitionedRegionLoadModel.BucketRollup bucket : this.model.getBuckets()) {
            if (bucket == null) continue;
            for (FixedPartitionAttributesImpl fpa : FPAs) {
                PartitionedRegionLoadModel.Member source;
                if (!fpa.hasBucket(bucket.getId()) || !fpa.isPrimary() || (source = bucket.getPrimary()) == target) continue;
                PartitionedRegionLoadModel.Member member = source = source == null || source == this.model.INVALID_MEMBER ? target : source;
                if (logger.isDebugEnabled()) {
                    logger.debug("PRLM#movePrimariesForFPR: For Bucket#{}, moving primary from source {} to target {}", bucket.getId(), bucket.getPrimary(), target);
                }
                boolean successfulMove = this.model.movePrimary(new PartitionedRegionLoadModel.Move(source, target, bucket));
                Assert.assertTrue(successfulMove, " Fixed partitioned region not able to move the primary!");
                if (!successfulMove) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("PRLM#movePrimariesForFPR: For Bucket#{}, moved primary from source {} to target {}", bucket.getId(), bucket.getPrimary(), target);
                }
                ((PartitionedRegionLoadModel.Bucket)bucket).setPrimary(target, bucket.getPrimaryLoad());
            }
        }
    }
}

