/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned.rebalance;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.PartitionedRegionLoadModel;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.RebalanceDirectorAdapter;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;

public class PercentageMoveDirector
extends RebalanceDirectorAdapter {
    private PartitionedRegionLoadModel model;
    private final InternalDistributedMember source;
    private final InternalDistributedMember target;
    private final float percentage;
    private float loadToMove;
    private NavigableSet<PartitionedRegionLoadModel.Bucket> orderedBuckets;

    public PercentageMoveDirector(DistributedMember source, DistributedMember target, float percentage) {
        this.source = (InternalDistributedMember)source;
        this.target = (InternalDistributedMember)target;
        this.percentage = percentage;
    }

    @Override
    public void initialize(PartitionedRegionLoadModel model) {
        PartitionedRegionLoadModel.MemberRollup sourceMember = model.getMember(this.source);
        if (sourceMember == null) {
            throw new IllegalStateException(LocalizedStrings.PERCENTAGE_MOVE_DIRECTORY_SOURCE_NOT_DATA_STORE.toLocalizedString(model.getName(), this.source));
        }
        float sourceLoad = sourceMember.getTotalLoad();
        this.loadToMove = sourceLoad * this.percentage / 100.0f;
        this.membershipChanged(model);
    }

    @Override
    public void membershipChanged(PartitionedRegionLoadModel model) {
        this.model = model;
        PartitionedRegionLoadModel.MemberRollup sourceMember = model.getMember(this.source);
        if (sourceMember == null) {
            throw new IllegalStateException(LocalizedStrings.PERCENTAGE_MOVE_DIRECTORY_SOURCE_NOT_DATA_STORE.toLocalizedString(model.getName(), this.source));
        }
        this.orderedBuckets = new TreeSet<PartitionedRegionLoadModel.Bucket>(new LoadComparator());
        for (PartitionedRegionLoadModel.Bucket bucket : sourceMember.getBuckets()) {
            float bucketLoad = bucket.getLoad();
            if (!(bucketLoad <= this.loadToMove)) continue;
            this.orderedBuckets.add(bucket);
        }
    }

    @Override
    public boolean nextStep() {
        PartitionedRegionLoadModel.MemberRollup targetMember = this.model.getMember(this.target);
        PartitionedRegionLoadModel.MemberRollup sourceMember = this.model.getMember(this.source);
        if (targetMember == null) {
            throw new IllegalStateException(LocalizedStrings.PERCENTAGE_MOVE_DIRECTORY_TARGET_NOT_DATA_STORE.toLocalizedString(this.model.getName(), this.target));
        }
        if (targetMember.equals(sourceMember)) {
            throw new IllegalStateException(LocalizedStrings.PERCENTAGE_MOVE_TARGET_SAME_AS_SOURCE.toLocalizedString(this.model.getName(), this.target));
        }
        if (this.orderedBuckets.isEmpty()) {
            return false;
        }
        PartitionedRegionLoadModel.Bucket bucket = (PartitionedRegionLoadModel.Bucket)this.orderedBuckets.last();
        float load = bucket.getLoad();
        if (((PartitionedRegionLoadModel.Member)targetMember).willAcceptBucket(bucket, sourceMember, this.model.enforceUniqueZones()).willAccept() && this.model.moveBucket(new PartitionedRegionLoadModel.Move(sourceMember, targetMember, bucket))) {
            PartitionedRegionLoadModel.Bucket next2;
            this.loadToMove -= load;
            Iterator<PartitionedRegionLoadModel.Bucket> itr = this.orderedBuckets.descendingIterator();
            while (itr.hasNext() && (next2 = itr.next()).getLoad() > this.loadToMove) {
                itr.remove();
            }
        }
        this.orderedBuckets.remove(bucket);
        return true;
    }

    private static class LoadComparator
    implements Comparator<PartitionedRegionLoadModel.Bucket> {
        private LoadComparator() {
        }

        @Override
        public int compare(PartitionedRegionLoadModel.Bucket o1, PartitionedRegionLoadModel.Bucket o2) {
            int result = Float.compare(o1.getLoad(), o2.getLoad());
            if (result == 0) {
                result = o2.getId() - o1.getId();
            }
            return result;
        }
    }
}

