/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.JarClassLoader;
import com.gemstone.gemfire.internal.JarDeployer;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.persistence.BackupInspector;
import com.gemstone.gemfire.internal.cache.persistence.RestoreScript;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class BackupManager
implements MembershipListener {
    public static final String INCOMPLETE_BACKUP = "INCOMPLETE_BACKUP";
    public static final String README = "README.txt";
    public static final String DATA_STORES = "diskstores";
    public static final String USER_FILES = "user";
    public static final String CONFIG = "config";
    private InternalDistributedMember sender;
    private GemFireCacheImpl cache;
    private CountDownLatch allowDestroys = new CountDownLatch(1);
    private volatile boolean isCancelled = false;

    public BackupManager(InternalDistributedMember sender, GemFireCacheImpl gemFireCache) {
        this.sender = sender;
        this.cache = gemFireCache;
    }

    public void start() {
        DM distributionManager = this.cache.getDistributedSystem().getDistributionManager();
        Set allIds = distributionManager.addAllMembershipListenerAndGetAllIds(this);
        if (!allIds.contains(this.sender)) {
            this.cleanup();
            throw new IllegalStateException("The admin member requesting a backup has already departed");
        }
    }

    private void cleanup() {
        this.isCancelled = true;
        this.allowDestroys.countDown();
        Collection<DiskStoreImpl> diskStores = this.cache.listDiskStoresIncludingRegionOwned();
        for (DiskStoreImpl store : diskStores) {
            store.releaseBackupLock();
        }
        DM distributionManager = this.cache.getDistributedSystem().getDistributionManager();
        distributionManager.removeAllMembershipListener(this);
        this.cache.clearBackupManager();
    }

    public HashSet<PersistentID> prepareBackup() {
        HashSet<PersistentID> persistentIds = new HashSet<PersistentID>();
        Collection<DiskStoreImpl> diskStores = this.cache.listDiskStoresIncludingRegionOwned();
        for (DiskStoreImpl store : diskStores) {
            store.lockStoreBeforeBackup();
            if (!store.hasPersistedData()) continue;
            persistentIds.add(store.getPersistentID());
            store.getStats().startBackup();
        }
        return persistentIds;
    }

    private File findBaselineForThisMember(File baselineParentDir) {
        File baselineDir = null;
        for (DiskStoreImpl diskStore : this.cache.listDiskStoresIncludingRegionOwned()) {
            baselineDir = FileUtil.find(baselineParentDir, ".*" + diskStore.getBackupDirName() + "$");
            if (null == baselineDir) continue;
            break;
        }
        if (null != baselineDir) {
            baselineDir = baselineDir.getParentFile().getParentFile();
        }
        return baselineDir;
    }

    private File checkBaseline(File baselineParentDir) throws IOException {
        File baselineDir = null;
        if (null != baselineParentDir) {
            File incompleteBackup;
            baselineDir = this.getBackupDir(baselineParentDir);
            if (!baselineDir.exists()) {
                baselineDir = this.findBaselineForThisMember(baselineParentDir);
            }
            if (null != baselineDir && (incompleteBackup = new File(baselineDir, INCOMPLETE_BACKUP)).exists()) {
                baselineDir = null;
            }
        }
        return baselineDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<PersistentID> finishBackup(File targetDir, File baselineDir) throws IOException {
        try {
            File backupDir = this.getBackupDir(targetDir);
            baselineDir = this.checkBaseline(baselineDir);
            BackupInspector inspector = baselineDir == null ? null : BackupInspector.createInspector(baselineDir);
            File storesDir = new File(backupDir, DATA_STORES);
            RestoreScript restoreScript = new RestoreScript();
            HashSet<PersistentID> persistentIds = new HashSet<PersistentID>();
            ArrayList<DiskStoreImpl> diskStores = new ArrayList<DiskStoreImpl>(this.cache.listDiskStoresIncludingRegionOwned());
            boolean foundPersistentData = false;
            Iterator itr = diskStores.iterator();
            while (itr.hasNext()) {
                DiskStoreImpl store = (DiskStoreImpl)itr.next();
                if (store.hasPersistedData()) {
                    if (!foundPersistentData) {
                        this.createBackupDir(backupDir);
                        foundPersistentData = true;
                    }
                    File diskStoreDir = new File(storesDir, store.getBackupDirName());
                    diskStoreDir.mkdir();
                    store.startBackup(diskStoreDir, inspector, restoreScript);
                } else {
                    itr.remove();
                }
                store.releaseBackupLock();
            }
            this.allowDestroys.countDown();
            for (DiskStoreImpl store : diskStores) {
                store.finishBackup(this);
                store.getStats().endBackup();
                persistentIds.add(store.getPersistentID());
            }
            if (foundPersistentData) {
                this.backupConfigFiles(restoreScript, backupDir);
                this.backupUserFiles(restoreScript, backupDir);
                this.backupDeployedJars(restoreScript, backupDir);
                restoreScript.generate(backupDir);
                File incompleteFile = new File(backupDir, INCOMPLETE_BACKUP);
                if (!incompleteFile.delete()) {
                    throw new IOException("Could not delete file INCOMPLETE_BACKUP");
                }
            }
            HashSet<PersistentID> hashSet = persistentIds;
            return hashSet;
        }
        finally {
            this.cleanup();
        }
    }

    private void backupConfigFiles(RestoreScript restoreScript, File backupDir) throws IOException {
        URL propertyURL;
        File configBackupDir = new File(backupDir, CONFIG);
        FileUtil.mkdirs(configBackupDir);
        URL url = this.cache.getCacheXmlURL();
        if (url != null) {
            File cacheXMLBackup = new File(configBackupDir, DistributionConfig.DEFAULT_CACHE_XML_FILE.getName());
            FileUtil.copy(url, cacheXMLBackup);
        }
        if ((propertyURL = DistributedSystem.getPropertyFileURL()) != null) {
            File propertyBackup = new File(configBackupDir, "gemfire.properties");
            FileUtil.copy(propertyURL, propertyBackup);
        }
    }

    private void backupUserFiles(RestoreScript restoreScript, File backupDir) throws IOException {
        List<File> backupFiles = this.cache.getBackupFiles();
        File userBackupDir = new File(backupDir, USER_FILES);
        if (!userBackupDir.exists()) {
            userBackupDir.mkdir();
        }
        for (File original : backupFiles) {
            if (!original.exists()) continue;
            original = original.getAbsoluteFile();
            File dest = new File(userBackupDir, original.getName());
            FileUtil.copy(original, dest);
            restoreScript.addExistenceTest(original);
            restoreScript.addFile(original, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupDeployedJars(RestoreScript restoreScript, File backupDir) throws IOException {
        JarDeployer deployer = null;
        try {
            deployer = new JarDeployer();
            deployer.suspendAll();
            List<JarClassLoader> jarList = deployer.findJarClassLoaders();
            if (!jarList.isEmpty()) {
                File userBackupDir = new File(backupDir, USER_FILES);
                if (!userBackupDir.exists()) {
                    userBackupDir.mkdir();
                }
                for (JarClassLoader loader : jarList) {
                    File source = new File(loader.getFileCanonicalPath());
                    File dest = new File(userBackupDir, source.getName());
                    FileUtil.copy(source, dest);
                    restoreScript.addFile(source, dest);
                }
            }
        }
        finally {
            if (null != deployer) {
                deployer.resumeAll();
            }
        }
    }

    private File getBackupDir(File targetDir) throws IOException {
        InternalDistributedMember memberId = this.cache.getDistributedSystem().getDistributedMember();
        String vmId = memberId.toString();
        vmId = this.cleanSpecialCharacters(vmId);
        File backupDir = new File(targetDir, vmId);
        return backupDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBackupDir(File backupDir) throws IOException {
        if (backupDir.exists()) {
            throw new IOException("Backup directory " + backupDir.getAbsolutePath() + " already exists.");
        }
        if (!FileUtil.mkdirs(backupDir)) {
            throw new IOException("Could not create directory: " + backupDir);
        }
        File incompleteFile = new File(backupDir, INCOMPLETE_BACKUP);
        if (!incompleteFile.createNewFile()) {
            throw new IOException("Could not create file: " + incompleteFile);
        }
        File readme = new File(backupDir, README);
        try (FileOutputStream fos = new FileOutputStream(readme);){
            String text = LocalizedStrings.BackupManager_README.toLocalizedString();
            fos.write(text.getBytes());
        }
    }

    private String cleanSpecialCharacters(String string) {
        return string.replaceAll("[^\\w]+", "_");
    }

    @Override
    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
        this.cleanup();
    }

    @Override
    public void memberJoined(InternalDistributedMember id) {
    }

    @Override
    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    @Override
    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected) {
    }

    public void waitForBackup() {
        try {
            this.allowDestroys.await();
        }
        catch (InterruptedException e) {
            throw new InternalGemFireError(e);
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }
}

