/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberPattern;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PersistentMembershipView
implements DataSerializable {
    private Set<PersistentMemberID> offlineMembers;
    private Map<InternalDistributedMember, PersistentMemberID> onlineMembers;
    private Set<PersistentMemberPattern> revokedMembers;

    public PersistentMembershipView() {
    }

    public PersistentMembershipView(Set<PersistentMemberID> offlineMembers, Map<InternalDistributedMember, PersistentMemberID> onlineMembers, Set<PersistentMemberPattern> revokedMembers) {
        this.offlineMembers = offlineMembers;
        this.onlineMembers = onlineMembers;
        this.revokedMembers = revokedMembers;
    }

    public Set<PersistentMemberID> getOfflineMembers() {
        return this.offlineMembers;
    }

    public Map<InternalDistributedMember, PersistentMemberID> getOnlineMembers() {
        return this.onlineMembers;
    }

    public Set<PersistentMemberPattern> getRevokedMembers() {
        return this.revokedMembers;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int offlineSize = in.readInt();
        this.offlineMembers = new HashSet<PersistentMemberID>(offlineSize);
        for (int i = 0; i < offlineSize; ++i) {
            PersistentMemberID id = new PersistentMemberID();
            InternalDataSerializer.invokeFromData(id, in);
            this.offlineMembers.add(id);
        }
        int onlineSize = in.readInt();
        this.onlineMembers = new HashMap<InternalDistributedMember, PersistentMemberID>(onlineSize);
        for (int i = 0; i < onlineSize; ++i) {
            InternalDistributedMember member = new InternalDistributedMember();
            InternalDataSerializer.invokeFromData(member, in);
            PersistentMemberID id = new PersistentMemberID();
            InternalDataSerializer.invokeFromData(id, in);
            this.onlineMembers.put(member, id);
        }
        int revokedSized = in.readInt();
        this.revokedMembers = new HashSet<PersistentMemberPattern>(revokedSized);
        for (int i = 0; i < revokedSized; ++i) {
            PersistentMemberPattern pattern = new PersistentMemberPattern();
            InternalDataSerializer.invokeFromData(pattern, in);
            this.revokedMembers.add(pattern);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.offlineMembers.size());
        for (PersistentMemberID persistentMemberID : this.offlineMembers) {
            InternalDataSerializer.invokeToData(persistentMemberID, out);
        }
        out.writeInt(this.onlineMembers.size());
        for (Map.Entry entry : this.onlineMembers.entrySet()) {
            InternalDataSerializer.invokeToData(entry.getKey(), out);
            InternalDataSerializer.invokeToData(entry.getValue(), out);
        }
        out.writeInt(this.revokedMembers.size());
        for (PersistentMemberPattern persistentMemberPattern : this.revokedMembers) {
            InternalDataSerializer.invokeToData(persistentMemberPattern, out);
        }
    }

    public String toString() {
        return "PersistentMembershipView[offline=" + this.offlineMembers + ",online=" + this.onlineMembers + ", revoked=" + this.revokedMembers + "]";
    }
}

