/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import com.gemstone.gemfire.internal.cache.persistence.soplog.CompositeSerializedComparator;
import com.gemstone.gemfire.internal.cache.persistence.soplog.DelegatingSerializedComparator;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SoplogToken;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedReader;
import com.gemstone.gemfire.internal.util.Bytes;
import java.nio.ByteBuffer;

public class ArraySerializedComparator
implements CompositeSerializedComparator,
DelegatingSerializedComparator {
    private volatile SortedReader.SerializedComparator[] comparators;

    @Override
    public void setComparators(SortedReader.SerializedComparator[] comparators) {
        this.comparators = comparators;
    }

    @Override
    public int compare(byte[] o1, byte[] o2) {
        return this.compare(o1, 0, o1.length, o2, 0, o2.length);
    }

    @Override
    public int compare(byte[] b1, int o1, int l1, byte[] b2, int o2, int l2) {
        SortedReader.SerializedComparator[] sc = this.comparators;
        int off1 = o1;
        int off2 = o2;
        for (int i = 0; i < sc.length - 1; ++i) {
            int diff;
            int klen1 = Bytes.getVarInt(b1, off1);
            int klen2 = Bytes.getVarInt(b2, off2);
            if (!SoplogToken.isWildcard(b1, off1 += Bytes.sizeofVarInt(klen1), b2, off2 += Bytes.sizeofVarInt(klen2)) && (diff = sc[i].compare(b1, off1, klen1, b2, off2, klen2)) != 0) {
                return diff;
            }
            off1 += klen1;
            off2 += klen2;
        }
        if (!SoplogToken.isWildcard(b1, off1, b2, off2)) {
            return sc[sc.length - 1].compare(b1, off1, l1 -= off1 - o1, b2, off2, l2 -= off2 - o2);
        }
        return 0;
    }

    @Override
    public SortedReader.SerializedComparator[] getComparators() {
        return this.comparators;
    }

    @Override
    public byte[] createCompositeKey(byte[] key1, byte[] key2) {
        return this.createCompositeKey(new byte[][]{key1, key2});
    }

    @Override
    public byte[] createCompositeKey(byte[] ... keys) {
        assert (this.comparators.length == keys.length);
        int size2 = 0;
        for (int i = 0; i < keys.length - 1; ++i) {
            size2 += keys[i].length + Bytes.sizeofVarInt(keys[i].length);
        }
        int off = 0;
        byte[] buf = new byte[size2 += keys[keys.length - 1].length];
        for (int i = 0; i < keys.length - 1; ++i) {
            off = Bytes.putVarInt(keys[i].length, buf, off);
            System.arraycopy(keys[i], 0, buf, off, keys[i].length);
            off += keys[i].length;
        }
        System.arraycopy(keys[keys.length - 1], 0, buf, off, keys[keys.length - 1].length);
        return buf;
    }

    @Override
    public ByteBuffer getKey(ByteBuffer key2, int ordinal) {
        assert (ordinal < this.comparators.length);
        for (int i = 0; i < this.comparators.length - 1; ++i) {
            int klen = Bytes.getVarInt(key2);
            if (i == ordinal) {
                ByteBuffer subkey = (ByteBuffer)key2.slice().limit(klen);
                key2.rewind();
                return subkey;
            }
            key2.position(key2.position() + klen);
        }
        ByteBuffer subkey = key2.slice();
        key2.rewind();
        return subkey;
    }
}

