/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedReader;
import com.gemstone.gemfire.internal.util.Bytes;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class LexicographicalComparator
implements SortedReader.SerializedComparator {
    private static final int BYTE_TO_BYTE = 14135;
    private static final int BYTE_TO_SHORT = 14136;
    private static final int BYTE_TO_INT = 14137;
    private static final int BYTE_TO_LONG = 14138;
    private static final int BYTE_TO_FLOAT = 14139;
    private static final int BYTE_TO_DOUBLE = 14140;
    private static final int SHORT_TO_BYTE = 14391;
    private static final int SHORT_TO_SHORT = 14392;
    private static final int SHORT_TO_INT = 14393;
    private static final int SHORT_TO_LONG = 14394;
    private static final int SHORT_TO_FLOAT = 14395;
    private static final int SHORT_TO_DOUBLE = 14396;
    private static final int LONG_TO_BYTE = 14903;
    private static final int LONG_TO_SHORT = 14904;
    private static final int LONG_TO_INT = 14905;
    private static final int LONG_TO_LONG = 14906;
    private static final int LONG_TO_FLOAT = 14907;
    private static final int LONG_TO_DOUBLE = 14908;
    private static final int INT_TO_BYTE = 14647;
    private static final int INT_TO_SHORT = 14648;
    private static final int INT_TO_INT = 14649;
    private static final int INT_TO_LONG = 14650;
    private static final int INT_TO_FLOAT = 14651;
    private static final int INT_TO_DOUBLE = 14652;
    private static final int FLOAT_TO_BYTE = 15159;
    private static final int FLOAT_TO_SHORT = 15160;
    private static final int FLOAT_TO_INT = 15161;
    private static final int FLOAT_TO_LONG = 15162;
    private static final int FLOAT_TO_FLOAT = 15163;
    private static final int FLOAT_TO_DOUBLE = 15164;
    private static final int DOUBLE_TO_BYTE = 15415;
    private static final int DOUBLE_TO_SHORT = 15416;
    private static final int DOUBLE_TO_INT = 15417;
    private static final int DOUBLE_TO_LONG = 15418;
    private static final int DOUBLE_TO_FLOAT = 15419;
    private static final int DOUBLE_TO_DOUBLE = 15420;
    private static final int STRING_TO_STRING = 10794;
    private static final int STRING_TO_STRING_BYTES = 10839;
    private static final int STRING_BYTES_TO_STRING = 22314;
    private static final int STRING_BYTES_TO_STRING_BYTES = 22359;

    @Override
    public int compare(byte[] o1, byte[] o2) {
        return this.compare(o1, 0, o1.length, o2, 0, o2.length);
    }

    @Override
    public int compare(byte[] b1, int o1, int l1, byte[] b2, int o2, int l2) {
        byte type1 = b1[o1];
        byte type2 = b2[o2];
        if (LexicographicalComparator.isString(type1) && LexicographicalComparator.isString(type2)) {
            return LexicographicalComparator.compareAsString(type1, b1, o1, type2, b2, o2);
        }
        if (LexicographicalComparator.isNumeric(type1) && LexicographicalComparator.isNumeric(type2)) {
            return LexicographicalComparator.compareAsNumeric(type1, b1, o1, type2, b2, o2);
        }
        if (type1 == 53 && type2 == 53) {
            return LexicographicalComparator.compareAsBoolean(LexicographicalComparator.getBoolean(b1, o1), LexicographicalComparator.getBoolean(b2, o2));
        }
        if (type1 == 54 && type2 == 54) {
            return LexicographicalComparator.compareAsChar(LexicographicalComparator.getChar(b1, o1), LexicographicalComparator.getChar(b2, o2));
        }
        if (type1 == 41 || type2 == 41) {
            return type1 == type2 ? 0 : (type1 == 41 ? 1 : -1);
        }
        return LexicographicalComparator.compareAsObject(b1, o1, l1, b2, o2, l2);
    }

    private static boolean isNumeric(int type) {
        return type == 55 || type == 56 || type == 57 || type == 58 || type == 59 || type == 60;
    }

    private static boolean isString(int type) {
        return type == 42 || type == 87;
    }

    private static int compareAsString(byte type1, byte[] b1, int o1, byte type2, byte[] b2, int o2) {
        switch (type1 << 8 | type2) {
            case 10794: {
                return LexicographicalComparator.compareAsStringOfUtf(b1, o1, b2, o2);
            }
            case 10839: {
                return -LexicographicalComparator.compareAsStringOfByteToUtf(b2, o2, b1, o1);
            }
            case 22314: {
                return LexicographicalComparator.compareAsStringOfByteToUtf(b1, o1, b2, o2);
            }
            case 22359: {
                return LexicographicalComparator.compareAsStringOfByte(b1, o1, b2, o2);
            }
        }
        throw new ClassCastException(String.format("Incomparable types: %d %d", type1, type2));
    }

    private static int compareAsNumeric(byte type1, byte[] b1, int o1, byte type2, byte[] b2, int o2) {
        switch (type1 << 8 | type2) {
            case 14135: {
                return LexicographicalComparator.compareAsShort(LexicographicalComparator.getByte(b1, o1), LexicographicalComparator.getByte(b2, o2));
            }
            case 14136: {
                return LexicographicalComparator.compareAsShort(LexicographicalComparator.getByte(b1, o1), LexicographicalComparator.getShort(b2, o2));
            }
            case 14137: {
                return LexicographicalComparator.compareAsInt(LexicographicalComparator.getByte(b1, o1), LexicographicalComparator.getInt(b2, o2));
            }
            case 14138: {
                return LexicographicalComparator.compareAsLong(LexicographicalComparator.getByte(b1, o1), LexicographicalComparator.getLong(b2, o2));
            }
            case 14139: {
                return LexicographicalComparator.compareAsFloat(LexicographicalComparator.getByte(b1, o1), LexicographicalComparator.getFloat(b2, o2));
            }
            case 14140: {
                return LexicographicalComparator.compareAsDouble(LexicographicalComparator.getByte(b1, o1), LexicographicalComparator.getDouble(b2, o2));
            }
            case 14391: {
                return LexicographicalComparator.compareAsShort(LexicographicalComparator.getShort(b1, o1), LexicographicalComparator.getByte(b2, o2));
            }
            case 14392: {
                return LexicographicalComparator.compareAsShort(LexicographicalComparator.getShort(b1, o1), LexicographicalComparator.getShort(b2, o2));
            }
            case 14393: {
                return LexicographicalComparator.compareAsInt(LexicographicalComparator.getShort(b1, o1), LexicographicalComparator.getInt(b2, o2));
            }
            case 14394: {
                return LexicographicalComparator.compareAsLong(LexicographicalComparator.getShort(b1, o1), LexicographicalComparator.getLong(b2, o2));
            }
            case 14395: {
                return LexicographicalComparator.compareAsFloat(LexicographicalComparator.getShort(b1, o1), LexicographicalComparator.getFloat(b2, o2));
            }
            case 14396: {
                return LexicographicalComparator.compareAsDouble(LexicographicalComparator.getShort(b1, o1), LexicographicalComparator.getDouble(b2, o2));
            }
            case 14647: {
                return LexicographicalComparator.compareAsInt(LexicographicalComparator.getInt(b1, o1), LexicographicalComparator.getByte(b2, o2));
            }
            case 14648: {
                return LexicographicalComparator.compareAsInt(LexicographicalComparator.getInt(b1, o1), LexicographicalComparator.getShort(b2, o2));
            }
            case 14649: {
                return LexicographicalComparator.compareAsInt(LexicographicalComparator.getInt(b1, o1), LexicographicalComparator.getInt(b2, o2));
            }
            case 14650: {
                return LexicographicalComparator.compareAsLong(LexicographicalComparator.getInt(b1, o1), LexicographicalComparator.getLong(b2, o2));
            }
            case 14651: {
                return LexicographicalComparator.compareAsFloat(LexicographicalComparator.getInt(b1, o1), LexicographicalComparator.getFloat(b2, o2));
            }
            case 14652: {
                return LexicographicalComparator.compareAsDouble(LexicographicalComparator.getInt(b1, o1), LexicographicalComparator.getDouble(b2, o2));
            }
            case 14903: {
                return LexicographicalComparator.compareAsLong(LexicographicalComparator.getLong(b1, o1), LexicographicalComparator.getByte(b2, o2));
            }
            case 14904: {
                return LexicographicalComparator.compareAsLong(LexicographicalComparator.getLong(b1, o1), LexicographicalComparator.getShort(b2, o2));
            }
            case 14905: {
                return LexicographicalComparator.compareAsLong(LexicographicalComparator.getLong(b1, o1), LexicographicalComparator.getInt(b2, o2));
            }
            case 14906: {
                return LexicographicalComparator.compareAsLong(LexicographicalComparator.getLong(b1, o1), LexicographicalComparator.getLong(b2, o2));
            }
            case 14907: {
                return LexicographicalComparator.compareAsDouble(LexicographicalComparator.getLong(b1, o1), LexicographicalComparator.getFloat(b2, o2));
            }
            case 14908: {
                return LexicographicalComparator.compareAsDouble(LexicographicalComparator.getLong(b1, o1), LexicographicalComparator.getDouble(b2, o2));
            }
            case 15159: {
                return LexicographicalComparator.compareAsFloat(LexicographicalComparator.getFloat(b1, o1), LexicographicalComparator.getByte(b2, o2));
            }
            case 15160: {
                return LexicographicalComparator.compareAsFloat(LexicographicalComparator.getFloat(b1, o1), LexicographicalComparator.getShort(b2, o2));
            }
            case 15161: {
                return LexicographicalComparator.compareAsFloat(LexicographicalComparator.getFloat(b1, o1), LexicographicalComparator.getInt(b2, o2));
            }
            case 15162: {
                return LexicographicalComparator.compareAsFloat(LexicographicalComparator.getFloat(b1, o1), LexicographicalComparator.getLong(b2, o2));
            }
            case 15163: {
                return LexicographicalComparator.compareAsFloat(LexicographicalComparator.getFloat(b1, o1), LexicographicalComparator.getFloat(b2, o2));
            }
            case 15164: {
                return LexicographicalComparator.compareAsDouble(LexicographicalComparator.getFloat(b1, o1), LexicographicalComparator.getDouble(b2, o2));
            }
            case 15415: {
                return LexicographicalComparator.compareAsDouble(LexicographicalComparator.getDouble(b1, o1), LexicographicalComparator.getByte(b2, o2));
            }
            case 15416: {
                return LexicographicalComparator.compareAsDouble(LexicographicalComparator.getDouble(b1, o1), LexicographicalComparator.getShort(b2, o2));
            }
            case 15417: {
                return LexicographicalComparator.compareAsDouble(LexicographicalComparator.getDouble(b1, o1), LexicographicalComparator.getInt(b2, o2));
            }
            case 15418: {
                return LexicographicalComparator.compareAsDouble(LexicographicalComparator.getDouble(b1, o1), LexicographicalComparator.getLong(b2, o2));
            }
            case 15419: {
                return LexicographicalComparator.compareAsDouble(LexicographicalComparator.getDouble(b1, o1), LexicographicalComparator.getFloat(b2, o2));
            }
            case 15420: {
                return LexicographicalComparator.compareAsDouble(LexicographicalComparator.getDouble(b1, o1), LexicographicalComparator.getDouble(b2, o2));
            }
        }
        throw new ClassCastException(String.format("Incomparable types: %d %d", type1, type2));
    }

    private static int compareAsBoolean(boolean b1, boolean b2) {
        return b1 == b2 ? 0 : (b1 ? 1 : -1);
    }

    private static int compareAsShort(short s1, short s2) {
        return s1 - s2;
    }

    private static int compareAsChar(char c1, char c2) {
        return c1 - c2;
    }

    private static int compareAsInt(long l1, long l2) {
        return (int)(l1 - l2);
    }

    private static int compareAsLong(long l1, long l2) {
        return l1 < l2 ? -1 : (l1 == l2 ? 0 : 1);
    }

    private static int compareAsFloat(float f1, float f2) {
        return Float.compare(f1, f2);
    }

    private static int compareAsDouble(double d1, double d2) {
        return Double.compare(d1, d2);
    }

    private static int compareAsStringOfByte(byte[] b1, int o1, byte[] b2, int o2) {
        int offset = 3;
        int l1 = Bytes.toUnsignedShort(b1[o1 + 1], b1[o1 + 2]);
        int l2 = Bytes.toUnsignedShort(b2[o1 + 1], b2[o1 + 2]);
        assert (b1.length >= o1 + offset + l1);
        assert (b2.length >= o2 + offset + l2);
        int end = o1 + offset + Math.min(l1, l2);
        int i = o1 + offset;
        int j = o2 + offset;
        while (i < end) {
            int diff = b1[i] - b2[j];
            if (diff != 0) {
                return diff;
            }
            ++i;
            ++j;
        }
        return l1 - l2;
    }

    private static int compareAsStringOfUtf(byte[] b1, int o1, byte[] b2, int o2) {
        int j;
        int jlen;
        int ilen;
        int offset = 3;
        int l1 = Bytes.toUnsignedShort(b1[o1 + 1], b1[o1 + 2]);
        int l2 = Bytes.toUnsignedShort(b2[o1 + 1], b2[o1 + 2]);
        assert (b1.length >= o1 + offset + l1);
        assert (b2.length >= o2 + offset + l2);
        int i = 0;
        for (j = 0; i < l1 && j < l2; i += ilen, j += jlen) {
            int idx = o1 + offset + i;
            ilen = LexicographicalComparator.getUtfLength(b1[idx]);
            char c1 = LexicographicalComparator.getUtfChar(b1, idx, ilen);
            int jdx = o2 + offset + j;
            jlen = LexicographicalComparator.getUtfLength(b2[jdx]);
            char c2 = LexicographicalComparator.getUtfChar(b2, jdx, jlen);
            int diff = LexicographicalComparator.compareAsChar(c1, c2);
            if (diff == 0) continue;
            return diff;
        }
        return l1 - i - (l2 - j);
    }

    private static int compareAsStringOfByteToUtf(byte[] b1, int o1, byte[] b2, int o2) {
        int j;
        int jlen;
        int offset = 3;
        int l1 = Bytes.toUnsignedShort(b1[o1 + 1], b1[o1 + 2]);
        int l2 = Bytes.toUnsignedShort(b2[o1 + 1], b2[o1 + 2]);
        assert (b1.length >= o1 + offset + l1);
        assert (b2.length >= o2 + offset + l2);
        int i = 0;
        for (j = 0; i < l1 && j < l2; ++i, j += jlen) {
            int idx = o1 + offset + i;
            char c1 = (char)b1[idx];
            int jdx = o2 + offset + j;
            jlen = LexicographicalComparator.getUtfLength(b2[jdx]);
            char c2 = LexicographicalComparator.getUtfChar(b2, jdx, jlen);
            int diff = LexicographicalComparator.compareAsChar(c1, c2);
            if (diff == 0) continue;
            return diff;
        }
        return l1 - i - (l2 - j);
    }

    private static int compareAsObject(byte[] b1, int o1, int l1, byte[] b2, int o2, int l2) {
        DataInputStream in1 = new DataInputStream(new ByteArrayInputStream(b1, o1, l1));
        DataInputStream in2 = new DataInputStream(new ByteArrayInputStream(b2, o2, l2));
        try {
            Comparable obj1 = (Comparable)DataSerializer.readObject(in1);
            Comparable obj2 = (Comparable)DataSerializer.readObject(in2);
            return obj1.compareTo(obj2);
        }
        catch (Exception e) {
            throw (RuntimeException)new ClassCastException().initCause(e);
        }
    }

    private static int getUtfLength(byte b) {
        int c = b & 0xFF;
        if (c < 128) {
            return 1;
        }
        if (c < 224) {
            return 2;
        }
        return 3;
    }

    private static char getUtfChar(byte[] b, int off, int len) {
        assert (b.length >= off + len);
        switch (len) {
            case 1: {
                return (char)b[off];
            }
            case 2: {
                return LexicographicalComparator.getUtf2(b, off);
            }
        }
        return LexicographicalComparator.getUtf3(b, off);
    }

    private static char getUtf2(byte[] b, int off) {
        assert (b.length >= off + 2);
        assert ((b[off] & 0xFF) >= 192);
        assert ((b[off] & 0xFF) < 224);
        assert ((b[off + 1] & 0xFF) >= 128);
        return (char)((b[off] & 0x1F) << 6 | b[off + 1] & 0x3F);
    }

    private static char getUtf3(byte[] b, int off) {
        assert (b.length >= off + 3);
        assert ((b[off] & 0xFF) >= 224);
        assert ((b[off + 1] & 0xFF) >= 128);
        assert ((b[off + 2] & 0xFF) >= 128);
        return (char)((b[off] & 0xF) << 12 | (b[off + 1] & 0x3F) << 6 | b[off + 2] & 0x3F);
    }

    private static boolean getBoolean(byte[] b, int off) {
        assert (b.length >= off + 2);
        return b[off + 1] != 0;
    }

    private static byte getByte(byte[] b, int off) {
        assert (b.length >= off + 2);
        return b[off + 1];
    }

    private static short getShort(byte[] b, int off) {
        assert (b.length >= off + 3);
        return Bytes.toShort(b[off + 1], b[off + 2]);
    }

    private static char getChar(byte[] b, int off) {
        assert (b.length >= off + 3);
        return Bytes.toChar(b[off + 1], b[off + 2]);
    }

    private static int getInt(byte[] b, int off) {
        assert (b.length >= off + 5);
        return Bytes.toInt(b[off + 1], b[off + 2], b[off + 3], b[off + 4]);
    }

    private static long getLong(byte[] b, int off) {
        assert (b.length >= off + 9);
        return Bytes.toLong(b[off + 1], b[off + 2], b[off + 3], b[off + 4], b[off + 5], b[off + 6], b[off + 7], b[off + 8]);
    }

    private static float getFloat(byte[] b, int off) {
        assert (b.length >= off + 5);
        return Float.intBitsToFloat(LexicographicalComparator.getInt(b, off));
    }

    private static double getDouble(byte[] b, int off) {
        assert (b.length >= off + 9);
        return Double.longBitsToDouble(LexicographicalComparator.getLong(b, off));
    }
}

