/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import com.gemstone.gemfire.internal.cache.persistence.soplog.AbstractCompactor;
import com.gemstone.gemfire.internal.cache.persistence.soplog.Compactor;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplog;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogFactory;
import com.gemstone.gemfire.internal.cache.persistence.soplog.TrackedReference;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class SizeTieredCompactor
extends AbstractCompactor<Integer> {
    private final int maxFilesPerLevel;
    private final int maxLevels;

    public SizeTieredCompactor(SortedOplogFactory factory, Compactor.Fileset<Integer> fileset, Compactor.CompactionTracker<Integer> tracker, Executor exec, int maxFilesPerLevel, int maxLevels) throws IOException {
        super(factory, fileset, tracker, exec);
        assert (maxFilesPerLevel > 0);
        assert (maxLevels > 0);
        this.maxFilesPerLevel = maxFilesPerLevel;
        this.maxLevels = maxLevels;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}Creating size-tiered compactor", this.logPrefix);
        }
        for (int i = 0; i < maxLevels; ++i) {
            this.levels.add(new OrderedLevel(i));
        }
        for (Map.Entry<Integer, Iterable<File>> entry : fileset.recover().entrySet()) {
            int level = Math.min(maxLevels - 1, entry.getKey());
            for (File f : entry.getValue()) {
                if (isDebugEnabled) {
                    logger.debug("{}Adding {} to level {}", this.logPrefix, f, level);
                }
                ((AbstractCompactor.Level)this.levels.get(level)).add(factory.createSortedOplog(f));
            }
        }
    }

    public String toString() {
        return String.format("%s <%d/%d>", this.factory.getConfiguration().getName(), this.maxFilesPerLevel, this.maxLevels);
    }

    protected class OrderedLevel
    extends AbstractCompactor.Level {
        private final Deque<TrackedReference<SortedOplog.SortedOplogReader>> soplogs;
        private final AtomicBoolean isCompacting;

        public OrderedLevel(int level) {
            super(level);
            this.soplogs = new ArrayDeque<TrackedReference<SortedOplog.SortedOplogReader>>(SizeTieredCompactor.this.maxFilesPerLevel);
            this.isCompacting = new AtomicBoolean(false);
        }

        @Override
        protected synchronized boolean needsCompaction() {
            return !this.isCompacting.get() && this.soplogs.size() >= SizeTieredCompactor.this.maxFilesPerLevel && this.level != SizeTieredCompactor.this.maxLevels - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<TrackedReference<SortedOplog.SortedOplogReader>> getSnapshot(byte[] start, byte[] end) {
            ArrayList<TrackedReference<SortedOplog.SortedOplogReader>> snap;
            OrderedLevel orderedLevel = this;
            synchronized (orderedLevel) {
                snap = new ArrayList<TrackedReference<SortedOplog.SortedOplogReader>>(this.soplogs);
            }
            for (TrackedReference trackedReference : snap) {
                trackedReference.increment();
            }
            return snap;
        }

        @Override
        protected synchronized void clear() throws IOException {
            for (TrackedReference<SortedOplog.SortedOplogReader> tr : this.soplogs) {
                tr.get().close();
            }
            SizeTieredCompactor.this.markAsInactive(this.soplogs, this.level);
            this.soplogs.clear();
        }

        @Override
        protected synchronized void close() throws IOException {
            for (TrackedReference<SortedOplog.SortedOplogReader> tr : this.soplogs) {
                tr.get().close();
                SizeTieredCompactor.this.factory.getConfiguration().getStatistics().incActiveFiles(-1);
            }
            this.soplogs.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void add(SortedOplog soplog) throws IOException {
            SortedOplog.SortedOplogReader rdr = soplog.createReader();
            OrderedLevel orderedLevel = this;
            synchronized (orderedLevel) {
                this.soplogs.addFirst(new TrackedReference<SortedOplog.SortedOplogReader>(rdr));
            }
            if (AbstractCompactor.logger.isDebugEnabled()) {
                AbstractCompactor.logger.debug("{}Added file {} to level {}", SizeTieredCompactor.this.logPrefix, rdr, this.level);
            }
            SizeTieredCompactor.this.tracker.fileAdded(rdr.getFile(), this.level);
            SizeTieredCompactor.this.factory.getConfiguration().getStatistics().incActiveFiles(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean compact(AtomicBoolean aborted) throws IOException {
            assert (this.level < SizeTieredCompactor.this.maxLevels) : "Can't compact level: " + this.level;
            if (!this.isCompacting.compareAndSet(false, true)) {
                return false;
            }
            try {
                List<TrackedReference<SortedOplog.SortedOplogReader>> snapshot = this.getSnapshot(null, null);
                try {
                    SortedOplog merged = SizeTieredCompactor.this.merge(snapshot, this.level == SizeTieredCompactor.this.maxLevels - 1, aborted);
                    OrderedLevel orderedLevel = this;
                    synchronized (orderedLevel) {
                        if (merged != null) {
                            ((AbstractCompactor.Level)SizeTieredCompactor.this.levels.get(Math.min(this.level + 1, SizeTieredCompactor.this.maxLevels - 1))).add(merged);
                        }
                        SizeTieredCompactor.this.markAsInactive(snapshot, this.level);
                        this.soplogs.removeAll(snapshot);
                    }
                }
                catch (InterruptedIOException e) {
                    if (AbstractCompactor.logger.isDebugEnabled()) {
                        AbstractCompactor.logger.debug("{}Aborting compaction of level {}", SizeTieredCompactor.this.logPrefix, this.level);
                    }
                    boolean bl = false;
                    boolean set = this.isCompacting.compareAndSet(true, false);
                    assert (set);
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                boolean set = this.isCompacting.compareAndSet(true, false);
                assert (set);
            }
        }
    }
}

